/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.audit.impl;

import com.modeliosoft.modelio.audit.cp.IAuditConfigurationPoint;
import com.modeliosoft.modelio.audit.plugin.AuditCom;
import com.modeliosoft.modelio.expertises.core.expertise.IExpertise;
import com.modeliosoft.modelio.expertises.core.expertise.IExpertiseListener;
import com.modeliosoft.modelio.expertises.core.expertise.IExpertiseService;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.modelio.app.project.core.services.IProjectService;
import org.modelio.audit.preferences.model.AuditConfigurationModel;
import org.modelio.audit.preferences.model.AuditReconfiguration;
import org.modelio.audit.preferences.model.AuditRule;
import org.modelio.audit.service.AuditSeverity;
import org.modelio.audit.service.IAuditService;
import org.modelio.gproject.gproject.GProject;
import org.modelio.vbasic.files.FileUtils;

@Creatable
public class ExpertiseListener
implements IExpertiseListener {
    private static final String PROJECT_AUDIT_CONF_PATH = ".config/audit/auditconfiguration.properties";
    @Inject
    @Optional
    private IAuditService auditService;
    @Inject
    @Optional
    private IProjectService projectService;
    @Inject
    private StatusReporter errReporter;

    public void expertisesChanged(IExpertiseService expertiseService, List<IExpertise> activatedExpertises, List<IExpertise> deactivatedExpertises) {
        GProject openedProject = this.projectService.getOpenedProject();
        if (openedProject == null) {
            return;
        }
        try {
            this.configureFrom(openedProject, expertiseService.getActiveExpertises());
        }
        catch (FileSystemException e) {
            AuditCom.LOG.error((Throwable)e);
            this.errReporter.show(4, FileUtils.getLocalizedMessage((IOException)e), (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            AuditCom.LOG.error((Throwable)e);
            this.errReporter.show(4, e.getLocalizedMessage(), (Throwable)e, new Object[0]);
        }
    }

    private void configureFrom(GProject project, List<IExpertise> expertises) throws IOException {
        AuditConfigurationModel baseModel = this.getBaseConfiguration(project);
        AuditReconfiguration reconfiguration = new AuditReconfiguration();
        for (IExpertise expertise : expertises) {
            IAuditConfigurationPoint cp = (IAuditConfigurationPoint)expertise.getConfigurationPoint(IAuditConfigurationPoint.class);
            if (cp == null) continue;
            cp.reconfigureAudit(reconfiguration);
        }
        this.applyAuditReconfiguration(baseModel, reconfiguration);
        this.auditService.apply(baseModel);
    }

    private static File getBundleFile(String relPath) throws IOException {
        File theFile;
        URL url = AuditCom.getContext().getBundle().getEntry(relPath);
        if (url == null) {
            return null;
        }
        try {
            theFile = new File(URIUtil.toURI((URL)url));
        }
        catch (URISyntaxException e) {
            NoSuchFileException err = new NoSuchFileException(FileLocator.toFileURL((URL)url).toString(), null, e.getLocalizedMessage());
            err.initCause(e);
            throw err;
        }
        return theFile;
    }

    public void expertiseAdded(IExpertiseService expertiseService, IExpertise expertise) {
    }

    public void expertiseRemoved(IExpertiseService expertiseService, IExpertise expertise) {
    }

    private void applyAuditReconfiguration(AuditConfigurationModel baseModel, AuditReconfiguration reconfiguration) {
        AuditRule baseRule;
        for (Map.Entry o : reconfiguration.getSeverities().entrySet()) {
            baseRule = baseModel.get((String)o.getKey());
            if (baseRule != null) {
                baseRule.setSeverity((AuditSeverity)o.getValue());
                continue;
            }
            AuditCom.LOG.warning("Unable to reconfigure rule severity %s, rule not found", new Object[]{o.getKey()});
        }
        for (Map.Entry o : reconfiguration.getStates().entrySet()) {
            baseRule = baseModel.get((String)o.getKey());
            if (baseRule != null) {
                baseRule.setEnabled((Boolean)o.getValue());
                continue;
            }
            AuditCom.LOG.warning("Unable to reconfigure rule enable state %s, rule not found", new Object[]{o.getKey()});
        }
        for (AuditRule auditRule : reconfiguration.getAddedRules()) {
            baseModel.add(auditRule);
        }
    }

    private AuditConfigurationModel getBaseConfiguration(GProject project) {
        File projFile = project.getProjectDataPath().resolve("data").resolve(PROJECT_AUDIT_CONF_PATH).toFile();
        this.auditService.setConfigurationFile(projFile);
        return this.auditService.getConfigurationModel();
    }
}

