/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.modelio.linkeditor.plugin.LinkEditor;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.transactions.ITransaction;

public class LinkEditorCommandStack
extends CommandStack {
    private final Supplier<Optional<ICoreSession>> sessionGetter = () -> Optional.ofNullable((ICoreSession)session.get());

    public LinkEditorCommandStack(Supplier<ICoreSession> session) {
    }

    public boolean canRedo() {
        return this.sessionGetter.get().map(s -> s.getTransactionSupport().hasRedo()).orElse(false);
    }

    public boolean canUndo() {
        return this.sessionGetter.get().map(s -> s.getTransactionSupport().hasUndo()).orElse(false);
    }

    public void undo() {
        Command command = null;
        this.notifyListeners(command, 4);
        try {
            this.sessionGetter.get().get().getTransactionSupport().undo();
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 32);
        }
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        Command command = null;
        this.notifyListeners(command, 2);
        try {
            this.sessionGetter.get().get().getTransactionSupport().redo();
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 16);
        }
    }

    public int getUndoLimit() {
        return -1;
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }

    public boolean isDirty() {
        return this.sessionGetter.get().map(s -> s.getTransactionSupport().hasUndo()).orElse(false);
    }

    public void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.notifyListeners(command, 1);
        try {
            ICoreSession transactionManager = this.sessionGetter.get().get();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ITransaction t = transactionManager.getTransactionSupport().createTransaction(command.getLabel());){
                    command.execute();
                    t.commit();
                    this.notifyListeners();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LinkEditor.LOG.error((Throwable)e);
            }
        }
        finally {
            this.notifyListeners(command, 8);
        }
    }

    public void markSaveLocation() {
    }
}

