/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.background;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.modelio.linkeditor.gef.background.DropEditPolicy;
import org.modelio.linkeditor.panel.ILinkEditorConfiguration;
import org.modelio.linkeditor.panel.model.BackgroundModel;
import org.modelio.linkeditor.panel.model.EdgeBus;
import org.modelio.linkeditor.panel.model.GraphNode;
import org.modelio.platform.ui.UIColor;

public class BackgroundEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    private static int HORIZONTAL_LAYOUT_RANK_BASE;
    private static int HORIZONTAL_LAYOUT_OFFSET_SPACING;
    private static int VERTICAL_LAYOUT_RANK_BASE;
    private static int VERTICAL_LAYOUT_OFFSET_SPACING;
    public static final String LAYOUT_ORIENTATION = "LAYOUT_ORIENTATION";
    public static final String EDIT_MODE = "EDIT_MODE";
    public static final String VIEWERPROP_SWITCH_EDIT_MODE = "switchEditModeRunnable";
    private final IEclipseContext context;

    public void activate() {
        super.activate();
        this.getModel().addPropertyChangeListener(this);
        this.getViewer().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        this.getModel().removePropertyChangeListener(this);
        this.getViewer().removePropertyChangeListener((PropertyChangeListener)this);
        super.deactivate();
    }

    public BackgroundModel getModel() {
        return (BackgroundModel)((Object)super.getModel());
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            ((Runnable)this.getViewer().getProperty(VIEWERPROP_SWITCH_EDIT_MODE)).run();
            this.getModel().fireContentChanged();
        } else {
            super.performRequest(req);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Content")) {
            HORIZONTAL_LAYOUT_RANK_BASE = GraphNode.WIDTH * 75 / 100;
            HORIZONTAL_LAYOUT_OFFSET_SPACING = GraphNode.HEIGHT * 125 / 100;
            VERTICAL_LAYOUT_RANK_BASE = -GraphNode.HEIGHT * 75 / 100;
            VERTICAL_LAYOUT_OFFSET_SPACING = GraphNode.WIDTH * 125 / 100;
            this.refreshChildren();
            this.refreshVisuals();
        }
        if (evt.getPropertyName().equals(EDIT_MODE)) {
            this.refreshVisuals();
        }
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        Node model = (Node)childEditPart.getModel();
        this.getContentPane().add(child, (Object)new Rectangle(model.x, model.y, model.width, model.height), index);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DropEditPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer freeformLayer = new FreeformLayer();
        freeformLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        freeformLayer.setOpaque(true);
        Color swtColor = this.isEditMode() ? UIColor.TEXT_WRITABLE_BG : UIColor.POSTIT_YELLOW;
        freeformLayer.setBackgroundColor(swtColor);
        return freeformLayer;
    }

    protected List<?> getModelChildren() {
        BackgroundModel directedGraph = this.getModel();
        boolean vertical = this.isVerticalLayout();
        GraphNode center = directedGraph.getCenter();
        if (center != null) {
            int offsetLeft = this.layout(center, 0, 0, vertical, true);
            int offsetRight = this.layout(center, 0, 0, vertical, false);
            int offset = Math.max(offsetLeft, offsetRight);
            this.layout(center, 0, (offset - offsetLeft) / 2, vertical, true);
            this.layout(center, 0, (offset - offsetRight) / 2, vertical, false);
            this.fixBusesSize(directedGraph, vertical);
            this.shiftAll(directedGraph);
        }
        return directedGraph.nodes;
    }

    private void fixBusesSize(BackgroundModel directedGraph, boolean vertical) {
        for (Object node : directedGraph.nodes) {
            int dy;
            int dx;
            if (!(node instanceof EdgeBus)) continue;
            EdgeBus edgeBus = (EdgeBus)((Object)node);
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (Object incomingEdge : edgeBus.incoming) {
                Node source = ((Edge)incomingEdge).source;
                if (vertical) {
                    dx = source.x + source.width / 2;
                    min = Math.min(min, dx - source.width / 8);
                    max = Math.max(max, dx + source.width / 8);
                    continue;
                }
                dy = source.y + source.height / 2;
                min = Math.min(min, dy - source.height / 4);
                max = Math.max(max, dy + source.height / 4);
            }
            for (Object outgoingEdge : edgeBus.outgoing) {
                Node target = ((Edge)outgoingEdge).target;
                if (vertical) {
                    dx = target.x + target.width / 2;
                    min = Math.min(min, dx - target.width / 8);
                    max = Math.max(max, dx + target.width / 8);
                    continue;
                }
                dy = target.y + target.height / 2;
                min = Math.min(min, dy - target.height / 4);
                max = Math.max(max, dy + target.height / 4);
            }
            if (vertical) {
                edgeBus.x = min;
                edgeBus.width = max - min;
                continue;
            }
            edgeBus.y = min;
            edgeBus.height = max - min;
        }
    }

    private Point getViewAreaSize() {
        final Point controlSize = new Point(0, 0);
        this.getViewer().getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Control control = BackgroundEditPart.this.getViewer().getControl();
                Point p = control.getSize();
                controlSize.x = p.x;
                controlSize.y = p.y;
                if (control instanceof Scrollable) {
                    Scrollable c = (Scrollable)control;
                    ScrollBar b = c.getHorizontalBar();
                    if (b != null) {
                        controlSize.y -= b.getSize().y;
                    }
                    if ((b = c.getVerticalBar()) != null) {
                        controlSize.x -= b.getSize().x;
                    }
                }
            }
        });
        return controlSize;
    }

    private int layout(Node node, int rank, int offset, boolean vertical, boolean direct) {
        int rankSpacing = vertical ? VERTICAL_LAYOUT_RANK_BASE : HORIZONTAL_LAYOUT_RANK_BASE;
        int offsetSpacing = vertical ? VERTICAL_LAYOUT_OFFSET_SPACING : HORIZONTAL_LAYOUT_OFFSET_SPACING;
        int newOffset = offset;
        EdgeList edges = direct ? node.outgoing : node.incoming;
        for (Object edgeObj : edges) {
            Node nextNode;
            Edge edge = (Edge)edgeObj;
            Node node2 = nextNode = direct ? edge.target : edge.source;
            int rankIncrement = node instanceof EdgeBus ? rankSpacing * 2 : (nextNode instanceof EdgeBus ? rankSpacing : rankSpacing * 2);
            int nextRank = direct ? rank + rankIncrement : rank - rankIncrement;
            newOffset = offsetSpacing + this.layout(nextNode, nextRank, newOffset, vertical, direct);
        }
        if (edges.size() > 0) {
            newOffset -= offsetSpacing;
        }
        if (vertical) {
            node.x = offset + (newOffset - offset) / 2;
            node.y = rank - node.height / 2;
        } else {
            node.x = rank - node.width / 2;
            node.y = offset + (newOffset - offset) / 2;
        }
        return newOffset;
    }

    private void shiftAll(BackgroundModel directedGraph) {
        Point controlSize = this.getViewAreaSize();
        if (controlSize.x <= 0 || controlSize.y <= 0) {
            return;
        }
        GraphNode centerNode = directedGraph.getCenter();
        int xDelta = controlSize.x / 2 - (centerNode.x + centerNode.width / 2);
        int yDelta = controlSize.y / 2 - (centerNode.y + centerNode.height / 2);
        for (Object nodeObj : directedGraph.nodes) {
            Node node = (Node)nodeObj;
            node.x += xDelta;
            node.y += yDelta;
        }
    }

    public BackgroundEditPart(IEclipseContext context) {
        this.context = context;
    }

    public boolean isEditMode() {
        return Boolean.TRUE.equals(this.getViewer().getProperty(EDIT_MODE));
    }

    public boolean isVerticalLayout() {
        return this.getViewer().getProperty(LAYOUT_ORIENTATION) == ILinkEditorConfiguration.Orientation.Vertical;
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Color swtColor = this.isEditMode() ? UIColor.TEXT_WRITABLE_BG : UIColor.POSTIT_YELLOW;
        this.getFigure().setBackgroundColor(swtColor);
    }
}

