/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.background;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class BackgroundLayout
extends FreeformLayout {
    private static final int offset = 200;
    private Map<IFigure, Rectangle> cachedPositions = new HashMap<IFigure, Rectangle>();
    private static final Rectangle REFERENCE_RECTANGLE = new Rectangle(0, 0, 100, 50);

    public void layout(IFigure parent) {
        Point offsetPoint = this.getOrigin(parent);
        for (Object obj : parent.getChildren()) {
            IFigure f = (IFigure)obj;
            Rectangle bounds = this.getPosition(f);
            bounds = bounds.getTranslated(offsetPoint);
            f.setBounds(bounds);
        }
    }

    protected Dimension calculatePreferredSize(IFigure f, int wHint, int hHint) {
        Rectangle rect = new Rectangle();
        ListIterator children = f.getChildren().listIterator();
        while (children.hasNext()) {
            IFigure child = (IFigure)children.next();
            Rectangle r = this.getPosition(child);
            if (r == null) continue;
            if (r.width == -1 || r.height == -1) {
                Dimension preferredSizeDimension = child.getPreferredSize(r.width, r.height);
                r = r.getCopy();
                if (r.width == -1) {
                    r.width = preferredSizeDimension.width;
                }
                if (r.height == -1) {
                    r.height = preferredSizeDimension.height;
                }
            }
            rect.union(r);
        }
        Dimension d = rect.getSize();
        Insets insets = f.getInsets();
        return new Dimension(d.width + insets.getWidth(), d.height + insets.getHeight()).union(this.getBorderPreferredSize(f));
    }

    public Point getConstraint(IFigure figure) {
        return (Point)super.getConstraint(figure);
    }

    private Rectangle getPosition(IFigure figure) {
        this.cachedPositions.isEmpty();
        return this.cachedPositions.get(figure);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        this.cachedPositions.clear();
    }
}

