/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.background;

import java.util.Set;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Display;
import org.modelio.api.module.mda.IMdaExpert;
import org.modelio.linkeditor.LinkTypeDescriptor;
import org.modelio.linkeditor.gef.background.typeselection.LinkTypeSelectionDialog;
import org.modelio.linkeditor.gef.background.typeselection.TypeSelectionModel;
import org.modelio.metamodel.bpmn.flows.BpmnMessageFlow;
import org.modelio.metamodel.bpmn.processCollaboration.BpmnCollaboration;
import org.modelio.metamodel.bpmn.processCollaboration.BpmnParticipant;
import org.modelio.metamodel.uml.infrastructure.MethodologicalLink;
import org.modelio.metamodel.uml.infrastructure.ModelElement;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.vcore.model.api.IElementNamerService;
import org.modelio.vcore.model.api.IModelFactoryService;
import org.modelio.vcore.model.api.MTools;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MDependency;
import org.modelio.vcore.smkernel.mapi.MExpert;
import org.modelio.vcore.smkernel.mapi.MObject;

public class CreateLinkCommand
extends Command {
    private boolean isFrom;
    private TypeSelectionModel typeModel;
    private MObject refElement;
    private MObject[] droppedElements;
    private IMdaExpert mdaExpert;

    public CreateLinkCommand(MObject refElement, MObject[] droppedElements, boolean isFrom, Set<LinkTypeDescriptor> candidates, IMdaExpert mdaExpert) {
        this.refElement = refElement;
        this.droppedElements = droppedElements;
        this.isFrom = isFrom;
        this.typeModel = new TypeSelectionModel(refElement, droppedElements, isFrom, candidates);
        this.mdaExpert = mdaExpert;
    }

    public boolean canExecute() {
        if (this.typeModel.isEmpty()) {
            return false;
        }
        if (this.isFrom && !this.refElement.isModifiable()) {
            return false;
        }
        if (!this.isFrom) {
            MObject[] mObjectArray = this.droppedElements;
            int n = this.droppedElements.length;
            int n2 = 0;
            while (n2 < n) {
                MObject o = mObjectArray[n2];
                if (!o.isModifiable()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void execute() {
        MTools mTools = MTools.get((MObject)this.refElement);
        IElementNamerService namer = mTools.getNamer();
        IModelFactoryService factory = mTools.getModelFactories();
        if (this.typeModel.isEmpty()) {
            return;
        }
        LinkTypeDescriptor typeToUse = this.promptUser(this.typeModel);
        if (typeToUse == null) {
            return;
        }
        MClass mc = typeToUse.getMClass();
        Stereotype st = typeToUse.getStereotype();
        MObject[] mObjectArray = this.droppedElements;
        int n = this.droppedElements.length;
        int n2 = 0;
        while (n2 < n) {
            MObject source;
            ModelElement createdLink;
            block10: {
                MExpert mExpert;
                block11: {
                    BpmnCollaboration collab;
                    MObject target;
                    block12: {
                        MObject droppedElement = mObjectArray[n2];
                        createdLink = (ModelElement)factory.createElement(mc);
                        if (st != null) {
                            createdLink.getExtension().add((Object)st);
                        }
                        if (this.isFrom) {
                            source = this.refElement;
                            target = droppedElement;
                        } else {
                            source = droppedElement;
                            target = this.refElement;
                        }
                        mExpert = mc.getMetamodel().getMExpert();
                        mExpert.setSource((MObject)createdLink, null, source);
                        mExpert.setTarget((MObject)createdLink, null, target);
                        if (createdLink.getCompositionOwner() != null) break block10;
                        if (!(createdLink instanceof BpmnMessageFlow)) break block11;
                        if (!(source instanceof BpmnParticipant)) break block12;
                        collab = ((BpmnParticipant)source).getContainer();
                        ((BpmnMessageFlow)createdLink).setCollaboration(collab);
                        break block10;
                    }
                    if (!(target instanceof BpmnParticipant)) break block10;
                    collab = ((BpmnParticipant)target).getContainer();
                    ((BpmnMessageFlow)createdLink).setCollaboration(collab);
                    break block10;
                }
                MObject potentialOwner = source.getCompositionOwner();
                boolean isOrphan = true;
                while (isOrphan && potentialOwner != null) {
                    MDependency compositionDep = mExpert.getDefaultCompositionDep(potentialOwner, (MObject)createdLink);
                    if (compositionDep != null) {
                        potentialOwner.mGet(compositionDep).add(createdLink);
                        isOrphan = false;
                        continue;
                    }
                    potentialOwner = potentialOwner.getCompositionOwner();
                }
            }
            createdLink.setName(namer.getUniqueName((MObject)createdLink));
            if (createdLink instanceof MethodologicalLink && st != null && !this.mdaExpert.isMultiple(st)) {
                for (MethodologicalLink link : ((ModelElement)source).getDependsOnDependency(MethodologicalLink.class)) {
                    if (createdLink == link || !link.isStereotyped(st)) continue;
                    link.delete();
                }
            }
            ++n2;
        }
    }

    private LinkTypeDescriptor promptUser(TypeSelectionModel model) {
        if (model.getTypes().size() == 1) {
            return model.getTypes().iterator().next();
        }
        LinkTypeSelectionDialog popup = new LinkTypeSelectionDialog(Display.getDefault().getActiveShell(), model);
        popup.setBlockOnOpen(true);
        if (popup.open() == 0) {
            return model.getSelectedType();
        }
        return null;
    }
}

