/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.background;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.modelio.api.module.mda.IMdaExpert;
import org.modelio.linkeditor.LinkTypeDescriptor;
import org.modelio.linkeditor.gef.background.BackgroundEditPart;
import org.modelio.linkeditor.gef.background.CreateLinkCommand;
import org.modelio.linkeditor.panel.ILinkEditorConfiguration;
import org.modelio.linkeditor.panel.ILinkEditorFilter;
import org.modelio.linkeditor.panel.model.BackgroundModel;
import org.modelio.linkeditor.panel.model.GraphNode;
import org.modelio.metamodel.mda.ModuleComponent;
import org.modelio.metamodel.mmextensions.standard.services.MModelServices;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.platform.mda.infra.service.IModuleService;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.impl.CoreSession;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MObject;

public class DropEditPolicy
extends XYLayoutEditPolicy {
    private final XYAnchor dummyXYAnchor = new XYAnchor(new Point(10, 10));
    private PolylineConnection connectionFeedback;
    private final ChopboxAnchor dummyChopBoxAnchor = new ChopboxAnchor(null);

    protected Command getCreateCommand(CreateRequest request) {
        BackgroundEditPart ep = (BackgroundEditPart)this.getHost();
        MObject[] droppedElements = (MObject[])request.getExtendedData().get("dropped elements");
        if (droppedElements != null && droppedElements.length > 0 && ep.isEditMode() && this.getCenterNode() != null) {
            boolean isFrom = this.getSide(request);
            Set<LinkTypeDescriptor> candidates = this.collectTypes(this.getCenterNode().getData(), droppedElements, isFrom);
            return new CreateLinkCommand(this.getCenterNode().getData(), droppedElements, isFrom, candidates, ((IModuleService)ep.getContext().get(IModuleService.class)).getMdaExpert());
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return null;
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (!(request instanceof CreateRequest)) {
            return;
        }
        CreateRequest createRequest = (CreateRequest)request;
        GraphNode centerNode = this.getCenterNode();
        GraphicalEditPart centerNodeEditPart = (GraphicalEditPart)this.getHost().getViewer().getEditPartRegistry().get((Object)centerNode);
        IFigure centerNodeFigure = centerNodeEditPart.getFigure();
        this.dummyChopBoxAnchor.setOwner(centerNodeFigure);
        this.dummyXYAnchor.setLocation(createRequest.getLocation());
        boolean isFrom = this.getSide(createRequest);
        if (this.connectionFeedback == null) {
            this.connectionFeedback = new PolylineConnection();
            this.connectionFeedback.removeAllPoints();
            this.connectionFeedback.setVisible(true);
            this.connectionFeedback.setOpaque(true);
            this.getFeedbackLayer().add((IFigure)this.connectionFeedback);
        }
        if (isFrom) {
            this.connectionFeedback.setSourceAnchor((ConnectionAnchor)this.dummyXYAnchor);
            this.connectionFeedback.setTargetAnchor((ConnectionAnchor)this.dummyChopBoxAnchor);
        } else {
            this.connectionFeedback.setSourceAnchor((ConnectionAnchor)this.dummyChopBoxAnchor);
            this.connectionFeedback.setTargetAnchor((ConnectionAnchor)this.dummyXYAnchor);
        }
        this.getFeedbackLayer().remove((IFigure)this.connectionFeedback);
        this.getFeedbackLayer().add((IFigure)this.connectionFeedback);
        super.showLayoutTargetFeedback(request);
    }

    public void deactivate() {
        super.deactivate();
        if (this.connectionFeedback != null) {
            this.getFeedbackLayer().remove((IFigure)this.connectionFeedback);
            this.connectionFeedback = null;
        }
    }

    private boolean getSide(CreateRequest request) {
        BackgroundEditPart ep = (BackgroundEditPart)this.getHost();
        GraphNode centerNode = this.getCenterNode();
        boolean vertical = ep.isVerticalLayout();
        if (vertical) {
            return request.getLocation().y < centerNode.y + centerNode.height / 2;
        }
        return request.getLocation().x >= centerNode.x + centerNode.width / 2;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.connectionFeedback != null) {
            this.getFeedbackLayer().remove((IFigure)this.connectionFeedback);
            this.connectionFeedback = null;
        }
        super.eraseLayoutTargetFeedback(request);
    }

    private GraphNode getCenterNode() {
        GraphNode centerNode = ((BackgroundModel)((Object)this.getHost().getModel())).getCenter();
        return centerNode;
    }

    private Set<LinkTypeDescriptor> collectTypes(MObject refElement, MObject[] droppedElements, boolean isFrom) {
        BackgroundEditPart ep = (BackgroundEditPart)this.getHost();
        ILinkEditorConfiguration linkEditorConfiguration = ep.getModel().getConfiguration();
        IModuleService moduleService = (IModuleService)ep.getContext().get(IModuleService.class);
        IMdaExpert mdaExpert = moduleService.getMdaExpert();
        TreeSet<LinkTypeDescriptor> ret = new TreeSet<LinkTypeDescriptor>();
        ILinkEditorFilter configurationFilter = linkEditorConfiguration.getLinkFilter();
        List<MClass> enabledLinkMetaclasses = this.getEnabledLinkMetaclasses(refElement.getMClass().getMetamodel(), configurationFilter);
        MObject[] mObjectArray = droppedElements;
        int n = droppedElements.length;
        int n2 = 0;
        while (n2 < n) {
            MObject droppedElement = mObjectArray[n2];
            for (MClass mc : new ArrayList<MClass>(enabledLinkMetaclasses)) {
                if (!mc.getMetamodel().getMExpert().canLink(mc, isFrom ? refElement : droppedElement, isFrom ? droppedElement : refElement)) {
                    enabledLinkMetaclasses.remove(mc);
                    continue;
                }
                String name = mc.getQualifiedName();
                if (!name.equals("Standard.Association") && !name.equals("Standard.Link") && !name.equals("Standard.Connector")) continue;
                enabledLinkMetaclasses.remove(mc);
            }
            ++n2;
        }
        MModelServices mmService = new MModelServices((ICoreSession)CoreSession.getSession((MObject)refElement));
        MMetamodel metamodel = mmService.getMetamodel();
        for (MClass mc : enabledLinkMetaclasses) {
            if (mc.getQualifiedName().equals("Standard.BpmnMessageFlow")) continue;
            if (configurationFilter.accept(mc, null)) {
                ret.add(new LinkTypeDescriptor(mc, null));
            }
            List<Stereotype> enabledStereotypes = this.getEnabledStereotypes(mmService, moduleService, mc);
            for (Stereotype s : this.filterValidStereotypes(mdaExpert, mc, this.filterStereotypes(configurationFilter, mc, enabledStereotypes), refElement, droppedElements, isFrom)) {
                ret.add(new LinkTypeDescriptor(metamodel.getMClass(s.getBaseClassName()), s));
            }
        }
        return ret;
    }

    private List<MClass> getEnabledLinkMetaclasses(MMetamodel metamodel, ILinkEditorFilter filter) {
        ArrayList<MClass> ret = new ArrayList<MClass>();
        for (MClass mc : metamodel.getRegisteredMClasses()) {
            if (!mc.isLinkMetaclass() || filter != null && !filter.isLinkTypeEnabled(mc)) continue;
            ret.add(mc);
        }
        return ret;
    }

    private List<Stereotype> filterStereotypes(ILinkEditorFilter filter, MClass mc, List<Stereotype> candidatesStereotypes) {
        for (Stereotype st : new ArrayList<Stereotype>(candidatesStereotypes)) {
            if (filter.accept(mc, st)) continue;
            candidatesStereotypes.remove(st);
        }
        return candidatesStereotypes;
    }

    private List<Stereotype> getEnabledStereotypes(MModelServices mmService, IModuleService moduleService, MClass mc) {
        ArrayList<Stereotype> results = new ArrayList<Stereotype>();
        Set activatedModules = moduleService.getStartedModules().stream().map(rtModule -> rtModule.getModel()).map(module -> module.getName()).collect(Collectors.toSet());
        activatedModules.add("LocalModule");
        for (Stereotype st : mmService.findStereotypes(".*", ".*", mc)) {
            ModuleComponent module2 = st.getModule();
            if (!st.isValid() || st.isIsHidden() || module2 == null || !activatedModules.contains(module2.getName())) continue;
            results.add(st);
        }
        return results;
    }

    private List<Stereotype> filterValidStereotypes(IMdaExpert mdaExpert, MClass mc, List<Stereotype> candidatesStereotypes, MObject refElement, MObject[] droppedElements, boolean isFrom) {
        MObject[] mObjectArray = droppedElements;
        int n = droppedElements.length;
        int n2 = 0;
        while (n2 < n) {
            MObject droppedElement = mObjectArray[n2];
            for (Stereotype st : new ArrayList<Stereotype>(candidatesStereotypes)) {
                if (mdaExpert.canLink(st, mc, isFrom ? refElement : droppedElement, isFrom ? droppedElement : refElement)) continue;
                candidatesStereotypes.remove(st);
            }
            ++n2;
        }
        return candidatesStereotypes;
    }
}

