/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.background;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.modelio.api.ui.dnd.ModelElementTransfer;
import org.modelio.platform.project.services.IProjectService;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;

public class LinkEditorDropTargetListener
extends AbstractTransferDropTargetListener {
    public static final String DROPPED_ELEMENTS = "dropped elements";
    private IProjectService projectService;

    public LinkEditorDropTargetListener(EditPartViewer viewer, IProjectService projectService) {
        super(viewer, (Transfer)ModelElementTransfer.getInstance());
        this.setEnablementDeterminedByCommand(true);
        this.projectService = projectService;
    }

    public LinkEditorDropTargetListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    protected CreateRequest createTargetRequest() {
        return new CreateRequest((Object)"create child");
    }

    protected void updateTargetRequest() {
        this.getTargetRequest().setLocation(this.getDropLocation());
        this.setRequestDroppedElements(this.getCurrentEvent());
    }

    private MObject[] getLocalDraggedElements() {
        ArrayList<MObject> selectedElements = new ArrayList<MObject>();
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object o : structuredSelection) {
                if (o instanceof IAdaptable) {
                    IAdaptable adapter = (IAdaptable)o;
                    MObject element = (MObject)adapter.getAdapter(MObject.class);
                    if (element == null) continue;
                    selectedElements.add(element);
                    continue;
                }
                if (!(o instanceof MObject)) continue;
                selectedElements.add((MObject)o);
            }
        }
        return selectedElements.toArray(new MObject[0]);
    }

    protected CreateRequest getTargetRequest() {
        return (CreateRequest)super.getTargetRequest();
    }

    private void setRequestDroppedElements(DropTargetEvent event) {
        if (ModelElementTransfer.getInstance().isSupportedType(event.currentDataType)) {
            ICoreSession session = this.projectService.getSession();
            MObject[] droppedElements = null;
            MRef[] refs = (MRef[])event.data;
            if (refs != null) {
                droppedElements = new MObject[refs.length];
                int i = 0;
                while (i < droppedElements.length) {
                    droppedElements[i] = session.getModel().findByRef(refs[i], IModel.NODELETED);
                    ++i;
                }
            }
            if (droppedElements == null) {
                droppedElements = this.getLocalDraggedElements();
            }
            if (droppedElements != null) {
                this.getTargetRequest().getExtendedData().put(DROPPED_ELEMENTS, droppedElements);
            }
        }
    }
}

