/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.background.typeselection;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.modelio.linkeditor.LinkTypeDescriptor;
import org.modelio.linkeditor.gef.background.typeselection.TypeSelectionContentProvider;
import org.modelio.linkeditor.gef.background.typeselection.TypeSelectionLabelProvider;
import org.modelio.linkeditor.gef.background.typeselection.TypeSelectionModel;
import org.modelio.linkeditor.plugin.LinkEditor;
import org.modelio.metamodel.mda.ModuleComponent;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.platform.mda.infra.MdaResources;
import org.modelio.platform.model.ui.swt.SelectionHelper;
import org.modelio.platform.ui.dialog.ModelioDialog;

public class LinkTypeSelectionDialog
extends ModelioDialog {
    private Composite composite;
    private Button okButton;
    TypeSelectionModel model;

    public LinkTypeSelectionDialog(Shell shell, TypeSelectionModel model) {
        super(shell);
        this.model = model;
        this.setShellStyle(0x10CF0 | Window.getDefaultOrientation());
    }

    public Control createContentArea(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite.setLayout((Layout)new GridLayout(1, true));
        TreeViewer treeViewer = new TreeViewer(this.composite, 2048);
        treeViewer.setContentProvider((IContentProvider)new TypeSelectionContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TypeSelectionLabelProvider((Viewer)treeViewer)));
        treeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                LinkTypeDescriptor descriptor;
                Stereotype stereotype;
                if (element instanceof LinkTypeDescriptor && (stereotype = (descriptor = (LinkTypeDescriptor)element).getStereotype()) != null) {
                    return MdaResources.getModulePriority((ModuleComponent)stereotype.getModule());
                }
                return Integer.MAX_VALUE;
            }
        });
        treeViewer.setInput((Object)this.model);
        treeViewer.expandAll();
        treeViewer.setAutoExpandLevel(2);
        GridData gridData = new GridData(4, 4, true, true);
        treeViewer.getTree().setLayoutData((Object)gridData);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                LinkTypeDescriptor type = (LinkTypeDescriptor)SelectionHelper.getFirst((ISelection)selection, LinkTypeDescriptor.class);
                LinkTypeSelectionDialog.this.model.setSelectedType(type);
                LinkTypeSelectionDialog.this.updateButtons(type);
            }
        });
        return this.composite;
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void init() {
        this.getShell().setText(LinkEditor.I18N.getMessage("TypeSelectionPopup.WindowTitle", new Object[0]));
        this.setTitle(LinkEditor.I18N.getMessage("TypeSelectionPopup.DialogTitle", new Object[0]));
        this.setMessage(LinkEditor.I18N.getMessage("TypeSelectionPopup.DialogMessage", new Object[0]));
        this.getShell().setMinimumSize(400, 300);
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    void updateButtons(Object selection) {
        if (selection instanceof LinkTypeDescriptor) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }
}

