/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.background.typeselection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.modelio.linkeditor.LinkTypeDescriptor;
import org.modelio.linkeditor.gef.background.typeselection.TypeSelectionModel;
import org.modelio.linkeditor.plugin.LinkEditor;

class TypeSelectionContentProvider
implements ITreeContentProvider {
    private Map<Object, List<LinkTypeDescriptor>> types = new HashMap<Object, List<LinkTypeDescriptor>>();

    TypeSelectionContentProvider() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.types.clear();
        TypeSelectionModel selectionModel = (TypeSelectionModel)newInput;
        if (selectionModel != null) {
            for (LinkTypeDescriptor d : selectionModel.getTypes()) {
                Object group = d.getStereotype() != null ? d.getStereotype().getModule() : LinkEditor.I18N.getString("TypeSelectionPopup.Metaclass");
                List<LinkTypeDescriptor> descriptors = this.types.get(group);
                if (descriptors == null) {
                    descriptors = new ArrayList<LinkTypeDescriptor>();
                    this.types.put(group, descriptors);
                }
                descriptors.add(d);
            }
        }
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        return !this.types.getOrDefault(element, Collections.EMPTY_LIST).isEmpty();
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.types.keySet().toArray();
    }

    public Object[] getChildren(Object element) {
        return this.types.getOrDefault(element, Collections.EMPTY_LIST).toArray();
    }
}

