/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.background.typeselection;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.modelio.linkeditor.LinkTypeDescriptor;
import org.modelio.metamodel.mda.ModuleComponent;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.platform.mda.infra.MdaResources;
import org.modelio.platform.model.ui.swt.images.MetamodelImageService;
import org.modelio.platform.ui.UIColor;
import org.modelio.vcore.smkernel.mapi.MClass;

class TypeSelectionLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private StyledString.Styler auxStyler;

    public Image getImage(Object element) {
        if (element instanceof LinkTypeDescriptor) {
            LinkTypeDescriptor type = (LinkTypeDescriptor)element;
            Image stImage = type.getStereotype() != null ? this.getStereotypeImage(type.getStereotype()) : null;
            return stImage != null ? stImage : MetamodelImageService.getIcon((MClass)type.getMClass());
        }
        if (element instanceof ModuleComponent) {
            return this.getModuleImage((ModuleComponent)element);
        }
        return null;
    }

    private Image getModuleImage(ModuleComponent moduleComponent) {
        Image icon = null;
        if (moduleComponent.isValid()) {
            icon = MdaResources.getModuleImage((ModuleComponent)moduleComponent);
        }
        return icon;
    }

    private Image getStereotypeImage(Stereotype stereotype) {
        Image image = null;
        if (stereotype.isValid()) {
            image = MdaResources.getIcon((Stereotype)stereotype);
        }
        return image;
    }

    public TypeSelectionLabelProvider(Viewer viewer) {
        LocalResourceManager res = new LocalResourceManager(JFaceResources.getResources(), viewer.getControl());
        final Font auxFont = res.createFont(FontDescriptor.createFrom((Font)viewer.getControl().getFont()).withStyle(2));
        this.auxStyler = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = auxFont;
                textStyle.foreground = UIColor.LABEL_TIP_FG;
            }
        };
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof String) {
            return this.getStyledText((String)element);
        }
        if (element instanceof ModuleComponent) {
            return this.getModuleLabel((ModuleComponent)element);
        }
        if (element instanceof LinkTypeDescriptor) {
            return this.getStyledText((LinkTypeDescriptor)element);
        }
        return new StyledString(element.toString());
    }

    private StyledString getStyledText(String groupName) {
        return new StyledString(groupName);
    }

    private StyledString getStyledText(LinkTypeDescriptor type) {
        StyledString result = new StyledString();
        if (type.getStereotype() != null) {
            result.append("\u00ab ");
            String label = MdaResources.getLabel((Stereotype)type.getStereotype());
            if (label == null || label.isEmpty()) {
                label = type.getStereotype().getName();
            }
            result.append(label);
            result.append(" \u00bb - ");
            result.append(type.getMClass().getQualifiedName(), this.auxStyler);
        } else {
            result.append(type.getMClass().getQualifiedName());
        }
        return result;
    }

    private StyledString getModuleLabel(ModuleComponent moduleComponent) {
        StyledString result = new StyledString();
        if (moduleComponent.isValid()) {
            result.append(MdaResources.getLabel((ModuleComponent)moduleComponent));
        }
        return result;
    }
}

