/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.edge;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.modelio.linkeditor.gef.background.BackgroundEditPart;
import org.modelio.linkeditor.gef.edge.DeleteEdgeEditPolicy;
import org.modelio.metamodel.impact.ImpactLink;
import org.modelio.metamodel.uml.infrastructure.Dependency;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.metamodel.uml.statik.AggregationKind;
import org.modelio.metamodel.uml.statik.AssociationEnd;
import org.modelio.metamodel.uml.statik.ElementImport;
import org.modelio.metamodel.uml.statik.Generalization;
import org.modelio.metamodel.uml.statik.InterfaceRealization;
import org.modelio.metamodel.uml.statik.Operation;
import org.modelio.metamodel.uml.statik.VisibilityMode;
import org.modelio.platform.mda.infra.MdaResources;
import org.modelio.platform.ui.UIFont;

public class EdgeEditPart
extends AbstractConnectionEditPart {
    private static final String CLOSING = " \u00bb";
    private static final String OPENING = "\u00ab ";
    private static final int HORIZONTALLAYOUT_EDGELABELGAP = 1;
    private static final int VERTICALLAYOUT_EDGELABELGAP = 4;
    private static final PointList AGGREG_TIP;
    private static final PointList NAVIG_AGGREG_TIP;
    private static final PointList TRIANGLE_TIP;
    public static IEdgeDecorator colorizer;

    static {
        int[] nArray = new int[8];
        nArray[0] = -1;
        nArray[1] = 1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -2;
        AGGREG_TIP = new PointList(nArray);
        int[] nArray2 = new int[16];
        nArray2[0] = -1;
        nArray2[1] = 1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[6] = -2;
        nArray2[8] = -3;
        nArray2[9] = -1;
        nArray2[10] = -2;
        nArray2[12] = -3;
        nArray2[13] = 1;
        nArray2[14] = -2;
        NAVIG_AGGREG_TIP = new PointList(nArray2);
        int[] nArray3 = new int[6];
        nArray3[0] = -1;
        nArray3[1] = 1;
        nArray3[4] = -1;
        nArray3[5] = -1;
        TRIANGLE_TIP = new PointList(nArray3);
        colorizer = new IEdgeDecorator(){

            @Override
            public void decorateLabel(Edge edge, Label fig) {
                fig.setFont(UIFont.SMALL);
                fig.setForegroundColor(ColorConstants.lightGray);
            }

            @Override
            public void decorateLine(Edge edge, PolylineConnection fig) {
                if (edge.data != null) {
                    Color swtColor = Display.getDefault().getSystemColor(24);
                    fig.setForegroundColor(swtColor);
                    fig.setLineWidth(1);
                } else {
                    fig.setForegroundColor(ColorConstants.lightGray);
                    fig.setLineWidth(2);
                }
            }
        };
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteEdgeEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        PolylineConnection fig = (PolylineConnection)this.getFigure();
        ManhattanConnectionRouter router = new ManhattanConnectionRouter();
        fig.setConnectionRouter((ConnectionRouter)router);
        Edge edge = (Edge)this.getModel();
        Object model = edge.data;
        colorizer.decorateLine(edge, fig);
        if (model != null) {
            if (model instanceof Generalization || model instanceof Operation) {
                this.decorateGeneralization(fig);
            } else if (model instanceof InterfaceRealization) {
                this.decorateGeneralization(fig);
                fig.setLineStyle(2);
            } else if (model instanceof AssociationEnd) {
                this.decorateAssociation(fig, model);
            } else if (model instanceof Dependency) {
                this.decorateDependency(fig, model);
            } else if (model instanceof ElementImport) {
                this.decorateElementImport(fig, model);
            } else if (model instanceof ImpactLink) {
                this.decorateNamespaceUse(fig, model);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        Object model = this.getModel();
        if (adapter.isInstance(model)) {
            return model;
        }
        if (model instanceof Edge && adapter.isInstance(((Edge)model).data)) {
            return ((Edge)model).data;
        }
        return super.getAdapter(adapter);
    }

    private void decorateElementImport(PolylineConnection fig, Object model) {
        BackgroundEditPart ep = (BackgroundEditPart)this.getRoot().getContents();
        boolean vertical = ep.isVerticalLayout();
        fig.setLineStyle(2);
        fig.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
        Label role = new Label();
        if (((ElementImport)model).getVisibility() == VisibilityMode.PUBLIC) {
            role.setText("\u00ab import \u00bb");
        } else {
            role.setText("\u00ab access \u00bb");
        }
        colorizer.decorateLabel((Edge)this.getModel(), role);
        ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 4);
        constraint.setGap(vertical ? 4 : 1);
        constraint.setRelativePosition(1);
        fig.add((IFigure)role, 0);
        fig.setConstraint((IFigure)role, (Object)constraint);
    }

    private void decorateDependency(PolylineConnection fig, Object model) {
        BackgroundEditPart ep = (BackgroundEditPart)this.getRoot().getContents();
        boolean vertical = ep.isVerticalLayout();
        Dependency dependency = (Dependency)model;
        fig.setLineStyle(2);
        fig.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
        EList stereotypes = dependency.getExtension();
        if (stereotypes != null && !stereotypes.isEmpty()) {
            Label role = new Label();
            if (stereotypes.size() == 1) {
                Stereotype stereotype = (Stereotype)stereotypes.get(0);
                String stereoLabel = MdaResources.getLabel((Stereotype)stereotype);
                role.setText(OPENING + stereoLabel + CLOSING);
            } else {
                Stereotype stereotype2;
                Label tooltip = new Label();
                for (Stereotype stereotype2 : dependency.getExtension()) {
                    String stereoLabel = MdaResources.getLabel((Stereotype)stereotype2);
                    if (tooltip.getText() == null || tooltip.getText().isEmpty()) {
                        tooltip.setText(OPENING + stereoLabel);
                        continue;
                    }
                    tooltip.setText(tooltip.getText() + ", " + stereoLabel);
                }
                tooltip.setText(tooltip.getText() + CLOSING);
                role.setToolTip((IFigure)tooltip);
                stereotype2 = (Stereotype)stereotypes.get(0);
                String stereoLabel = MdaResources.getLabel((Stereotype)stereotype2);
                role.setText(OPENING + stereoLabel + ", ...  \u00bb");
            }
            colorizer.decorateLabel((Edge)this.getModel(), role);
            ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 4);
            constraint.setGap(vertical ? 4 : 1);
            constraint.setRelativePosition(1);
            fig.add((IFigure)role, 0);
            fig.setConstraint((IFigure)role, (Object)constraint);
        }
    }

    private void decorateAssociation(PolylineConnection fig, Object model) {
        AssociationEnd assocEnd = (AssociationEnd)model;
        this.decorateAssociationSource(fig, assocEnd);
        this.decorateAssociationTarget(fig, assocEnd);
    }

    private void decorateGeneralization(PolylineConnection fig) {
        PolygonDecoration arrow = new PolygonDecoration();
        arrow.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        arrow.setScale(8.0, 5.0);
        arrow.setOpaque(true);
        arrow.setFill(true);
        arrow.setForegroundColor(fig.getForegroundColor());
        arrow.setBackgroundColor(ColorConstants.white);
        fig.setTargetDecoration((RotatableDecoration)arrow);
    }

    public boolean isSelectable() {
        return ((Edge)this.getModel()).data != null;
    }

    private void decorateAssociationTarget(PolylineConnection fig, AssociationEnd assocEnd) {
        BackgroundEditPart ep = (BackgroundEditPart)this.getRoot().getContents();
        boolean vertical = ep.isVerticalLayout();
        if (assocEnd.isNavigable()) {
            boolean hasMax;
            PolygonDecoration targetDecoration;
            AssociationEnd opposite = assocEnd.getOpposite();
            if (opposite.getAggregation() == AggregationKind.KINDISAGGREGATION || opposite.getAggregation() == AggregationKind.KINDISCOMPOSITION) {
                targetDecoration = new PolygonDecoration();
                targetDecoration.setTemplate(NAVIG_AGGREG_TIP);
                if (opposite.getAggregation() == AggregationKind.KINDISAGGREGATION) {
                    targetDecoration.setBackgroundColor(ColorConstants.white);
                } else {
                    targetDecoration.setBackgroundColor(ColorConstants.black);
                }
            } else {
                targetDecoration = new PolylineDecoration();
                ((PolylineDecoration)targetDecoration).setTemplate(TRIANGLE_TIP);
            }
            fig.setTargetDecoration((RotatableDecoration)targetDecoration);
            Label role = new Label();
            role.setText(assocEnd.getName());
            colorizer.decorateLabel((Edge)this.getModel(), role);
            ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 3);
            constraint.setGap(vertical ? 4 : 1);
            if (vertical) {
                constraint.setRelativePosition(12);
            } else {
                constraint.setRelativePosition(9);
            }
            fig.add((IFigure)role, (Object)constraint);
            Label card = new Label();
            Object cardText = "";
            boolean hasMin = assocEnd.getMultiplicityMin() != null && !assocEnd.getMultiplicityMin().isEmpty();
            boolean bl = hasMax = assocEnd.getMultiplicityMax() != null && !assocEnd.getMultiplicityMax().isEmpty();
            if (hasMin && !hasMax) {
                cardText = "[" + assocEnd.getMultiplicityMin() + "]";
            } else if (!hasMin && hasMax) {
                cardText = "[" + assocEnd.getMultiplicityMax() + "]";
            } else if (hasMin && hasMax) {
                cardText = "[" + assocEnd.getMultiplicityMin() + ".." + assocEnd.getMultiplicityMax() + "]";
            }
            card.setText((String)cardText);
            colorizer.decorateLabel((Edge)this.getModel(), card);
            constraint = new ConnectionLocator((Connection)fig, 3);
            constraint.setGap(vertical ? 4 : 1);
            if (vertical) {
                constraint.setRelativePosition(20);
            } else {
                constraint.setRelativePosition(12);
            }
            fig.add((IFigure)card, 0);
            fig.setConstraint((IFigure)card, (Object)constraint);
        } else if (assocEnd.getOpposite().getAggregation() == AggregationKind.KINDISAGGREGATION || assocEnd.getOpposite().getAggregation() == AggregationKind.KINDISCOMPOSITION) {
            PolygonDecoration targetDecoration = new PolygonDecoration();
            targetDecoration.setTemplate(AGGREG_TIP);
            if (assocEnd.getOpposite().getAggregation() == AggregationKind.KINDISAGGREGATION) {
                targetDecoration.setBackgroundColor(ColorConstants.white);
            } else {
                targetDecoration.setBackgroundColor(ColorConstants.black);
            }
            fig.setTargetDecoration((RotatableDecoration)targetDecoration);
        }
    }

    private void decorateAssociationSource(PolylineConnection fig, AssociationEnd assocEnd) {
        PolygonDecoration sourceDecoration = new PolygonDecoration();
        AssociationEnd opposite = assocEnd.getOpposite();
        BackgroundEditPart ep = (BackgroundEditPart)this.getRoot().getContents();
        boolean vertical = ep.isVerticalLayout();
        if (opposite.isNavigable()) {
            boolean hasMax;
            if (assocEnd.getAggregation() == AggregationKind.KINDISAGGREGATION || assocEnd.getAggregation() == AggregationKind.KINDISCOMPOSITION) {
                sourceDecoration = new PolygonDecoration();
                sourceDecoration.setTemplate(NAVIG_AGGREG_TIP);
                if (assocEnd.getAggregation() == AggregationKind.KINDISAGGREGATION) {
                    sourceDecoration.setBackgroundColor(ColorConstants.white);
                } else {
                    sourceDecoration.setBackgroundColor(ColorConstants.black);
                }
            } else {
                sourceDecoration = new PolylineDecoration();
                ((PolylineDecoration)sourceDecoration).setTemplate(TRIANGLE_TIP);
            }
            fig.setSourceDecoration((RotatableDecoration)sourceDecoration);
            Label role = new Label();
            role.setText(opposite.getName());
            colorizer.decorateLabel((Edge)this.getModel(), role);
            ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 2);
            constraint.setGap(vertical ? 4 : 1);
            if (vertical) {
                constraint.setRelativePosition(9);
            } else {
                constraint.setRelativePosition(17);
            }
            fig.add((IFigure)role, (Object)constraint);
            Label card = new Label();
            Object cardText = "";
            boolean hasMin = opposite.getMultiplicityMin() != null && !opposite.getMultiplicityMin().isEmpty();
            boolean bl = hasMax = opposite.getMultiplicityMax() != null && !opposite.getMultiplicityMax().isEmpty();
            if (hasMin && !hasMax) {
                cardText = "[" + opposite.getMultiplicityMin() + "]";
            } else if (!hasMin && hasMax) {
                cardText = "[" + opposite.getMultiplicityMax() + "]";
            } else if (hasMin && hasMax) {
                cardText = "[" + opposite.getMultiplicityMin() + ".." + opposite.getMultiplicityMax() + "]";
            }
            card.setText((String)cardText);
            colorizer.decorateLabel((Edge)this.getModel(), card);
            constraint = new ConnectionLocator((Connection)fig, 2);
            constraint.setGap(vertical ? 4 : 1);
            if (vertical) {
                constraint.setRelativePosition(17);
            } else {
                constraint.setRelativePosition(20);
            }
            fig.add((IFigure)card, 0);
            fig.setConstraint((IFigure)card, (Object)constraint);
        } else if (assocEnd.getAggregation() == AggregationKind.KINDISAGGREGATION || assocEnd.getAggregation() == AggregationKind.KINDISCOMPOSITION) {
            sourceDecoration = new PolygonDecoration();
            sourceDecoration.setTemplate(AGGREG_TIP);
            if (assocEnd.getAggregation() == AggregationKind.KINDISAGGREGATION) {
                sourceDecoration.setBackgroundColor(ColorConstants.white);
            } else {
                sourceDecoration.setBackgroundColor(ColorConstants.black);
            }
            fig.setSourceDecoration((RotatableDecoration)sourceDecoration);
        }
    }

    private void decorateNamespaceUse(PolylineConnection fig, Object model) {
        BackgroundEditPart ep = (BackgroundEditPart)this.getRoot().getContents();
        boolean vertical = ep.isVerticalLayout();
        fig.setLineStyle(4);
        fig.setForegroundColor(ColorConstants.lightBlue);
        fig.setLineWidth(2);
        PolylineDecoration arrow = new PolylineDecoration();
        arrow.setTemplate(PolylineDecoration.TRIANGLE_TIP);
        arrow.setScale(7.0, 4.0);
        arrow.setLineWidth(2);
        arrow.setOpaque(false);
        fig.setTargetDecoration((RotatableDecoration)arrow);
        Label role = new Label();
        role.setText(((ImpactLink)model).getCauses().size() + " cause(s)");
        colorizer.decorateLabel((Edge)this.getModel(), role);
        ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 4);
        constraint.setGap(vertical ? 4 : 1);
        constraint.setRelativePosition(1);
        fig.add((IFigure)role, (Object)constraint);
    }

    public static interface IEdgeDecorator {
        public void decorateLine(Edge var1, PolylineConnection var2);

        public void decorateLabel(Edge var1, Label var2);
    }
}

