/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.node;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.swt.widgets.Display;
import org.modelio.linkeditor.gef.background.BackgroundEditPart;
import org.modelio.linkeditor.gef.node.FromSideAnchor;
import org.modelio.linkeditor.gef.node.ToSideAnchor;
import org.modelio.linkeditor.gef.node.label.LabelumFigure;
import org.modelio.linkeditor.panel.model.GraphNode;
import org.modelio.linkeditor.plugin.LinkEditor;
import org.modelio.metamodel.impact.ImpactLink;
import org.modelio.platform.model.ui.swt.images.ElementImageService;
import org.modelio.platform.model.ui.swt.labelprovider.UniversalLabelProvider;
import org.modelio.platform.ui.UIColor;
import org.modelio.vcore.smkernel.mapi.MObject;

public class NodeEditPart
extends AbstractGraphicalEditPart
implements org.eclipse.gef.NodeEditPart {
    public static boolean hasFocus = false;
    public static INodeColorizer colorizer = new INodeColorizer(){

        @Override
        public void colorize(GraphNode model, Figure rect, LabelumFigure label, boolean focus) {
            rect.setBackgroundColor(model.isCentral() ? (focus ? ColorConstants.menuBackgroundSelected : ColorConstants.menuBackground) : ColorConstants.listBackground);
            ((LineBorder)rect.getBorder()).setColor(model.isCentral() ? (hasFocus ? ColorConstants.menuBackgroundSelected : ColorConstants.buttonDarker) : ColorConstants.menuBackground);
            if (model.getData() == null || model.getData().isShell()) {
                label.setForegroundColor(UIColor.SHELL_ELEMENT_FG);
            } else {
                label.setForegroundColor(Display.getDefault().getSystemColor(model.isCentral() ? (focus ? 27 : 24) : 24));
            }
        }
    };
    private static final UniversalLabelProvider labelprovider = new UniversalLabelProvider();

    protected IFigure createFigure() {
        Figure rectangleFigure = new Figure();
        rectangleFigure.setOpaque(true);
        rectangleFigure.setBorder((Border)new LineBorder(ColorConstants.lightGray, 1, 1));
        GridLayout manager = new GridLayout(1, true);
        manager.marginHeight = 1;
        manager.marginWidth = 1;
        manager.verticalSpacing = 1;
        rectangleFigure.setLayoutManager((LayoutManager)manager);
        LabelumFigure label = new LabelumFigure();
        label.setLabelAlignment(1);
        label.setToolTip((IFigure)new Label());
        GridData data = new GridData(1, 2, true, true);
        rectangleFigure.add((IFigure)label, (Object)data);
        return rectangleFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new SelectionHandlesEditPolicy(){

            protected List<? extends Handle> createSelectionHandles() {
                return Collections.emptyList();
            }
        });
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        GraphNode model = this.getModel();
        Figure fig = (Figure)this.getFigure();
        LabelumFigure label = (LabelumFigure)fig.getChildren().get(0);
        Label tooltip = (Label)label.getToolTip();
        colorizer.colorize(model, fig, label, hasFocus);
        if (model.getData() instanceof ImpactLink) {
            ImpactLink use = (ImpactLink)model.getData();
            String userName = use.getImpacted() != null ? use.getImpacted().getName() : "";
            String usedName = use.getDependsOn() != null ? use.getDependsOn().getName() : "";
            label.setText(LinkEditor.I18N.getMessage("Gui.Content.NameSpaceUse.label", new Object[]{userName, usedName}));
            tooltip.setText(LinkEditor.I18N.getMessage("Gui.Content.NameSpaceUse.tooltip", new Object[]{userName, usedName}));
            label.setIcon(ElementImageService.getIcon((MObject)model.getData()));
        } else if (model.getData() != null) {
            MObject mObj = model.getData();
            String nameText = labelprovider.getText((Object)model.getData());
            Object tooltipString = nameText;
            if (mObj.getCompositionOwner() != null) {
                tooltipString = (String)tooltipString + "  (from " + mObj.getCompositionOwner().getName() + ")";
            }
            label.setText(nameText);
            label.setIcon(ElementImageService.getIcon((MObject)model.getData()));
            tooltip.setText((String)tooltipString);
        }
    }

    public List<?> getModelSourceConnections() {
        return this.getModel().outgoing;
    }

    public List<?> getModelTargetConnections() {
        return this.getModel().incoming;
    }

    public GraphNode getModel() {
        return (GraphNode)((Object)super.getModel());
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ToSideAnchor(this.getFigure(), this.isVerticalLayout());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new FromSideAnchor(this.getFigure(), this.isVerticalLayout());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ToSideAnchor(this.getFigure(), this.isVerticalLayout());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new FromSideAnchor(this.getFigure(), this.isVerticalLayout());
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object data;
        GraphNode model = this.getModel();
        if (adapter.isInstance((Object)model)) {
            return adapter.cast((Object)model);
        }
        if (model instanceof GraphNode && adapter.isInstance(data = model.data)) {
            return adapter.cast(data);
        }
        return (T)super.getAdapter(adapter);
    }

    private boolean isVerticalLayout() {
        BackgroundEditPart ep = (BackgroundEditPart)this.getRoot().getContents();
        return ep.isVerticalLayout();
    }

    public static interface INodeColorizer {
        public void colorize(GraphNode var1, Figure var2, LabelumFigure var3, boolean var4);
    }
}

