/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.node.label;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public interface IPenOptionsSupport {
    public void setLineColor(Color var1);

    public void setLineWidth(int var1);

    public Color getLineColor();

    public int getLineWidth();

    public void setTextColor(Color var1);

    public void setTextFont(Font var1);

    public Color getTextColor();

    public Font getTextFont();

    public static IPenOptionsSupport adapt(IFigure fig) {
        if (fig instanceof IPenOptionsSupport) {
            return (IPenOptionsSupport)fig;
        }
        if (fig instanceof Shape) {
            return new ShapeAdapter<Shape>((Shape)fig);
        }
        return new FigureAdapter<IFigure>(fig);
    }

    public static class FigureAdapter<T extends IFigure>
    implements IPenOptionsSupport {
        protected final T fig;

        private FigureAdapter(T fig) {
            this.fig = fig;
        }

        @Override
        public void setTextFont(Font textFont) {
            this.fig.setFont(textFont);
        }

        @Override
        public void setTextColor(Color textColor) {
            this.fig.setForegroundColor(textColor);
        }

        @Override
        public void setLineWidth(int lineWidth) {
        }

        @Override
        public void setLineColor(Color lineColor) {
            this.fig.setForegroundColor(lineColor);
        }

        @Override
        public Font getTextFont() {
            return this.fig.getFont();
        }

        @Override
        public Color getTextColor() {
            return this.fig.getForegroundColor();
        }

        @Override
        public int getLineWidth() {
            return 1;
        }

        @Override
        public Color getLineColor() {
            return this.fig.getForegroundColor();
        }
    }

    public static class ShapeAdapter<T extends Shape>
    extends FigureAdapter<T> {
        public ShapeAdapter(T fig) {
            super(fig);
        }

        @Override
        public void setLineWidth(int lineWidth) {
            ((Shape)this.fig).setLineWidth(lineWidth);
        }

        @Override
        public int getLineWidth() {
            return ((Shape)this.fig).getLineWidth();
        }
    }
}

