/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.node.label;

import java.util.Objects;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.modelio.linkeditor.gef.node.label.ILabelumTextLayouter;
import org.modelio.linkeditor.gef.node.label.IPenOptionsSupport;
import org.modelio.linkeditor.gef.node.label.NativeTextLayouter;
import org.modelio.linkeditor.plugin.LinkEditor;

public class LabelumFigure
extends Figure
implements IPenOptionsSupport,
PositionConstants {
    private static boolean DEBUG = false;
    private static String ELLIPSIS = "...";
    private int iconAlignment = 2;
    private int iconTextGap = 3;
    private int labelAlignment = 2;
    private int orientation;
    private String subStringText;
    private String text = "";
    private int textAlignment = 2;
    private int textPlacement = 16;
    private Image icon;
    private static TextLayout textDrawer = null;
    private TextStyle textStyle = new TextStyle();
    private Point iconLocation;
    private Dimension iconSize = new Dimension(0, 0);
    private PrecisionRectangle innerRectangle;
    private Dimension subStringTextSize;
    private Point textLocation;
    private Dimension textSize;
    private ILabelumTextLayouter textLayouter = NativeTextLayouter.INSTANCE;

    public LabelumFigure() {
        this.init();
    }

    public LabelumFigure(String s) {
        this.setText(s);
        this.init();
    }

    public LabelumFigure(Image i) {
        this.setIcon(i);
        this.init();
    }

    public LabelumFigure(String s, Image i) {
        this.setText(s);
        this.setIcon(i);
        this.init();
    }

    public Font getFont() {
        if (this.textStyle.font != null) {
            return this.textStyle.font;
        }
        if (this.getParent() != null) {
            return this.getParent().getFont();
        }
        return null;
    }

    public Image getIcon() {
        return this.icon;
    }

    public int getIconAlignment() {
        return this.iconAlignment;
    }

    public Rectangle getIconBounds() {
        Rectangle b = this.getBounds();
        return new Rectangle(b.getLocation().translate(this.getIconLocation()), this.getIconSize());
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public int getLabelAlignment() {
        return this.labelAlignment;
    }

    public LayoutManager getLayoutManager() {
        LayoutManager manager = super.getLayoutManager();
        return manager;
    }

    @Override
    public Color getLineColor() {
        return this.textStyle.underlineColor;
    }

    @Override
    public int getLineWidth() {
        return 0;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public String getSubStringText() {
        if (this.subStringText == null) {
            String origText = this.getText();
            PrecisionRectangle ir = this.getInnerRectangle();
            Dimension availTextSize = this.calculateAvailableTextSize((Dimension)new PrecisionDimension(ir.preciseWidth(), ir.preciseHeight()));
            this.subStringText = this.textLayouter.formatText(this, origText, availTextSize);
            TextLayout td = this.getTextDrawer(this.subStringText, availTextSize.width());
            org.eclipse.swt.graphics.Rectangle ttb = td.getBounds();
            this.subStringTextSize = new Dimension(ttb.width, ttb.height);
        }
        return this.subStringText;
    }

    public Rectangle getSubStringBounds() {
        Rectangle tb = this.getBounds().getCopy();
        tb.translate(this.getTextLocation());
        tb.setSize(this.getSubStringTextSize());
        return tb;
    }

    public String getText() {
        return this.text;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public Rectangle getTextBounds() {
        Rectangle tb = this.getBounds().getCopy();
        tb.translate(this.getTextLocation());
        tb.setSize(this.getTextSize());
        return tb;
    }

    @Override
    public Color getTextColor() {
        return this.textStyle.foreground;
    }

    public TextLayout getTextDrawer(String textToDraw, int width) {
        if (textDrawer == null) {
            textDrawer = new TextLayout((Device)Display.getDefault());
        }
        TextLayout tl = textDrawer;
        try {
            if (this.isMirrored()) {
                tl.setOrientation(0x4000000);
            } else {
                tl.setOrientation(0x2000000);
            }
        }
        catch (SWTException sWTException) {
            return tl;
        }
        if (tl.getWidth() == width && Objects.equals(tl.getFont(), this.getTextFont()) && textToDraw.equals(tl.getText()) && (textToDraw.isEmpty() || this.textStyle.equals((Object)tl.getStyle(0)))) {
            return tl;
        }
        tl.setWidth(width > 0 ? width : -1);
        switch (this.labelAlignment) {
            default: {
                tl.setAlignment(16384);
                tl.setJustify(false);
                break;
            }
            case 4: 
            case 128: {
                tl.setAlignment(131072);
                tl.setJustify(false);
                break;
            }
            case 2: {
                tl.setAlignment(0x1000000);
                tl.setJustify(false);
                break;
            }
            case 5: {
                tl.setAlignment(16384);
                tl.setJustify(true);
            }
        }
        tl.setFont(this.getTextFont());
        tl.setText(textToDraw);
        tl.setStyle(this.textStyle, 0, textToDraw.length());
        return tl;
    }

    @Override
    public Font getTextFont() {
        return this.getFont();
    }

    public ILabelumTextLayouter getTextLayouter() {
        return this.textLayouter;
    }

    public int getTextPlacement() {
        return this.textPlacement;
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public TextUtilities getTextUtilities() {
        return TextUtilities.INSTANCE;
    }

    public void invalidate() {
        super.invalidate();
        this.innerRectangle = null;
        this.prefSize = null;
        this.minSize = null;
        this.clearLocations();
        this.textSize = null;
        this.subStringTextSize = null;
        this.subStringText = null;
    }

    public void setFont(Font f) {
        if (!Objects.equals(f, this.textStyle.font)) {
            this.textStyle.font = f;
            this.revalidate();
            this.repaint();
        }
    }

    public void setIcon(Image image) {
        if (this.icon == image) {
            return;
        }
        this.icon = image;
        this.repaint();
        if (this.icon == null) {
            this.setIconDimension(new Dimension());
        } else {
            this.setIconDimension(new Dimension(image));
        }
    }

    public void setIconAlignment(int align) {
        if (this.iconAlignment == align) {
            return;
        }
        this.iconAlignment = align;
        this.clearLocations();
        this.repaint();
    }

    public void setIconTextGap(int gap) {
        if (this.iconTextGap == gap) {
            return;
        }
        this.iconTextGap = gap;
        this.repaint();
        this.revalidate();
    }

    public void setLabelAlignment(int align) {
        if (this.labelAlignment == align) {
            return;
        }
        this.labelAlignment = align;
        this.clearLocations();
        this.repaint();
    }

    public void setLayoutManager(LayoutManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("%s must be a LabelumFigure.LM ", manager));
        }
        super.setLayoutManager(manager);
    }

    @Override
    public void setLineColor(Color lineColor) {
        this.textStyle.underlineColor = lineColor;
        this.textStyle.strikeoutColor = lineColor;
        this.repaint();
    }

    @Override
    public void setLineWidth(int lineWidth) {
    }

    public void setOrientationAngle(int orientation) {
        this.orientation = orientation % 360;
        if (this.orientation < 0) {
            this.orientation = 360 + this.orientation;
        }
        this.revalidate();
    }

    public void setOrientationDirection(int orientation) {
        switch (orientation) {
            case 1: {
                this.setOrientationAngle(90);
                break;
            }
            case 17: {
                this.setOrientationAngle(45);
                break;
            }
            case 9: {
                this.setOrientationAngle(135);
                break;
            }
            case 16: {
                this.setOrientationAngle(0);
                break;
            }
            case 4: {
                this.setOrientationAngle(-90);
                break;
            }
            case 20: {
                this.setOrientationAngle(-45);
                break;
            }
            case 12: {
                this.setOrientationAngle(-135);
                break;
            }
            case 8: {
                this.setOrientationAngle(180);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(orientation));
            }
        }
    }

    public void setStrikeThrough(boolean strikeThrough) {
        if (this.textStyle.strikeout != strikeThrough) {
            this.textStyle.strikeout = strikeThrough;
            this.repaint();
        }
    }

    public void setText(String s) {
        String ls = s;
        if (ls == null) {
            ls = "";
        }
        if (this.text.equals(ls)) {
            return;
        }
        this.text = ls;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setTextColor(Color textColor) {
        if (!Objects.equals(this.textStyle.foreground, textColor)) {
            this.textStyle.foreground = textColor;
            this.repaint();
        }
    }

    @Override
    public void setTextFont(Font textFont) {
        this.setFont(textFont);
    }

    public void setTextLayouter(ILabelumTextLayouter labellumLayouter) {
        if (!Objects.equals(this.textLayouter, labellumLayouter)) {
            this.textLayouter = labellumLayouter;
            this.revalidate();
            this.repaint();
        }
    }

    public void setTextMinorAlignment(int align) {
        if (this.textAlignment == align) {
            return;
        }
        this.textAlignment = align;
        this.clearLocations();
        this.repaint();
    }

    public void setTextPlacement(int where) {
        if (this.textPlacement == where) {
            return;
        }
        this.textPlacement = where;
        this.revalidate();
        this.repaint();
    }

    public void setUnderline(boolean underline) {
        if (this.textStyle.underline != underline) {
            this.textStyle.underline = underline;
            this.repaint();
        }
    }

    protected Dimension calculateAvailableTextSize(Dimension figureSize) {
        int gap = this.getIconTextGap();
        if (this.getIcon() == null || this.getText().isEmpty()) {
            gap = 0;
        }
        Dimension d = new Dimension(0, 0);
        int txtPlacement = this.getTextPlacement();
        if (txtPlacement == 8 || txtPlacement == 16) {
            d.width = figureSize.width() - this.getIconSize().width() - gap;
            d.height = Math.max(this.getIconSize().height(), figureSize.height());
        } else {
            d.width = Math.max(this.getIconSize().width(), figureSize.width());
            d.height = figureSize.height() - this.getIconSize().height() - gap;
        }
        if (figureSize.width() == -1) {
            d.width = -1;
        }
        if (figureSize.height() == -1) {
            d.height = -1;
        }
        return d;
    }

    protected Dimension calculateLabelSize(Dimension txtSize) {
        int gap = this.getIconTextGap();
        if (this.getIcon() == null || this.getText().equals("")) {
            gap = 0;
        }
        Dimension d = new Dimension(0, 0);
        if (this.textPlacement == 8 || this.textPlacement == 16) {
            d.width = this.getIconSize().width + gap + txtSize.width;
            d.height = Math.max(this.getIconSize().height, txtSize.height);
        } else {
            d.width = Math.max(this.getIconSize().width, txtSize.width);
            d.height = this.getIconSize().height + gap + txtSize.height;
        }
        return d;
    }

    protected Dimension calculateMinimumSize(int w, int h) {
        Dimension availTextSize = w == -1 && h == -1 ? new Dimension(-1, -1) : this.calculateAvailableTextSize((Dimension)this.calculateMaxRotatedRectangleSize(w, h));
        String tt = this.getTextLayouter().formatText(this, this.getText(), availTextSize);
        TextLayout td = this.getTextDrawer(tt, -1);
        org.eclipse.swt.graphics.Rectangle ttBounds = td.getBounds();
        Dimension ttDim = new Dimension(ttBounds.width, ttBounds.height);
        Dimension truncatedTextSize = this.getTextUtilities().getTextExtents(this.getTruncationString(), this.getFont());
        Dimension lMinSize = this.calculateRotatedRectangleBounds(this.calculateLabelSize(truncatedTextSize.union(ttDim)), new Dimension());
        Insets insets = this.getInsets();
        lMinSize.expand(insets.getWidth(), insets.getHeight());
        return lMinSize;
    }

    protected Dimension calculatePreferredSize(int wHint, int hHint) {
        Dimension lprefSize = this.calculateRotatedRectangleBounds(this.calculateLabelSize(this.getTextSize()), new Dimension());
        Insets insets = this.getInsets();
        lprefSize.expand(insets.getWidth(), insets.getHeight());
        if (wHint >= 0 && wHint < lprefSize.width || hHint >= 0 && hHint < lprefSize.height) {
            Dimension result = this.getMinimumSize(wHint, hHint).getCopy();
            result.width = Math.max(result.width, wHint);
            result.height = Math.max(result.height, hHint);
            return result;
        }
        if (wHint >= 0 && wHint > lprefSize.width && this.labelAlignment == 5) {
            lprefSize.width = wHint;
        }
        return lprefSize;
    }

    protected Dimension calculateTextSize() {
        TextLayout td = this.getTextDrawer(this.getText(), -1);
        org.eclipse.swt.graphics.Rectangle ttb = td.getBounds();
        Dimension textExtents = new Dimension(ttb.width, ttb.height);
        return textExtents;
    }

    protected Point getIconLocation() {
        if (this.iconLocation == null) {
            this.calculateLocations();
        }
        return this.iconLocation;
    }

    protected Dimension getIconSize() {
        return this.iconSize;
    }

    protected PrecisionRectangle getInnerRectangle() {
        if (this.innerRectangle == null) {
            PrecisionRectangle r = new PrecisionRectangle();
            Dimension size = this.getSize();
            r.setSize((Dimension)this.calculateMaxRotatedRectangleSize(size.width, size.height));
            this.innerRectangle = r;
            double innerW = this.innerRectangle.preciseWidth();
            double innerH = this.innerRectangle.preciseHeight();
            double sinr = Math.sin(Math.toRadians(this.orientation));
            double cosr = Math.cos(Math.toRadians(this.orientation));
            if (this.orientation <= 90) {
                double dy = (double)this.innerRectangle.width() * sinr;
                this.innerRectangle.translate(0.0, dy);
            } else if (this.orientation > 90 && this.orientation <= 180) {
                double dx = -innerW * cosr;
                double dy = innerW * sinr - innerH * cosr;
                this.innerRectangle.translate(dx, dy);
            } else if (this.orientation > 180 && this.orientation <= 270) {
                double dx = -innerW * cosr - innerH * sinr;
                double dy = -innerH * cosr;
                this.innerRectangle.translate(dx, dy);
            } else {
                double dx = -innerH * sinr;
                this.innerRectangle.translate(dx, 0.0);
            }
        }
        return this.innerRectangle;
    }

    protected Dimension getSubStringTextSize() {
        if (this.subStringTextSize == null) {
            this.getSubStringText();
        }
        return this.subStringTextSize;
    }

    protected Point getTextLocation() {
        if (this.textLocation != null) {
            return this.textLocation;
        }
        this.calculateLocations();
        return this.textLocation;
    }

    protected Dimension getTextSize() {
        if (this.textSize == null) {
            this.textSize = this.calculateTextSize();
        }
        return this.textSize;
    }

    protected String getTruncationString() {
        return ELLIPSIS;
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setTextAntialias(1);
        if (this.isOpaque()) {
            super.paintFigure(graphics);
        }
        Rectangle lbounds = this.getBounds();
        graphics.translate(lbounds.x, lbounds.y);
        PrecisionRectangle innerRect = this.getInnerRectangle();
        if (this.orientation != 0) {
            if (DEBUG) {
                graphics.setAlpha(40);
                graphics.drawRectangle(1, 0, lbounds.width() - 1, lbounds.height() - 1);
                graphics.setAlpha(255);
            }
            graphics.pushState();
            graphics.translate((float)innerRect.preciseX(), (float)innerRect.preciseY());
            graphics.rotate((float)(-this.orientation));
            if (DEBUG) {
                graphics.setAlpha(40);
                graphics.drawRectangle(0, 0, innerRect.width(), innerRect.height());
                graphics.setAlpha(255);
            }
        }
        try {
            TextLayout tl;
            int relWidth;
            if (this.icon != null) {
                graphics.setInterpolation(2);
                graphics.drawImage(this.icon, this.getIconLocation());
            }
            Point lTextLocation = this.getTextLocation();
            Dimension toDrawSize = this.getSubStringTextSize();
            String toDrawText = this.getSubStringText();
            if (toDrawText.isEmpty()) {
                return;
            }
            if (DEBUG) {
                graphics.setAlpha(140);
                graphics.drawRectangle(lTextLocation.x(), lTextLocation.y(), toDrawSize.width(), toDrawSize.height());
                graphics.setAlpha(255);
            }
            this.translateGraphics(graphics, lTextLocation.preciseX(), lTextLocation.preciseY());
            if (DEBUG) {
                graphics.setAlpha(100);
                graphics.drawRectangle(0, 0, toDrawSize.width(), toDrawSize.height());
                graphics.setAlpha(255);
            }
            if ((relWidth = (tl = this.getTextDrawer(toDrawText, this.calculateAvailableTextSize(innerRect.getSize()).width())).getWidth()) < -1 || relWidth == 0) {
                return;
            }
            double absWidth = graphics.getAbsoluteScale() * (double)relWidth;
            if (absWidth < 1.0) {
                return;
            }
            if (!this.isEnabled()) {
                this.translateGraphics(graphics, 1.0, 1.0);
                graphics.setForegroundColor(ColorConstants.buttonLightest);
                graphics.drawTextLayout(tl, 0, 0);
                this.translateGraphics(graphics, -1.0, -1.0);
                graphics.setForegroundColor(ColorConstants.buttonDarker);
            }
            graphics.drawTextLayout(tl, 0, 0);
        }
        finally {
            if (this.orientation != 0) {
                graphics.popState();
            }
        }
    }

    private void alignOnHeight(Point loc, Dimension size, int alignment) {
        PrecisionRectangle ref = this.getInnerRectangle();
        Insets insets = this.getInsets();
        switch (alignment) {
            case 8: {
                loc.y = insets.top;
                break;
            }
            case 32: {
                loc.y = ref.height - size.height - insets.bottom;
                break;
            }
            default: {
                loc.y = (ref.height - size.height) / 2;
            }
        }
    }

    private void alignOnWidth(Point loc, Dimension size, int alignment) {
        PrecisionRectangle ref = this.getInnerRectangle();
        Insets insets = this.getInsets();
        switch (alignment) {
            case 1: {
                loc.x = insets.left;
                break;
            }
            case 4: {
                loc.x = ref.width - size.width - insets.right;
                break;
            }
            default: {
                loc.x = (ref.width - size.width) / 2;
            }
        }
    }

    private void calculateAlignment() {
        switch (this.textPlacement) {
            case 8: 
            case 16: {
                this.alignOnHeight(this.textLocation, this.getSubStringTextSize(), this.textAlignment);
                this.alignOnHeight(this.iconLocation, this.getIconSize(), this.iconAlignment);
                break;
            }
            default: {
                this.alignOnWidth(this.textLocation, this.getSubStringTextSize(), this.textAlignment);
                this.alignOnWidth(this.iconLocation, this.getIconSize(), this.iconAlignment);
            }
        }
    }

    private void calculateLocations() {
        this.textLocation = new PrecisionPoint();
        this.iconLocation = new PrecisionPoint();
        this.calculatePlacement();
        this.calculateAlignment();
        Dimension offset = LabelumFigure.preciseSize(this.getInnerRectangle()).getShrinked(this.getSubStringTextSize());
        switch (this.labelAlignment) {
            case 2: {
                offset.scale(0.5);
                break;
            }
            case 1: 
            case 5: {
                offset.scale(0.0);
                break;
            }
            case 4: {
                offset.scale(1.0);
                break;
            }
            case 8: {
                offset.setHeight(0);
                offset.scale(0.5);
                break;
            }
            case 32: {
                offset.scale(0.5, 1.0);
                break;
            }
            default: {
                offset.scale(0.5);
            }
        }
        switch (this.textPlacement) {
            case 8: 
            case 16: {
                offset.setHeight(0);
                break;
            }
            default: {
                offset.setWidth(0);
            }
        }
        this.textLocation.translate(offset);
        this.iconLocation.translate(offset);
    }

    private PrecisionDimension calculateMaxRotatedRectangleSize(int w, int h) {
        if (this.orientation == 0 || this.orientation == 180) {
            return new PrecisionDimension((double)w, (double)h);
        }
        if (this.orientation == 90 || this.orientation == 270) {
            return new PrecisionDimension((double)h, (double)w);
        }
        return this.guessLargestRotatedTextSize(this.orientation, w, h);
    }

    private void calculatePlacement() {
        int gap = this.getIconTextGap();
        if (this.icon == null || this.text.equals("")) {
            gap = 0;
        }
        Insets insets = this.getInsets();
        switch (this.textPlacement) {
            case 16: {
                this.iconLocation.x = insets.left;
                this.textLocation.x = this.getIconSize().width + gap + insets.left;
                break;
            }
            case 8: {
                this.textLocation.x = insets.left;
                this.iconLocation.x = this.getSubStringTextSize().width + gap + insets.left;
                break;
            }
            case 1: {
                this.textLocation.y = insets.top;
                this.iconLocation.y = this.getTextSize().height + gap + insets.top;
                break;
            }
            default: {
                this.textLocation.y = this.getIconSize().height + gap + insets.top;
                this.iconLocation.y = insets.top;
            }
        }
    }

    private Dimension calculateRotatedRectangleBounds(Dimension d, Dimension target) {
        if (this.orientation == 0 || this.orientation == 180) {
            target.setSize(d);
        } else if (this.orientation == 90 || this.orientation == -90) {
            target.setSize(d);
            target.transpose();
        } else {
            double rad = Math.toRadians(this.orientation);
            double cos = Math.cos(rad);
            double sin = Math.sin(rad);
            double a = Math.abs((double)d.width * cos) + Math.abs((double)d.height * sin);
            double b = Math.abs((double)d.width * sin) + Math.abs((double)d.height * cos);
            target.setSize((int)Math.ceil(a), (int)Math.ceil(b));
        }
        return target;
    }

    private void clearLocations() {
        this.textLocation = null;
        this.iconLocation = null;
    }

    private PrecisionDimension guessLargestRotatedTextSize(double angle, int origWidth, int origHeight) {
        int wrapCur;
        org.eclipse.swt.graphics.Rectangle swtbounds = this.getTextDrawer(this.getText(), -1).getBounds();
        PrecisionDimension ret = new PrecisionDimension((double)swtbounds.width, (double)swtbounds.height);
        int limitWidth = origWidth;
        boolean vertical = false;
        int quarter = (int)((angle + 45.0) / 90.0);
        if (quarter == 1 || quarter == 3) {
            limitWidth = origHeight;
            vertical = true;
        }
        Dimension cbounds = this.calculateRotatedRectangleBounds((Dimension)ret, new Dimension());
        if (limitWidth == -1 || cbounds.width() < limitWidth) {
            return ret;
        }
        int wrapHigh = wrapCur = swtbounds.width;
        int wrapLow = 0;
        Dimension wrapDim = new Dimension(-1, -1);
        while (wrapHigh - wrapLow > 2) {
            wrapCur = (wrapHigh + wrapLow) / 2;
            wrapDim.setWidth(wrapCur);
            String formatedText = this.getTextLayouter().formatText(this, this.getText(), wrapDim);
            swtbounds = this.getTextDrawer(formatedText, wrapDim.width()).getBounds();
            ret.setSize(swtbounds.width, swtbounds.height);
            cbounds = this.calculateRotatedRectangleBounds((Dimension)ret, cbounds);
            if (cbounds.width() > limitWidth) {
                wrapHigh = wrapCur;
                continue;
            }
            if (cbounds.width() < limitWidth) {
                wrapLow = wrapCur;
                continue;
            }
            return ret;
        }
        if (!vertical) {
            if (origHeight != -1 && cbounds.height() > origHeight) {
                double sin = Math.sin(Math.toRadians(angle));
                double cos = Math.cos(Math.toRadians(angle));
                ret.height = (int)(((double)origHeight - (double)ret.width * sin) / cos);
            }
        } else if (origWidth != -1 && cbounds.width() > origWidth) {
            double sin = Math.sin(Math.toRadians(angle));
            double cos = Math.cos(Math.toRadians(angle));
            ret.width = (int)(((double)origWidth - (double)ret.height * sin) / cos);
        }
        return ret;
    }

    private void init() {
        this.setLayoutManager((LayoutManager)new LM());
    }

    private static PrecisionDimension preciseSize(PrecisionRectangle r) {
        return new PrecisionDimension(r.preciseWidth(), r.preciseHeight());
    }

    private void setIconDimension(Dimension d) {
        if (d.equals((Object)this.getIconSize())) {
            return;
        }
        this.iconSize = d;
        this.revalidate();
    }

    private void translateGraphics(Graphics graphics, double x, double y) {
        try {
            graphics.translate((float)x, (float)y);
        }
        catch (NullPointerException e) {
            LinkEditor.LOG.debug(e.toString());
        }
    }

    protected static class LM
    extends AbstractHintLayout {
        protected LM() {
        }

        public void layout(IFigure container) {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return ((LabelumFigure)container).calculatePreferredSize(wHint, hHint);
        }

        protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
            return ((LabelumFigure)container).calculateMinimumSize(wHint, hHint);
        }
    }
}

