/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.node.label;

import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.modelio.linkeditor.gef.node.label.ILabelumTextLayouter;
import org.modelio.linkeditor.gef.node.label.LabelumFigure;

public class NativeTextLayouter
implements ILabelumTextLayouter {
    public static final String CR_END_SYMB1 = "\ue684";
    public static final String CR_END_SYMB2 = "\u23ce";
    private String lineEndSymbol;
    public static final NativeTextLayouter INSTANCE = new NativeTextLayouter();

    public NativeTextLayouter() {
        this("");
    }

    public NativeTextLayouter(String lineEndSymbol) {
        this.lineEndSymbol = lineEndSymbol;
    }

    @Override
    public String formatText(LabelumFigure labelumFigure, String origText, Dimension maxSize) {
        TextUtilities textUtilities = labelumFigure.getTextUtilities();
        origText = origText.replace(" ", "\u200b\u00a0\u200b");
        String lineBreakSymbol = this.getLineEndSymbol();
        int lineBreakWidth = textUtilities.getTextExtents((String)lineBreakSymbol, (Font)labelumFigure.getFont()).width;
        String truncSymbol = this.getTruncationString();
        int truncationWidth = textUtilities.getTextExtents((String)truncSymbol, (Font)labelumFigure.getFont()).width;
        int allowedWidth = maxSize.width > 0 ? Math.max(maxSize.width - lineBreakWidth, truncationWidth) : -1;
        TextLayout textLayout = labelumFigure.getTextDrawer(origText, allowedWidth);
        StringBuilder sb = new StringBuilder();
        int[] offsets = textLayout.getLineOffsets();
        int i = 0;
        while (i < offsets.length - 1) {
            boolean isNextLine = i < offsets.length - 2;
            Rectangle lineBounds = textLayout.getLineBounds(i);
            if (sb.length() > 0 && (isNextLine || lineBounds.width > lineBreakWidth) && sb.charAt(sb.length() - 1) != '\n') {
                sb.append(lineBreakSymbol);
                sb.append("\n");
            }
            sb.append(origText, offsets[i], offsets[i + 1]);
            if (isNextLine) {
                Rectangle nextLineBounds = textLayout.getLineBounds(i + 1);
                int lineBottom = nextLineBounds.y + nextLineBounds.height;
                if (maxSize.height > -1 && lineBottom > maxSize.height) {
                    String lastLine = origText.substring(offsets[i], offsets[i + 1]);
                    int len = textUtilities.getLargestSubstringConfinedTo(lastLine, labelumFigure.getFont(), maxSize.width - truncationWidth);
                    sb.replace(offsets[i] + len, sb.length(), truncSymbol);
                    return sb.toString();
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String getLineEndSymbol() {
        return this.lineEndSymbol;
    }

    private String getTruncationString() {
        return "...";
    }
}

