/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.gef.tools;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Handle;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.swt.graphics.Cursor;
import org.modelio.platform.core.navigate.IModelioNavigationService;
import org.modelio.platform.ui.gef.SharedCursors2;
import org.modelio.vcore.smkernel.mapi.MObject;

public class PanSelectionTool
extends SelectionTool {
    protected static final int PAN = 128;
    protected static final int PAN_IN_PROGRESS = 256;
    protected static final int MAX_STATE = 256;
    private static final int DRAG_BUTTON = 2;
    private static final int DRAG_THRESHOLD = 2;
    protected static final int WORKAREA_RESIZE_INCREMENT = 40;
    private Point viewLocation;
    private IModelioNavigationService navigationService;

    protected String getDebugName() {
        return "Panning Tool";
    }

    protected String getDebugNameForState(int state) {
        if (state == 128) {
            return "Pan Initial";
        }
        if (state == 256) {
            return "Pan In Progress";
        }
        return super.getDebugNameForState(state);
    }

    protected Cursor getDefaultCursor() {
        if (this.isInState(256)) {
            return SharedCursors2.CURSOR_GRAB_HAND;
        }
        return super.getDefaultCursor();
    }

    protected boolean handleButtonDown(int which) {
        if (which == 2 && this.getCurrentViewer().getControl() instanceof FigureCanvas && this.stateTransition(1, 128)) {
            this.viewLocation = ((FigureCanvas)this.getCurrentViewer().getControl()).getViewport().getViewLocation();
            this.refreshCursor();
            return true;
        }
        if (this.getCurrentInput().isControlKeyDown()) {
            MObject element;
            Handle handle;
            EditPartViewer viewer = this.getCurrentViewer();
            Point p = this.getLocation();
            if (this.getDragTracker() != null) {
                this.getDragTracker().deactivate();
            }
            if (viewer instanceof GraphicalViewer && (handle = ((GraphicalViewer)viewer).findHandleAt(p)) != null) {
                this.setDragTracker(handle.getDragTracker());
                return true;
            }
            this.updateTargetRequest();
            ((SelectionRequest)this.getTargetRequest()).setLastButtonPressed(which);
            this.updateTargetUnderMouse();
            EditPart editpart = this.getTargetEditPart();
            if (editpart != null && (element = (MObject)editpart.getAdapter(MObject.class)) != null) {
                if (this.navigationService != null) {
                    this.navigationService.fireNavigate(element);
                }
                return true;
            }
            return false;
        }
        return super.handleButtonDown(which);
    }

    protected boolean handleButtonUp(int which) {
        if (which == 2 && this.stateTransition(256, 1)) {
            this.refreshCursor();
            return true;
        }
        return super.handleButtonUp(which);
    }

    protected boolean handleDrag() {
        if (this.isInState(128) && this.getCurrentViewer().getControl() instanceof FigureCanvas) {
            if ((Math.abs(this.getDragMoveDelta().width) > 2 || Math.abs(this.getDragMoveDelta().height) > 2) && this.stateTransition(128, 256)) {
                this.refreshCursor();
                return true;
            }
            return super.handleDrag();
        }
        if (this.isInState(256) && this.getCurrentViewer().getControl() instanceof FigureCanvas) {
            GraphicalViewer v = (GraphicalViewer)this.getCurrentViewer();
            ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)v.getRootEditPart();
            FreeformLayer cfr_ignored_0 = (FreeformLayer)((GraphicalEditPart)rootEditPart.getContents()).getFigure();
            FigureCanvas canvas = (FigureCanvas)this.getCurrentViewer().getControl();
            canvas.scrollTo(this.viewLocation.x - this.getDragMoveDelta().width, this.viewLocation.y - this.getDragMoveDelta().height);
            this.viewLocation = canvas.getViewport().getViewLocation();
            this.setStartLocation(this.getLocation());
            return true;
        }
        return super.handleDrag();
    }

    protected boolean handleFocusLost() {
        if (this.isInState(384)) {
            this.setState(1);
            this.refreshCursor();
            return true;
        }
        return super.handleFocusLost();
    }

    public PanSelectionTool(IModelioNavigationService navigationService) {
        this.navigationService = navigationService;
    }
}

