/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.handlers.delete;

import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.modelio.linkeditor.gef.background.BackgroundEditPart;
import org.modelio.linkeditor.gef.edge.EdgeEditPart;
import org.modelio.linkeditor.gef.node.NodeEditPart;
import org.modelio.linkeditor.panel.model.GraphNode;
import org.modelio.linkeditor.view.ILinkEditorView;
import org.modelio.metamodel.impact.ImpactLink;
import org.modelio.platform.project.services.IProjectService;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.transactions.ITransaction;
import org.modelio.vcore.smkernel.mapi.MObject;

public class DeleteSelectionHandler {
    @Execute
    public Object execute(@Named(value="org.eclipse.ui.selection") ISelection selection, IProjectService projectService) {
        List<MObject> selectedElements = this.getSelection(selection);
        ICoreSession transactionManager = projectService.getSession();
        boolean validElementFound = false;
        Throwable throwable = null;
        Object var7_8 = null;
        try (ITransaction t = transactionManager.getTransactionSupport().createTransaction("delete selected elements");){
            for (MObject el : selectedElements) {
                if (!el.isValid()) continue;
                el.delete();
                validElementFound = true;
            }
            if (validElementFound) {
                t.commit();
            } else {
                t.rollback();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    protected List<MObject> getSelection(ISelection selection) {
        ArrayList<MObject> selectedElements = new ArrayList<MObject>();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object selectedObject : selectedObjects) {
                GraphNode node;
                if (selectedObject instanceof EdgeEditPart) {
                    Edge edge = (Edge)((EdgeEditPart)((Object)selectedObject)).getModel();
                    if (edge.data == null || !(edge.data instanceof MObject)) continue;
                    selectedElements.add((MObject)edge.data);
                    continue;
                }
                if (selectedObject instanceof NodeEditPart) {
                    node = ((NodeEditPart)((Object)selectedObject)).getModel();
                    if (node.getData() == null) continue;
                    selectedElements.add(node.getData());
                    continue;
                }
                if (!(selectedObject instanceof BackgroundEditPart) || (node = ((BackgroundEditPart)selectedObject).getModel().getCenter()).getData() == null) continue;
                selectedElements.add(node.getData());
            }
        }
        return selectedElements;
    }

    @CanExecute
    public boolean canExecute(MPart part, @Named(value="org.eclipse.ui.selection") ISelection iSelection) {
        ILinkEditorView ILinkEditorView2;
        if (part.getObject() instanceof ILinkEditorView && !(ILinkEditorView2 = (ILinkEditorView)part.getObject()).getLinkEditor().isEditMode()) {
            return false;
        }
        List<MObject> selection = this.getSelection(iSelection);
        for (MObject selectedElement : selection) {
            if (!(selectedElement instanceof ImpactLink) && selectedElement.isModifiable()) continue;
            return false;
        }
        return selection.size() > 0;
    }
}

