/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.handlers.image;

import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.modelio.linkeditor.panel.ILinkEditor;
import org.modelio.linkeditor.view.ILinkEditorView;
import org.modelio.platform.ui.swt.PngTransfer;

public class CopyImageToClipboardHandler {
    @Execute
    public Object execute(@Named(value="e4ActivePart") MPart part) {
        if (!(part.getObject() instanceof ILinkEditorView)) {
            return null;
        }
        ILinkEditor editor = ((ILinkEditorView)part.getObject()).getLinkEditor();
        Image img = editor.getImage();
        if (img != null) {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            PngTransfer transfer = SWT.getPlatform().equals("gtk") ? PngTransfer.getInstance() : ImageTransfer.getInstance();
            clipboard.setContents(new Object[]{img.getImageData()}, new Transfer[]{transfer});
            img.dispose();
        }
        return null;
    }
}

