/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.handlers.image;

import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.modelio.linkeditor.panel.ILinkEditor;
import org.modelio.linkeditor.plugin.LinkEditor;
import org.modelio.linkeditor.view.ILinkEditorView;

public class SaveAsImageHandler {
    private static final String[] filterExtensions = new String[]{".png", ".bmp", ".jpg", ".gif"};
    private static final String[] filterNames = new String[]{"PNG", "BMP", "JPEG", "GIF"};
    private static final int[] filterFormats;
    static String initialFilterPath;
    static int initialFilterIndex;

    static {
        int[] nArray = new int[4];
        nArray[0] = 5;
        nArray[2] = 4;
        nArray[3] = 2;
        filterFormats = nArray;
        initialFilterPath = System.getenv("USERPROFILE");
        initialFilterIndex = 0;
    }

    @Execute
    public Object execute(@Named(value="e4ActivePart") MPart part) {
        Image img;
        if (!(part.getObject() instanceof ILinkEditorView)) {
            return null;
        }
        ILinkEditor editor = ((ILinkEditorView)part.getObject()).getLinkEditor();
        SaveInfo saveInfo = this.getSaveInfo();
        if (saveInfo != null && (img = editor.getImage()) != null) {
            ImageLoader imgLoader = new ImageLoader();
            imgLoader.data = new ImageData[]{img.getImageData()};
            imgLoader.save(saveInfo.location, saveInfo.format);
            img.dispose();
        }
        return null;
    }

    private SaveInfo getSaveInfo() {
        FileDialog dlg = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        dlg.setOverwrite(true);
        dlg.setText(LinkEditor.I18N.getString("Gui.SaveAsImageDialog.Title"));
        dlg.setFilterExtensions(filterExtensions);
        dlg.setFilterNames(filterNames);
        dlg.setFilterIndex(initialFilterIndex);
        dlg.setFilterPath(initialFilterPath);
        dlg.setFileName("*" + filterExtensions[initialFilterIndex]);
        dlg.setOverwrite(true);
        String saveLocation = dlg.open();
        if (saveLocation == null) {
            return null;
        }
        int filterIndex = dlg.getFilterIndex();
        saveLocation = this.normalizeFilename(saveLocation, filterExtensions[filterIndex]);
        initialFilterIndex = filterIndex;
        initialFilterPath = dlg.getFilterPath();
        return new SaveInfo(saveLocation, filterFormats[filterIndex]);
    }

    private String normalizeFilename(String saveLocation, String fileExtension) {
        if (saveLocation.endsWith(fileExtension)) {
            return saveLocation;
        }
        return saveLocation + fileExtension;
    }

    private static class SaveInfo {
        public String location;
        public int format;

        public SaveInfo(String location, int format) {
            this.location = location;
            this.format = format;
        }
    }
}

