/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.handlers.print;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.modelio.linkeditor.handlers.print.PrintMargin;
import org.modelio.linkeditor.handlers.print.PrintPageNavigation;
import org.modelio.linkeditor.panel.ILinkEditor;
import org.modelio.linkeditor.plugin.LinkEditor;

public class PrintPreviewDialog
extends Dialog {
    private int printMode = 2;
    private Image image;
    private Shell shell;
    private Canvas canvas;
    private Printer printer;
    private Label pagesLabel;
    private Button previousButton;
    private Button nextButton;
    private PrintPageNavigation pageNavigation;
    private ILinkEditor editor;
    private PrintMargin margin;

    public PrintPreviewDialog(Shell parent, ILinkEditor linkEditor) {
        super(parent);
        this.editor = linkEditor;
        this.image = linkEditor.getImage();
        this.shell = new Shell(parent, 67696);
    }

    public void open() {
        this.shell.setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.Title"));
        this.shell.setLayout((Layout)new GridLayout(5, false));
        this.canvas = new Canvas((Composite)this.shell, 2048);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 2;
        gridData.widthHint = 300;
        this.canvas.setLayoutData((Object)gridData);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int canvasBorder = 5;
                if (PrintPreviewDialog.this.printer == null || PrintPreviewDialog.this.printer.isDisposed()) {
                    return;
                }
                Rectangle rectangle = PrintPreviewDialog.this.printer.getBounds();
                Point canvasSize = PrintPreviewDialog.this.canvas.getSize();
                double viewScaleFactor = (double)(canvasSize.x - canvasBorder * 2) * 1.0 / (double)rectangle.width;
                viewScaleFactor = Math.min(viewScaleFactor, (double)(canvasSize.y - canvasBorder * 2) * 1.0 / (double)rectangle.height);
                int offsetX = (canvasSize.x - (int)(viewScaleFactor * (double)rectangle.width)) / 2;
                int offsetY = (canvasSize.y - (int)(viewScaleFactor * (double)rectangle.height)) / 2;
                e.gc.setBackground(PrintPreviewDialog.this.shell.getDisplay().getSystemColor(1));
                e.gc.fillRectangle(offsetX, offsetY, (int)(viewScaleFactor * (double)rectangle.width), (int)(viewScaleFactor * (double)rectangle.height));
                e.gc.setLineStyle(1);
                e.gc.setForeground(PrintPreviewDialog.this.shell.getDisplay().getSystemColor(2));
                e.gc.drawRectangle(offsetX, offsetY, (int)(viewScaleFactor * (double)rectangle.width), (int)(viewScaleFactor * (double)rectangle.height));
                if (PrintPreviewDialog.this.image != null) {
                    int imageWidth = PrintPreviewDialog.this.image.getBounds().width;
                    int imageHeight = PrintPreviewDialog.this.image.getBounds().height;
                    double dpiScaleFactorX = (double)PrintPreviewDialog.this.printer.getDPI().x * 1.0 / (double)PrintPreviewDialog.this.shell.getDisplay().getDPI().x;
                    double dpiScaleFactorY = (double)PrintPreviewDialog.this.printer.getDPI().y * 1.0 / (double)PrintPreviewDialog.this.shell.getDisplay().getDPI().y;
                    double imageSizeFactor = Math.min((double)rectangle.width * viewScaleFactor / (double)imageWidth, (double)rectangle.height * viewScaleFactor / (double)imageHeight);
                    int destX = (int)(imageSizeFactor * (double)imageWidth) - 1;
                    int destY = (int)(imageSizeFactor * (double)imageHeight) - 1;
                    int srcX = 0;
                    int srcY = 0;
                    if (PrintPreviewDialog.this.printMode == 1) {
                        destX = (int)(dpiScaleFactorX * (double)imageWidth * viewScaleFactor);
                        destY = (int)(dpiScaleFactorY * (double)imageHeight * viewScaleFactor);
                        int nbPagesX = (int)((double)destX / (viewScaleFactor * (double)rectangle.width)) + 1;
                        int nbPagesY = (int)((double)destY / (viewScaleFactor * (double)rectangle.height)) + 1;
                        PrintPreviewDialog.this.updateNavigation(nbPagesX, nbPagesY);
                        srcX = (int)((double)rectangle.width / dpiScaleFactorX) * (PrintPreviewDialog.this.pageNavigation.x - 1);
                        srcY = (int)((double)rectangle.height / dpiScaleFactorY) * (PrintPreviewDialog.this.pageNavigation.y - 1);
                        imageWidth = (double)(PrintPreviewDialog.this.pageNavigation.x * rectangle.width) / dpiScaleFactorX > (double)imageWidth ? (int)((double)imageWidth - (double)((PrintPreviewDialog.this.pageNavigation.x - 1) * rectangle.width) / dpiScaleFactorX) : (int)((double)rectangle.width / dpiScaleFactorX);
                        imageHeight = (double)(PrintPreviewDialog.this.pageNavigation.y * rectangle.height) / dpiScaleFactorY > (double)imageHeight ? (int)((double)imageHeight - (double)((PrintPreviewDialog.this.pageNavigation.y - 1) * rectangle.height) / dpiScaleFactorY) : (int)((double)rectangle.height / dpiScaleFactorY);
                        destX = (int)(dpiScaleFactorX * (double)imageWidth * viewScaleFactor) - 1;
                        destY = (int)(dpiScaleFactorY * (double)imageHeight * viewScaleFactor) - 1;
                    }
                    e.gc.drawImage(PrintPreviewDialog.this.image, srcX, srcY, imageWidth, imageHeight, offsetX + 1, offsetY + 1, destX, destY);
                }
            }
        });
        Group optionsGroup = new Group((Composite)this.shell, 0);
        optionsGroup.setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.PrintOptions"));
        FormLayout optionsLayout = new FormLayout();
        optionsLayout.marginWidth = 5;
        optionsLayout.marginHeight = 5;
        optionsGroup.setLayout((Layout)optionsLayout);
        gridData = new GridData(768, 128, false, false);
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        optionsGroup.setLayoutData((Object)gridData);
        Button adjustCheck = new Button((Composite)optionsGroup, 32);
        adjustCheck.setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.FitToPage"));
        adjustCheck.setSelection(true);
        adjustCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    PrintPreviewDialog.this.printMode = 2;
                    PrintPreviewDialog.this.updateNavigation(1, 1);
                } else {
                    PrintPreviewDialog.this.printMode = 1;
                }
                PrintPreviewDialog.this.canvas.redraw();
            }
        });
        Composite cButtons = new Composite((Composite)this.shell, 0);
        FillLayout orientationLayout = new FillLayout();
        orientationLayout.type = 512;
        orientationLayout.marginWidth = 5;
        orientationLayout.marginHeight = 5;
        orientationLayout.spacing = 5;
        cButtons.setLayout((Layout)orientationLayout);
        gridData = new GridData(131072, 128, false, false);
        gridData.widthHint = 100;
        gridData.verticalSpan = 3;
        cButtons.setLayoutData((Object)gridData);
        Button printButton = new Button(cButtons, 8);
        printButton.setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.Print"));
        printButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int style = PrintPreviewDialog.this.shell.getStyle();
                Shell shell_1 = new Shell((style & 0x8000000) != 0 ? 0x4000000 : 0);
                PrintDialog dialog = new PrintDialog(shell_1, 0);
                PrinterData pData = new PrinterData();
                pData.orientation = PrintPreviewDialog.this.printer.getPrinterData().orientation;
                dialog.setPrinterData(pData);
                PrinterData data = dialog.open();
                if (data != null) {
                    PrintPreviewDialog.this.printer = new Printer(data);
                    if (PrintPreviewDialog.this.printer.startJob("print Link Editor") && PrintPreviewDialog.this.printer.startPage()) {
                        GC gc = new GC((Drawable)PrintPreviewDialog.this.printer);
                        ImageData imageData = PrintPreviewDialog.this.image.getImageData();
                        Image printerImage = new Image((Device)PrintPreviewDialog.this.printer, imageData);
                        Point screenDPI = PrintPreviewDialog.this.shell.getDisplay().getDPI();
                        Point printerDPI = PrintPreviewDialog.this.printer.getDPI();
                        int srcX = 0;
                        int srcY = 0;
                        int padding = 5;
                        int imageWidth = imageData.width;
                        int imageHeight = imageData.height;
                        Rectangle trim = PrintPreviewDialog.this.printer.computeTrim(0, 0, 0, 0);
                        int scaleForX = (printerDPI.x - padding * 2) / screenDPI.x;
                        int scaleForY = (printerDPI.y - padding * 2) / screenDPI.y;
                        int scaleFactor = Math.min(scaleForX, scaleForY);
                        int destX = scaleFactor * imageWidth;
                        int destY = scaleFactor * imageHeight;
                        if (PrintPreviewDialog.this.printMode == 2) {
                            scaleForX = (PrintPreviewDialog.this.printer.getBounds().width - padding * 2) / imageWidth;
                            scaleForY = (PrintPreviewDialog.this.printer.getBounds().height - padding * 2) / imageHeight;
                            scaleFactor = Math.min(scaleForX, scaleForY);
                            destX = scaleFactor * imageWidth;
                            destY = scaleFactor * imageHeight;
                        }
                        gc.drawImage(printerImage, srcX, srcY, imageWidth, imageHeight, -trim.x, -trim.y, destX, destY);
                        printerImage.dispose();
                        gc.dispose();
                        PrintPreviewDialog.this.printer.endPage();
                    }
                    PrintPreviewDialog.this.printer.endJob();
                }
                shell_1.dispose();
            }
        });
        Button closeButton = new Button(cButtons, 8);
        closeButton.setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.Cancel"));
        closeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this.shell.dispose();
            }
        });
        Group orientationGroup = new Group((Composite)this.shell, 0);
        orientationGroup.setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.Orientation"));
        orientationLayout = new FillLayout();
        orientationLayout.type = 512;
        orientationLayout.marginWidth = 5;
        orientationLayout.marginHeight = 10;
        orientationGroup.setLayout((Layout)orientationLayout);
        gridData = new GridData(768, 128, false, false);
        gridData.verticalSpan = 2;
        gridData.widthHint = 150;
        gridData.heightHint = 60;
        orientationGroup.setLayoutData((Object)gridData);
        Button[] orientation = new Button[2];
        orientation[0] = new Button((Composite)orientationGroup, 16);
        orientation[0].setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.Portrait"));
        orientation[0].setSelection(true);
        orientation[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    PrintPreviewDialog.this.printer.getPrinterData().orientation = 1;
                    PrintPreviewDialog.this.printer = new Printer(PrintPreviewDialog.this.printer.getPrinterData());
                    PrintPreviewDialog.this.canvas.redraw();
                }
            }
        });
        orientation[1] = new Button((Composite)orientationGroup, 16);
        orientation[1].setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.Landscape"));
        orientation[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    PrintPreviewDialog.this.printer.getPrinterData().orientation = 2;
                    PrintPreviewDialog.this.printer = new Printer(PrintPreviewDialog.this.printer.getPrinterData());
                    PrintPreviewDialog.this.canvas.redraw();
                }
            }
        });
        this.previousButton = new Button((Composite)this.shell, 8);
        this.previousButton.setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.Previous"));
        this.previousButton.setEnabled(false);
        gridData = new GridData(131072, 128, true, false);
        gridData.widthHint = 100;
        this.previousButton.setLayoutData((Object)gridData);
        this.previousButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (PrintPreviewDialog.this.pageNavigation != null && !PrintPreviewDialog.this.pageNavigation.isFirstPage()) {
                    PrintPreviewDialog.this.pageNavigation.goPreviousPage();
                    PrintPreviewDialog.this.canvas.redraw();
                }
                if (PrintPreviewDialog.this.pageNavigation != null) {
                    if (PrintPreviewDialog.this.pageNavigation.isFirstPage()) {
                        PrintPreviewDialog.this.previousButton.setEnabled(false);
                    }
                    if (!PrintPreviewDialog.this.pageNavigation.isLastPage()) {
                        PrintPreviewDialog.this.nextButton.setEnabled(true);
                    }
                }
                PrintPreviewDialog.this.updatePageCounter();
            }
        });
        this.nextButton = new Button((Composite)this.shell, 8);
        this.nextButton.setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.Next"));
        this.nextButton.setEnabled(false);
        gridData = new GridData(16384, 128, false, false);
        gridData.widthHint = 100;
        this.nextButton.setLayoutData((Object)gridData);
        this.nextButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (PrintPreviewDialog.this.pageNavigation != null && !PrintPreviewDialog.this.pageNavigation.isLastPage()) {
                    PrintPreviewDialog.this.pageNavigation.goNextPage();
                    PrintPreviewDialog.this.canvas.redraw();
                }
                if (PrintPreviewDialog.this.pageNavigation != null) {
                    if (PrintPreviewDialog.this.pageNavigation.isLastPage()) {
                        PrintPreviewDialog.this.nextButton.setEnabled(false);
                    }
                    if (!PrintPreviewDialog.this.pageNavigation.isFirstPage()) {
                        PrintPreviewDialog.this.previousButton.setEnabled(true);
                    }
                }
                PrintPreviewDialog.this.updatePageCounter();
            }
        });
        this.pagesLabel = new Label((Composite)this.shell, 0);
        this.pagesLabel.setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.Page") + " 1/1");
        gridData = new GridData(131072, 0x1000000, true, false);
        gridData.widthHint = 100;
        this.pagesLabel.setLayoutData((Object)gridData);
        this.shell.setSize(600, 500);
        this.shell.setMinimumSize(600, 500);
        this.shell.open();
        this.setPrinter(null, 1.0);
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        if (this.image != null) {
            this.image.dispose();
        }
    }

    private void setPrinter(Printer p_printer, double marginSize) {
        if (p_printer == null) {
            PrinterData[] list;
            PrinterData printerData = Printer.getDefaultPrinterData();
            if (printerData == null && (list = Printer.getPrinterList()).length > 0) {
                printerData = list[0];
            }
            this.printer = new Printer(printerData);
        } else {
            this.printer = p_printer;
        }
        this.margin = PrintMargin.getPrintMargin(this.printer, marginSize);
        this.canvas.redraw();
    }

    private void updatePageCounter() {
        this.pagesLabel.setText(LinkEditor.I18N.getString("Gui.PrintPreviewDialog.Page") + " " + this.pageNavigation.getCurrentPageNumber() + "/" + this.pageNavigation.getTotalPages());
    }

    private void updateNavigation(int nbPagesX, int nbPagesY) {
        if (this.pageNavigation == null) {
            this.pageNavigation = new PrintPageNavigation(nbPagesX, nbPagesY);
            if (nbPagesX > 1 || nbPagesY > 1) {
                this.nextButton.setEnabled(true);
            }
        } else if (nbPagesX > 1 || nbPagesY > 1) {
            if (this.pageNavigation.getNbPagesX() != nbPagesX || this.pageNavigation.getNbPagesY() != nbPagesY) {
                this.pageNavigation.setNbPagesX(nbPagesX);
                this.pageNavigation.setNbPagesY(nbPagesY);
                this.pageNavigation.x = 1;
                this.pageNavigation.y = 1;
            }
            if (this.pageNavigation.isFirstPage()) {
                this.previousButton.setEnabled(false);
            } else {
                this.previousButton.setEnabled(true);
            }
            if (this.pageNavigation.isLastPage()) {
                this.nextButton.setEnabled(false);
            } else {
                this.nextButton.setEnabled(true);
            }
        } else {
            this.pageNavigation.x = 1;
            this.pageNavigation.y = 1;
            this.pageNavigation.setNbPagesX(1);
            this.pageNavigation.setNbPagesY(1);
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
        }
        this.updatePageCounter();
    }
}

