/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.handlers.relateddiagrams;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.modelio.linkeditor.gef.background.BackgroundEditPart;
import org.modelio.linkeditor.gef.node.NodeEditPart;
import org.modelio.linkeditor.panel.model.GraphNode;
import org.modelio.linkeditor.plugin.LinkEditor;
import org.modelio.metamodel.diagrams.AbstractDiagram;
import org.modelio.metamodel.mmextensions.standard.facilities.RelatedDiagramHelper;
import org.modelio.metamodel.uml.infrastructure.ModelElement;
import org.modelio.platform.model.ui.swt.images.MetamodelImageService;
import org.modelio.vcore.smkernel.mapi.MClass;

public class RelatedDiagramsMenuCreator {
    @Inject
    protected MApplication application;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        ModelElement selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            Set related = RelatedDiagramHelper.getRelatedDiagrams((ModelElement)selectedElement);
            ArrayList<AbstractDiagram> displaying = new ArrayList<AbstractDiagram>((Collection<AbstractDiagram>)selectedElement.getDiagramElement());
            if (related.isEmpty() && displaying.isEmpty()) {
                return;
            }
            displaying.removeAll(related);
            items.add((MMenuElement)this.createMenu(related, displaying));
        }
    }

    public MMenu createMenu(Collection<AbstractDiagram> relatedDiagrams, Collection<AbstractDiagram> displaying) {
        MMenu elementCreationMenu = MMenuFactory.INSTANCE.createMenu();
        elementCreationMenu.setLabel(LinkEditor.I18N.getString("RelatedDiagrams.label"));
        elementCreationMenu.setIconURI("platform:/plugin/org.modelio.app.link.editor/icons/relateddiagram.png");
        elementCreationMenu.setEnabled(true);
        elementCreationMenu.setToBeRendered(true);
        elementCreationMenu.setVisible(true);
        elementCreationMenu.setContributorURI("platform:/plugin/org.modelio.app.link.editor");
        List menuChildren = elementCreationMenu.getChildren();
        if (!relatedDiagrams.isEmpty()) {
            this.createDiagramItems(menuChildren, relatedDiagrams, "platform:/plugin/org.modelio.app.link.editor");
        }
        if (!displaying.isEmpty()) {
            MMenuSeparator sep = MMenuFactory.INSTANCE.createMenuSeparator();
            sep.setContributorURI("platform:/plugin/org.modelio.app.link.editor");
            sep.setToBeRendered(true);
            sep.setVisible(true);
            menuChildren.add(sep);
            this.createDiagramItems(menuChildren, displaying, "platform:/plugin/org.modelio.app.link.editor");
        }
        return elementCreationMenu;
    }

    private void createDiagramItems(Collection<MMenuElement> menuChildren, Collection<AbstractDiagram> relatedDiagrams, String contributorId) {
        ArrayList<AbstractDiagram> sortedDiagram = new ArrayList<AbstractDiagram>(relatedDiagrams);
        Collections.sort(sortedDiagram, new Comparator<AbstractDiagram>(){

            @Override
            public int compare(AbstractDiagram o1, AbstractDiagram o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (AbstractDiagram diagram : relatedDiagrams) {
            menuChildren.add(this.createDiagramItems(diagram, contributorId));
        }
    }

    private MMenuElement createDiagramItems(AbstractDiagram diagram, String contributorId) {
        MHandledMenuItem relatedDiagramItem = MMenuFactory.INSTANCE.createHandledMenuItem();
        relatedDiagramItem.setLabel(diagram.getName());
        relatedDiagramItem.setIconURI(MetamodelImageService.getIconCompletePath((MClass)diagram.getMClass()));
        relatedDiagramItem.setEnabled(true);
        relatedDiagramItem.setToBeRendered(true);
        relatedDiagramItem.setVisible(true);
        relatedDiagramItem.setContributorURI(contributorId);
        MCommand command = this.getCommand("org.modelio.app.ui.command.openrelateddiagram");
        relatedDiagramItem.setCommand(command);
        MParameter p = MCommandsFactory.INSTANCE.createParameter();
        p.setName("org.modelio.app.ui.command.parameter.related_diagram");
        p.setValue(diagram.getUuid().toString());
        relatedDiagramItem.getParameters().add(p);
        p.setContributorURI(contributorId);
        return relatedDiagramItem;
    }

    private MCommand getCommand(String commandId) {
        for (MCommand c : this.application.getCommands()) {
            if (!commandId.equals(c.getElementId())) continue;
            return c;
        }
        return null;
    }

    private ModelElement getSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.application.getContext().get("org.eclipse.ui.selection");
        if (selection == null || selection.size() != 1) {
            return null;
        }
        List selectedObjects = selection.toList();
        for (Object selectedObject : selectedObjects) {
            GraphNode node;
            if (!(selectedObject instanceof NodeEditPart ? (node = ((NodeEditPart)((Object)selectedObject)).getModel()).getData() != null : selectedObject instanceof BackgroundEditPart && (node = ((BackgroundEditPart)selectedObject).getModel().getCenter()).getData() != null)) continue;
            return (ModelElement)node.getData();
        }
        return null;
    }
}

