/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.handlers.rightdepth;

import jakarta.annotation.PostConstruct;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Spinner;
import org.modelio.linkeditor.plugin.LinkEditor;
import org.modelio.linkeditor.view.ILinkEditorView;

public class RightDepthSpinner {
    private static final int MINIMUM_DEPTH = 0;
    private static final int MAXIMUM_DEPTH = 4;
    private Spinner spinner;

    @PostConstruct
    protected Control createControl(Composite parent, MPart part) {
        if (!(part.getObject() instanceof ILinkEditorView)) {
            return null;
        }
        final ILinkEditorView linkEditorView = (ILinkEditorView)part.getObject();
        this.spinner = new Spinner(parent, 2048);
        this.spinner.setMinimum(0);
        int selectedValue = linkEditorView.getLinkEditor().getConfigurator().getRightDepth();
        this.spinner.setValues(selectedValue, 0, 4, 0, 1, 1);
        this.spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                linkEditorView.getLinkEditor().getConfigurator().setRightDepth(RightDepthSpinner.this.getSpinner().getSelection());
            }
        });
        this.spinner.setToolTipText(LinkEditor.I18N.getString("RightDepthSpinner.tooltip"));
        this.spinner.pack();
        return this.spinner;
    }

    Spinner getSpinner() {
        return this.spinner;
    }

    public void setSpinnerValue(final int depth) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Spinner aSpinner = RightDepthSpinner.this.getSpinner();
                if (!aSpinner.isDisposed()) {
                    aSpinner.setValues(depth, 0, 4, 0, 1, 1);
                }
            }
        });
    }

    public int getValue() {
        return this.spinner.getSelection();
    }
}

