/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.handlers.selectinexplorer;

import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.modelio.linkeditor.gef.background.BackgroundEditPart;
import org.modelio.linkeditor.gef.edge.EdgeEditPart;
import org.modelio.linkeditor.gef.node.NodeEditPart;
import org.modelio.linkeditor.panel.model.GraphNode;
import org.modelio.metamodel.impact.ImpactLink;
import org.modelio.platform.core.navigate.IModelioNavigationService;
import org.modelio.vcore.smkernel.mapi.MObject;

public class SelectInExplorerHandler {
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") ISelection iSelection, IModelioNavigationService navigationService) {
        navigationService.fireNavigate(this.getSelection(iSelection));
    }

    protected List<MObject> getSelection(ISelection selection) {
        ArrayList<MObject> selectedElements = new ArrayList<MObject>();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object selectedObject : selectedObjects) {
                GraphNode node;
                if (selectedObject instanceof EdgeEditPart) {
                    Edge edge = (Edge)((EdgeEditPart)((Object)selectedObject)).getModel();
                    if (edge.data == null || !(edge.data instanceof MObject)) continue;
                    selectedElements.add((MObject)edge.data);
                    continue;
                }
                if (selectedObject instanceof NodeEditPart) {
                    node = ((NodeEditPart)((Object)selectedObject)).getModel();
                    if (node.getData() == null) continue;
                    selectedElements.add(node.getData());
                    continue;
                }
                if (!(selectedObject instanceof BackgroundEditPart) || (node = ((BackgroundEditPart)selectedObject).getModel().getCenter()).getData() == null) continue;
                selectedElements.add(node.getData());
            }
        }
        return selectedElements;
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection iSelection) {
        List<MObject> listSelection = this.getSelection(iSelection);
        for (MObject selectedElement : listSelection) {
            if (!(selectedElement instanceof ImpactLink)) continue;
            return false;
        }
        return listSelection.size() > 0;
    }
}

