/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.panel;

import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

class ImageBuilder {
    private static final int MARGIN = 10;

    ImageBuilder() {
    }

    public Image makeImage(RootEditPart rootEditPart) {
        LayerManager lm = (LayerManager)rootEditPart;
        Layer printableLayers = (Layer)lm.getLayer((Object)"Printable Layers");
        ConnectionLayer connectionLayer = (ConnectionLayer)lm.getLayer((Object)"Connection Layer");
        Rectangle contentsBounds = this.computeContentsBounds(((GraphicalEditPart)rootEditPart.getContents()).getFigure(), connectionLayer);
        Image img = new Image((Device)Display.getDefault(), contentsBounds.width + 20, contentsBounds.height + 20);
        GC imageGC = new GC((Drawable)img);
        int deltaX = 10 + -contentsBounds.x;
        int deltaY = 10 + -contentsBounds.y;
        SWTGraphics graphics = new SWTGraphics(imageGC);
        graphics.translate(deltaX, deltaY);
        graphics.setClip(contentsBounds);
        printableLayers.paint((Graphics)graphics);
        graphics.dispose();
        imageGC.dispose();
        return img;
    }

    private Rectangle computeContentsBounds(IFigure backgroundFigure, ConnectionLayer connectionLayer) {
        Rectangle results = null;
        results = this.computeMinimumBounds(backgroundFigure);
        results.union(this.computeMinimumBounds(connectionLayer));
        return results;
    }

    private Rectangle computeMinimumBounds(ConnectionLayer connectionLayer) {
        int xMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (Object o : connectionLayer.getChildren()) {
            Rectangle b = ((Figure)o).getBounds();
            if (b.x < xMin) {
                xMin = b.x;
            }
            if (b.x + b.width > xMax) {
                xMax = b.x + b.width;
            }
            if (b.y < yMin) {
                yMin = b.y;
            }
            if (b.y + b.height <= yMax) continue;
            yMax = b.y + b.height;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    private Rectangle computeMinimumBounds(IFigure figure) {
        int xMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (Object fig : figure.getChildren()) {
            Rectangle b = ((Figure)fig).getBounds();
            if (b.x < xMin) {
                xMin = b.x;
            }
            if (b.x + b.width > xMax) {
                xMax = b.x + b.width;
            }
            if (b.y < yMin) {
                yMin = b.y;
            }
            if (b.y + b.height <= yMax) continue;
            yMax = b.y + b.height;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }
}

