/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.panel;

import org.modelio.linkeditor.panel.ILinkEditorConfiguration;
import org.modelio.linkeditor.panel.ILinkEditorFilter;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.vcore.smkernel.mapi.MClass;

public class LinkEditorConfiguration
implements ILinkEditorConfiguration {
    private int leftDepth = 1;
    private int rightDepth = 1;
    private ILinkEditorConfiguration.Orientation layoutOrientation = ILinkEditorConfiguration.Orientation.Horizontal;
    private static final ILinkEditorFilter ANY_LINK = new ILinkEditorFilter(){

        @Override
        public boolean accept(MClass enabledLinkType, Stereotype st) {
            return true;
        }

        @Override
        public boolean isLinkTypeEnabled(MClass mc) {
            return true;
        }
    };
    private ILinkEditorFilter linkFilter = ANY_LINK;

    public LinkEditorConfiguration(int leftDepth, int rightDepth, ILinkEditorConfiguration.Orientation orientation, ILinkEditorFilter linkFilter) {
        this.leftDepth = leftDepth;
        this.rightDepth = rightDepth;
        this.layoutOrientation = orientation;
        this.linkFilter = linkFilter != null ? linkFilter : ANY_LINK;
    }

    LinkEditorConfiguration() {
        this.leftDepth = 1;
        this.rightDepth = 1;
        this.layoutOrientation = ILinkEditorConfiguration.Orientation.Horizontal;
        this.linkFilter = ANY_LINK;
    }

    LinkEditorConfiguration(ILinkEditorConfiguration config) {
        this(config.getLeftDepth(), config.getRightDepth(), config.getLayoutOrientation(), config.getLinkFilter());
    }

    public void apply(ILinkEditorConfiguration aConfig) {
        this.setLeftDepth(aConfig.getLeftDepth());
        this.setRightDepth(aConfig.getRightDepth());
        this.setLayoutOrientation(aConfig.getLayoutOrientation());
        this.setLinkFilter(aConfig.getLinkFilter());
    }

    @Override
    public ILinkEditorConfiguration.Orientation getLayoutOrientation() {
        return this.layoutOrientation;
    }

    @Override
    public int getLeftDepth() {
        return this.leftDepth;
    }

    @Override
    public ILinkEditorFilter getLinkFilter() {
        return this.linkFilter;
    }

    @Override
    public int getRightDepth() {
        return this.rightDepth;
    }

    public void setLayoutOrientation(ILinkEditorConfiguration.Orientation value) {
        this.layoutOrientation = value;
    }

    public void setLeftDepth(int value) {
        this.leftDepth = value;
    }

    public void setLinkFilter(ILinkEditorFilter linkFilter) {
        this.linkFilter = linkFilter != null ? linkFilter : ANY_LINK;
    }

    public void setRightDepth(int value) {
        this.rightDepth = value;
    }
}

