/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.panel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.modelio.linkeditor.panel.ILinkEditorConfiguration;
import org.modelio.linkeditor.panel.ILinkEditorConfigurator;
import org.modelio.linkeditor.panel.ILinkEditorFilter;
import org.modelio.linkeditor.panel.LinkEditorConfiguration;

class LinkEditorConfigurator
implements ILinkEditorConfigurator {
    private boolean batch = false;
    private LinkEditorConfiguration config;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public LinkEditorConfigurator(LinkEditorConfiguration config) {
        this.config = config;
    }

    @Override
    public int getLeftDepth() {
        return this.config.getLeftDepth();
    }

    @Override
    public int getRightDepth() {
        return this.config.getRightDepth();
    }

    @Override
    public void setLeftDepth(int depth) {
        this.config.setLeftDepth(depth);
        this.refreshLinkEditor();
    }

    @Override
    public void setRightDepth(int depth) {
        this.config.setRightDepth(depth);
        this.refreshLinkEditor();
    }

    @Override
    public ILinkEditorConfiguration.Orientation getLayoutOrientation() {
        return this.config.getLayoutOrientation();
    }

    @Override
    public void setLayoutOrientation(ILinkEditorConfiguration.Orientation o) {
        switch (o) {
            case Horizontal: 
            case Vertical: {
                this.config.setLayoutOrientation(o);
            }
        }
        this.refreshLinkEditor();
    }

    @Override
    public ILinkEditorFilter getLinkFilter() {
        return this.config.getLinkFilter();
    }

    @Override
    public void setLinkFilter(ILinkEditorFilter linkFilter) {
        this.config.setLinkFilter(linkFilter);
        this.refreshLinkEditor();
    }

    private void refreshLinkEditor() {
        if (!this.batch) {
            this.firePropertyChange();
        }
    }

    @Override
    public void apply(ILinkEditorConfiguration aConfig) {
        this.batch = true;
        this.config.setLeftDepth(aConfig.getLeftDepth());
        this.config.setRightDepth(aConfig.getRightDepth());
        this.config.setLayoutOrientation(aConfig.getLayoutOrientation());
        this.config.setLinkFilter(aConfig.getLinkFilter());
        this.batch = false;
        this.refreshLinkEditor();
    }

    private void firePropertyChange() {
        this.listeners.firePropertyChange(new PropertyChangeEvent(this, "CONFIG", null, null));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
        this.listeners.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }
}

