/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.panel;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.modelio.linkeditor.gef.background.BackgroundEditPart;
import org.modelio.linkeditor.gef.edge.EdgeEditPart;
import org.modelio.linkeditor.gef.tools.PanSelectionTool;
import org.modelio.linkeditor.gef.tools.PickingSelectionTool;
import org.modelio.linkeditor.panel.ILinkEditorConfiguration;
import org.modelio.linkeditor.panel.ImageBuilder;
import org.modelio.linkeditor.panel.LinkEditorPanelUi;
import org.modelio.linkeditor.panel.model.BackgroundModel;
import org.modelio.platform.core.navigate.IModelioNavigationService;
import org.modelio.platform.core.picking.IPickingSession;
import org.modelio.platform.model.ui.swt.SelectionHelper;
import org.modelio.platform.project.services.IProjectService;
import org.modelio.platform.ui.UIThreadRunner;
import org.modelio.vcore.smkernel.mapi.MObject;

class LinkEditorPanelController {
    private boolean editMode;
    private final EMenuService menuService;
    private final IEclipseContext eclipseContext;
    private final ESelectionService selectionService;
    private final MItem editModeToobarButton;
    private IStructuredSelection deferredAppSelection;
    private final IModelioNavigationService navigationService;
    private final IProjectService projectService;
    private LinkEditorPanelUi ui;
    private final ILinkEditorConfiguration config;
    private final BackgroundModel backgroundModel = new BackgroundModel();
    private AtomicBoolean refreshScheduled = new AtomicBoolean(false);

    LinkEditorPanelUi createUi(Composite parent) {
        this.ui = new LinkEditorPanelUi(parent, this);
        this.ui.setDoubleClickListener(() -> this.setEditMode(!this.isEditMode()));
        this.onModelChanged();
        return this.ui;
    }

    void setInput(MObject mObj) {
        this.backgroundModel.setInput(mObj);
        this.refreshView();
    }

    IModelioNavigationService getNavigationService() {
        return this.navigationService;
    }

    IProjectService getProjectService() {
        return this.projectService;
    }

    EMenuService getMenuService() {
        return this.menuService;
    }

    void startPicking(IPickingSession session) {
        this.ui.getComposite().getDisplay().asyncExec(() -> this.ui.setActiveTool((Tool)new PickingSelectionTool(session)));
    }

    void stopPicking(IPickingSession session) {
        this.ui.getComposite().getDisplay().asyncExec(() -> this.ui.setActiveTool((Tool)new PanSelectionTool(this.navigationService)));
    }

    void onModelChanged() {
        this.backgroundModel.rebuild();
        this.refreshView();
    }

    public double getZoomLevel() {
        ZoomManager zm = ((ScalableFreeformRootEditPart)this.ui.getGraphicalViewer().getRootEditPart()).getZoomManager();
        return zm.getZoom();
    }

    public void setZoomLevel(double level) {
        ZoomManager zm = ((ScalableFreeformRootEditPart)this.ui.getGraphicalViewer().getRootEditPart()).getZoomManager();
        zm.setZoom(level);
    }

    public void print(PrinterData data) {
        PrintGraphicalViewerOperation operation = new PrintGraphicalViewerOperation(new Printer(data), this.ui.getGraphicalViewer());
        operation.setPrintMode(1);
        operation.run("Printing diagram");
    }

    public Image getImage() {
        return new ImageBuilder().makeImage(this.ui.getGraphicalViewer().getRootEditPart());
    }

    void setLayoutOrientation(ILinkEditorConfiguration.Orientation orientation) {
        ILinkEditorConfiguration.Orientation currentOrientation = (ILinkEditorConfiguration.Orientation)((Object)this.ui.getGraphicalViewer().getProperty("LAYOUT_ORIENTATION"));
        if (currentOrientation == orientation) {
            return;
        }
        switch (orientation) {
            case Horizontal: 
            case Vertical: {
                this.ui.getGraphicalViewer().setProperty("LAYOUT_ORIENTATION", (Object)orientation);
                break;
            }
            case Auto: {
                ILinkEditorConfiguration.Orientation recommended = this.config.getLayoutOrientation();
                if (recommended == ILinkEditorConfiguration.Orientation.Auto) {
                    recommended = ILinkEditorConfiguration.Orientation.Horizontal;
                }
                this.ui.getGraphicalViewer().setProperty("LAYOUT_ORIENTATION", (Object)recommended);
            }
        }
    }

    public void setEditMode(boolean onOff) {
        if (onOff != this.editMode) {
            this.editMode = onOff;
            this.ui.getGraphicalViewer().setProperty("EDIT_MODE", (Object)onOff);
            this.editModeToobarButton.setSelected(onOff);
            if (!onOff && this.deferredAppSelection != null) {
                this.onAppSelectionChange(this.deferredAppSelection);
                this.deferredAppSelection = null;
            }
        }
    }

    public IEclipseContext getEclipseContext() {
        return this.eclipseContext;
    }

    void onEditorSelectionChanged(ISelection selection) {
        if (!SelectionHelper.containsOnly((ISelection)selection, BackgroundEditPart.class)) {
            this.selectionService.setSelection((Object)selection);
        }
    }

    @Inject
    public LinkEditorPanelController(IEclipseContext eclipseContext, ILinkEditorConfiguration config, MPart e4Part, EMenuService menuService, EModelService e4ModelService, ESelectionService selectionService, IProjectService projectService, IModelioNavigationService navigationService) {
        this.eclipseContext = eclipseContext;
        this.config = config;
        this.menuService = menuService;
        this.selectionService = selectionService;
        this.projectService = projectService;
        this.navigationService = navigationService;
        this.editModeToobarButton = Objects.requireNonNull((MItem)e4ModelService.find("org.modelio.linkeditor.handledtoolitem.PinEditor", (MUIElement)e4Part.getToolbar()));
    }

    public void onConfigurationChanged() {
        this.setLayoutOrientation(this.config.getLayoutOrientation());
        this.backgroundModel.setConfiguration(this.config);
        this.refreshView();
    }

    @Inject
    @Optional
    private void onAppSelectionChange(@Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        if (SelectionHelper.contains((ISelection)selection, EdgeEditPart.class)) {
            return;
        }
        MObject mObj = (MObject)SelectionHelper.getFirst((ISelection)selection, MObject.class);
        if (mObj != null && !Objects.equals(mObj, this.getInput())) {
            if (this.isEditMode()) {
                this.deferredAppSelection = selection;
            } else {
                this.setInput(mObj);
            }
        }
    }

    public MObject getInput() {
        return this.backgroundModel.getInput();
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    private void refreshView() {
        if (this.ui == null || this.ui.getComposite().isDisposed()) {
            return;
        }
        if (!this.refreshScheduled.compareAndSet(false, true)) {
            return;
        }
        UIThreadRunner.asynExec((Widget)this.ui.getComposite(), () -> {
            this.refreshScheduled.set(false);
            if (this.ui != null) {
                MObject input = this.backgroundModel.getInput();
                if (this.isEditMode() && input != null && !input.isValid()) {
                    this.setEditMode(false);
                }
                this.ui.setInput(this.backgroundModel);
                this.backgroundModel.fireContentChanged();
            }
        });
    }
}

