/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.panel;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.Objects;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.modelio.linkeditor.panel.ILinkEditor;
import org.modelio.linkeditor.panel.ILinkEditorConfiguration;
import org.modelio.linkeditor.panel.ILinkEditorConfigurator;
import org.modelio.linkeditor.panel.ImageBuilder;
import org.modelio.linkeditor.panel.LinkEditorConfiguration;
import org.modelio.linkeditor.panel.LinkEditorConfigurator;
import org.modelio.linkeditor.panel.LinkEditorPanelController;
import org.modelio.linkeditor.panel.LinkEditorPanelUi;
import org.modelio.linkeditor.plugin.LinkEditor;
import org.modelio.platform.core.picking.IPickingSession;
import org.modelio.vcore.session.api.model.change.IModelChangeEvent;
import org.modelio.vcore.smkernel.mapi.MObject;

public class LinkEditorPanelProvider
implements ILinkEditor {
    @Inject
    private IEclipseContext eclipseContext;
    private LinkEditorPanelController controller;
    private LinkEditorPanelUi ui;
    private LinkEditorConfigurator configurator;

    public boolean isRelevantFor(Object input) {
        return input instanceof MObject;
    }

    public Composite createPanel(Composite parent) {
        this.ui = this.controller.createUi(parent);
        return this.ui.getComposite();
    }

    public Composite getPanel() {
        return this.ui.getComposite();
    }

    public String getHelpTopic() {
        return LinkEditor.I18N.getString("LinkEditorPanelProvider.HELP_TOPIC");
    }

    public MObject getInput() {
        return this.controller == null ? null : this.controller.getInput();
    }

    public void setInput(Object input) {
        MObject curInput;
        MObject mObj = input instanceof MObject ? (MObject)input : null;
        if (!Objects.equals(mObj, curInput = this.getInput())) {
            this.controller.setInput(mObj);
        }
    }

    public void dispose() {
        if (this.ui != null && this.ui.getComposite() != null) {
            this.ui.getComposite().dispose();
        }
        this.preDestroy();
    }

    @PostConstruct
    void postConstruct(IEclipseContext context) {
        LinkEditorConfiguration configurationData = new LinkEditorConfiguration();
        IEclipseContext staticContext = EclipseContextFactory.create();
        staticContext.set(ILinkEditorConfiguration.class, (Object)configurationData);
        this.controller = (LinkEditorPanelController)ContextInjectionFactory.make(LinkEditorPanelController.class, (IEclipseContext)context, (IEclipseContext)staticContext);
        staticContext.dispose();
        this.configurator = new LinkEditorConfigurator(configurationData);
        this.configurator.addPropertyChangeListener(evt -> this.controller.onConfigurationChanged());
    }

    public void modelChanged(IModelChangeEvent event) {
        this.controller.onModelChanged();
    }

    @Override
    public void setEditMode(boolean onOff) {
        this.controller.setEditMode(onOff);
    }

    @Override
    public ILinkEditorConfigurator getConfigurator() {
        return this.configurator;
    }

    @Override
    public boolean isEditMode() {
        return this.controller.isEditMode();
    }

    @Inject
    @Optional
    void onPickingStart(@EventTopic(value="org/modelio/app/core/picking/start") IPickingSession session) {
        this.controller.startPicking(session);
    }

    @Inject
    @Optional
    void onPickingStop(@EventTopic(value="org/modelio/app/core/picking/stop") IPickingSession session) {
        this.controller.stopPicking(session);
    }

    @PreDestroy
    void preDestroy() {
        this.configurator = null;
        this.controller = null;
        this.ui = null;
    }

    @Override
    public double getZoomLevel() {
        return this.controller.getZoomLevel();
    }

    @Override
    public void setZoomLevel(double level) {
        this.controller.setZoomLevel(level);
    }

    @Override
    public void print(PrinterData data) {
        this.controller.print(data);
    }

    @Override
    public Image getImage() {
        return new ImageBuilder().makeImage(this.ui.getGraphicalViewer().getRootEditPart());
    }
}

