/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.panel;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.modelio.linkeditor.gef.LinkEditorCommandStack;
import org.modelio.linkeditor.gef.LinkEditorEditPartFactory;
import org.modelio.linkeditor.gef.background.LinkEditorDropTargetListener;
import org.modelio.linkeditor.gef.node.NodeEditPart;
import org.modelio.linkeditor.gef.tools.PanSelectionTool;
import org.modelio.linkeditor.panel.LinkEditorPanelController;
import org.modelio.linkeditor.panel.model.BackgroundModel;
import org.modelio.linkeditor.panel.model.GraphNode;
import org.modelio.platform.ui.UIImages;

class LinkEditorPanelUi {
    private final GraphicalViewer graphicalViewer;
    private final EditDomain editDomain = new EditDomain();
    private final RootEditPart rootEditPart = new ScalableFreeformRootEditPart();
    private SelectionSynchronizer synchronizer;
    private final Composite composite;
    private ISelectionChangedListener viewerSelectionListener;
    private final LinkEditorPanelController controller;
    private Runnable doubleClickListener;

    LinkEditorPanelUi(Composite parent, LinkEditorPanelController controller) {
        this.controller = controller;
        this.composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.composite.setLayout((Layout)gl);
        this.graphicalViewer = this.createGraphicalViewer(this.composite, controller.getEclipseContext());
        this.editDomain.addViewer((EditPartViewer)this.graphicalViewer);
        GridData viewerLayoutData = new GridData();
        viewerLayoutData.grabExcessHorizontalSpace = true;
        viewerLayoutData.grabExcessVerticalSpace = true;
        viewerLayoutData.horizontalAlignment = 4;
        viewerLayoutData.verticalAlignment = 4;
        this.graphicalViewer.getControl().setLayoutData((Object)viewerLayoutData);
        Font systemFont = this.composite.getDisplay().getSystemFont();
        org.eclipse.swt.graphics.Rectangle iconSize = UIImages.PLACEHOLDER.getBounds();
        GraphNode.WIDTH = 1 + iconSize.width + 1 + FigureUtilities.getStringExtents((String)"abcdefghijklmnop...", (Font)systemFont).width() + 1;
        GraphNode.HEIGHT = 1 + (Math.max(iconSize.height, systemFont.getFontData()[0].getHeight()) + 1 + 2) * 2;
    }

    Composite getComposite() {
        return this.composite;
    }

    public void setInput(BackgroundModel model) {
        this.graphicalViewer.setContents((Object)model);
        if (model.getCenter() != null) {
            this.graphicalViewer.setSelection((ISelection)new StructuredSelection(this.graphicalViewer.getEditPartRegistry().get((Object)model.getCenter())));
        }
    }

    private GraphicalViewer createGraphicalViewer(Composite parent, IEclipseContext ctx) {
        HackedScrollingGraphicalViewer viewer = new HackedScrollingGraphicalViewer();
        viewer.createControl(parent);
        this.configureGraphicalViewer((GraphicalViewer)viewer, ctx);
        this.hookGraphicalViewer((GraphicalViewer)viewer);
        this.initializeGraphicalViewer((GraphicalViewer)viewer);
        viewer.addDropTargetListener((TransferDropTargetListener)new LinkEditorDropTargetListener((EditPartViewer)viewer, this.controller.getProjectService()));
        FocusListener focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                NodeEditPart.hasFocus = false;
            }

            public void focusGained(FocusEvent e) {
                NodeEditPart.hasFocus = true;
            }
        };
        viewer.getControl().addFocusListener(focusListener);
        return viewer;
    }

    private void configureGraphicalViewer(GraphicalViewer viewer, IEclipseContext ctx) {
        viewer.getControl().setBackground(ColorConstants.listBackground);
        viewer.setRootEditPart(this.rootEditPart);
        viewer.setEditPartFactory((EditPartFactory)new LinkEditorEditPartFactory(ctx));
        PanSelectionTool selectionTool = new PanSelectionTool(this.controller.getNavigationService());
        this.editDomain.setActiveTool((Tool)selectionTool);
        this.editDomain.setDefaultTool((Tool)selectionTool);
        viewer.setEditDomain(this.editDomain);
        this.editDomain.setCommandStack((CommandStack)new LinkEditorCommandStack(() -> this.controller.getProjectService().getSession()));
        int nZoomLevels = 32;
        double[] zoomLevels = new double[nZoomLevels];
        double progression = Math.sqrt(Math.sqrt(2.0));
        zoomLevels[nZoomLevels / 2] = 1.0;
        int i = nZoomLevels / 2 + 1;
        while (i < nZoomLevels) {
            zoomLevels[i] = zoomLevels[i - 1] * progression;
            ++i;
        }
        i = nZoomLevels / 2 - 1;
        while (i >= 0) {
            zoomLevels[i] = zoomLevels[i + 1] / progression;
            --i;
        }
        ZoomManager zoomManager = ((ScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager();
        zoomManager.setZoomLevels(zoomLevels);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.controller.getMenuService().registerContextMenu((Object)viewer.getControl(), "org.modelio.linkeditor.popupmenu");
    }

    protected void hookGraphicalViewer(GraphicalViewer viewer) {
        this.synchronizer = new SelectionSynchronizer();
        this.synchronizer.addViewer((EditPartViewer)viewer);
        this.viewerSelectionListener = event -> this.controller.onEditorSelectionChanged(event.getSelection());
        viewer.addSelectionChangedListener(this.viewerSelectionListener);
    }

    private void initializeGraphicalViewer(GraphicalViewer viewer) {
        BackgroundModel backgroundModel = new BackgroundModel();
        viewer.setContents((Object)backgroundModel);
    }

    public void setActiveTool(Tool tool) {
        this.editDomain.setActiveTool(tool);
    }

    GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    public void refresh() {
        this.graphicalViewer.getRootEditPart().getContents().refresh();
        this.graphicalViewer.getRootEditPart().refresh();
    }

    void setDoubleClickListener(Runnable listener) {
        this.doubleClickListener = listener;
        this.getGraphicalViewer().setProperty("switchEditModeRunnable", (Object)this.doubleClickListener);
    }

    private static class HackedScrollingGraphicalViewer
    extends ScrollingGraphicalViewer {
        private HackedScrollingGraphicalViewer() {
        }

        protected LightweightSystem createLightweightSystem() {
            return new LightweightSystem(){

                public void setControl(final Canvas c) {
                    super.setControl(c);
                    this.getUpdateManager().setGraphicsSource(new GraphicsSource(){

                        public Graphics getGraphics(Rectangle r) {
                            c.redraw(r.x, r.y, r.width, r.height, false);
                            return null;
                        }

                        public void flushGraphics(Rectangle region) {
                        }
                    });
                }
            };
        }
    }
}

