/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.linkeditor.panel.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.modelio.linkeditor.panel.ILinkEditorConfiguration;
import org.modelio.linkeditor.panel.model.BackgroundModel;
import org.modelio.linkeditor.panel.model.EdgeBus;
import org.modelio.linkeditor.panel.model.GraphNode;
import org.modelio.metamodel.uml.infrastructure.ModelElement;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MDependency;
import org.modelio.vcore.smkernel.mapi.MObject;

class TreeBuilder {
    private ILinkEditorConfiguration config;
    private List<MClass> linkMetaclasses;

    private Edge createEdge(BackgroundModel graph, MObject link, GraphNode sourceNode, GraphNode targetNode) {
        Edge busEdge;
        EdgeBus bus;
        Edge modifiedEdge;
        Object realFrom = sourceNode;
        Object realTo = targetNode;
        if (sourceNode.outgoing.size() > 0) {
            if (sourceNode.outgoing.getEdge((int)0).target instanceof EdgeBus) {
                realFrom = sourceNode.outgoing.getEdge((int)0).target;
            } else {
                modifiedEdge = sourceNode.outgoing.getEdge(0);
                bus = new EdgeBus();
                busEdge = new Edge((Node)sourceNode, (Node)bus);
                modifiedEdge.setSource((Node)bus);
                graph.addNode((Node)bus);
                graph.addEdge(busEdge);
                realFrom = bus;
            }
        }
        if (targetNode.incoming.size() > 0) {
            if (targetNode.incoming.getEdge((int)0).source instanceof EdgeBus) {
                realTo = targetNode.incoming.getEdge((int)0).source;
            } else {
                modifiedEdge = targetNode.incoming.getEdge(0);
                bus = new EdgeBus();
                busEdge = new Edge((Node)bus, (Node)targetNode);
                modifiedEdge.setTarget((Node)bus);
                graph.addNode((Node)bus);
                graph.addEdge(busEdge);
                realTo = bus;
            }
        }
        return new Edge((Object)link, (Node)realFrom, (Node)realTo);
    }

    private void doBuildLeftTree(BackgroundModel graph, GraphNode node, MObject element, int remainingDepth) {
        if (remainingDepth <= 0) {
            return;
        }
        for (MClass mc : this.linkMetaclasses) {
            for (MDependency dep : mc.getLinkMetaclassTargets()) {
                if (!element.getMClass().hasBase(dep.getTarget())) continue;
                for (MObject link : element.mGet(dep.getSymetric())) {
                    if (!link.getMClass().equals(mc) || !this.isDisplayed(link)) continue;
                    this.addLeftNode(graph, node, link, remainingDepth);
                }
            }
        }
    }

    private void doBuildRightTree(BackgroundModel graph, GraphNode node, MObject element, int remainingDepth) {
        if (remainingDepth <= 0) {
            return;
        }
        for (MClass mc : this.linkMetaclasses) {
            for (MDependency dep : mc.getLinkMetaclassSources()) {
                if (!element.getMClass().hasBase(dep.getTarget())) continue;
                for (MObject link : element.mGet(dep.getSymetric())) {
                    if (!link.getMClass().equals(mc) || !this.isDisplayed(link)) continue;
                    this.addRightNode(graph, node, link, remainingDepth);
                }
            }
        }
    }

    TreeBuilder(ILinkEditorConfiguration config) {
        this.config = config;
    }

    public void buildGraph(BackgroundModel graph, MObject element) {
        this.initLinkMetaclasses(element);
        GraphNode centralNode = new GraphNode(element);
        centralNode.setCentral(true);
        graph.addNode(centralNode);
        graph.setCenter(centralNode);
        this.doBuildLeftTree(graph, centralNode, element, this.config.getLeftDepth());
        this.doBuildRightTree(graph, centralNode, element, this.config.getRightDepth());
    }

    private void addLeftNode(BackgroundModel graph, GraphNode targetNode, MObject link, int remainingDepth) {
        for (MDependency symDep : link.getMClass().getLinkMetaclassSources()) {
            for (MObject source : link.mGet(symDep)) {
                this.addLeftNode(graph, targetNode, link, remainingDepth, source);
            }
        }
    }

    private void addRightNode(BackgroundModel graph, GraphNode sourceNode, MObject link, int remainingDepth) {
        for (MDependency symDep : link.getMClass().getLinkMetaclassTargets()) {
            for (MObject target : link.mGet(symDep)) {
                this.addRightNode(graph, sourceNode, link, remainingDepth, target);
            }
        }
    }

    private boolean isDisplayed(MObject link) {
        MClass mc = link.getMClass();
        if (link instanceof ModelElement && !((ModelElement)link).getExtension().isEmpty()) {
            for (Stereotype st : ((ModelElement)link).getExtension()) {
                if (!this.config.getLinkFilter().accept(mc, st)) continue;
                return true;
            }
        } else if (this.config.getLinkFilter().accept(mc, null)) {
            return true;
        }
        return false;
    }

    private void initLinkMetaclasses(MObject element) {
        this.linkMetaclasses = new ArrayList<MClass>();
        for (MClass mc : element.getMClass().getMetamodel().getRegisteredMClasses()) {
            if (!mc.isLinkMetaclass() || !this.config.getLinkFilter().isLinkTypeEnabled(mc)) continue;
            this.linkMetaclasses.add(mc);
        }
    }

    private void addLeftNode(BackgroundModel graph, GraphNode targetNode, MObject link, int remainingDepth, MObject source) {
        GraphNode sourceNode = new GraphNode(source);
        Edge newEdge = this.createEdge(graph, link, sourceNode, targetNode);
        graph.addNode(sourceNode);
        graph.addEdge(newEdge);
        this.doBuildLeftTree(graph, sourceNode, source, remainingDepth - 1);
    }

    private void addRightNode(BackgroundModel graph, GraphNode sourceNode, MObject link, int remainingDepth, MObject target) {
        GraphNode newNode = new GraphNode(target);
        Edge newEdge = this.createEdge(graph, link, sourceNode, newNode);
        graph.addNode(newNode);
        graph.addEdge(newEdge);
        this.doBuildRightTree(graph, newNode, target, remainingDepth - 1);
    }
}

