/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.archimate.metamodel.impl.expert;

import java.util.Iterator;
import org.modelio.archimate.metamodel.core.Relationship;
import org.modelio.archimate.metamodel.relationships.dependency.Access;
import org.modelio.archimate.metamodel.relationships.dependency.Influence;
import org.modelio.archimate.metamodel.relationships.dependency.Serving;
import org.modelio.archimate.metamodel.relationships.dynamic.DynamicRelationship;
import org.modelio.archimate.metamodel.relationships.other.Association;
import org.modelio.archimate.metamodel.relationships.other.Junction;
import org.modelio.archimate.metamodel.relationships.structural.Assignment;
import org.modelio.archimate.metamodel.relationships.structural.Realization;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.utils.metamodel.experts.ILinkExpertHelper;
import org.modelio.vcore.utils.metamodel.experts.links.WrappedLinkExpertHelper;

class RelationShipLinkExpertAdapter
extends WrappedLinkExpertHelper {
    private MClass mcJunction;

    public RelationShipLinkExpertAdapter(ILinkExpertHelper defaultExpert, MMetamodel mm) {
        super(defaultExpert);
        this.mcJunction = mm.getMClass(Junction.class);
        mm.getMClass(DynamicRelationship.class);
        mm.getMClass(Assignment.class);
        mm.getMClass(Realization.class);
        mm.getMClass(Association.class);
    }

    private boolean isAllowedJunctionLink(MClass mcls) {
        Class jcls = mcls.getJavaInterface();
        return DynamicRelationship.class.isAssignableFrom(jcls) || Assignment.class.isAssignableFrom(jcls) || Realization.class.isAssignableFrom(jcls) || Association.class.isAssignableFrom(jcls) || Serving.class.isAssignableFrom(jcls) || Access.class.isAssignableFrom(jcls) || Influence.class.isAssignableFrom(jcls);
    }

    public boolean canLink(MClass linkMetaclass, MClass from, MClass to) {
        int junctionState = 0;
        if (from.hasBase(this.mcJunction)) {
            junctionState |= 1;
        }
        if (to.hasBase(this.mcJunction)) {
            junctionState |= 2;
        }
        switch (junctionState) {
            case 0: {
                return super.canLink(linkMetaclass, from, to);
            }
            case 1: {
                return this.isAllowedJunctionLink(linkMetaclass) && super.canTarget(linkMetaclass, to);
            }
            case 2: {
                return this.isAllowedJunctionLink(linkMetaclass) && super.canSource(linkMetaclass, from);
            }
            case 3: {
                return this.isAllowedJunctionLink(linkMetaclass);
            }
        }
        throw new IllegalStateException(String.valueOf(junctionState));
    }

    public boolean canSource(MClass linkMetaclass, MClass from) {
        if (from.hasBase(this.mcJunction)) {
            return this.isAllowedJunctionLink(linkMetaclass);
        }
        return super.canSource(linkMetaclass, from);
    }

    public boolean canTarget(MClass linkMetaclass, MClass to) {
        if (to.hasBase(this.mcJunction)) {
            return this.isAllowedJunctionLink(linkMetaclass);
        }
        return super.canTarget(linkMetaclass, to);
    }

    public boolean canSource(MObject linkElement, MObject from) {
        if (from instanceof Junction) {
            if (this.isAllowedJunctionLink(linkElement.getMClass())) {
                MClass junctionType = this.getJunctionType((Junction)from);
                return junctionType == null || junctionType.equals(linkElement.getMClass());
            }
            return false;
        }
        return super.canSource(linkElement, from);
    }

    public boolean canTarget(MObject linkElement, MObject to) {
        if (to instanceof Junction) {
            if (this.isAllowedJunctionLink(linkElement.getMClass())) {
                MClass junctionType = this.getJunctionType((Junction)to);
                return junctionType == null || junctionType.equals(linkElement.getMClass());
            }
            return false;
        }
        return super.canTarget(linkElement, to);
    }

    public boolean canLink(MClass linkMetaclass, MObject from, MObject to) {
        MClass junctionType;
        int junctionState = 0;
        if (from instanceof Junction) {
            junctionState |= 1;
            junctionType = this.getJunctionType((Junction)from);
            if (junctionType != null && !junctionType.equals(linkMetaclass)) {
                return false;
            }
        }
        if (to instanceof Junction) {
            junctionState |= 2;
            junctionType = this.getJunctionType((Junction)to);
            if (junctionType != null && !junctionType.equals(linkMetaclass)) {
                return false;
            }
        }
        switch (junctionState) {
            case 0: {
                return super.canLink(linkMetaclass, from, to);
            }
            case 1: {
                return this.isAllowedJunctionLink(linkMetaclass) && super.canTarget(linkMetaclass, to.getMClass());
            }
            case 2: {
                return this.isAllowedJunctionLink(linkMetaclass) && super.canSource(linkMetaclass, from.getMClass());
            }
            case 3: {
                return this.isAllowedJunctionLink(linkMetaclass);
            }
        }
        throw new IllegalStateException(String.valueOf(junctionState));
    }

    private MClass getJunctionType(Junction j) {
        Iterator iterator = j.getRelatedFrom().iterator();
        if (iterator.hasNext()) {
            Relationship r = (Relationship)iterator.next();
            return r.getMClass();
        }
        iterator = j.getRelatedTo().iterator();
        if (iterator.hasNext()) {
            Relationship r = (Relationship)iterator.next();
            return r.getMClass();
        }
        return null;
    }
}

