/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.archimate.metamodel.impl.mmextensions.factory;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.modelio.archimate.metamodel.core.ArchimateView;
import org.modelio.archimate.metamodel.core.ViewPointDiagram;
import org.modelio.archimate.metamodel.core.structure.ArchimateProject;
import org.modelio.archimate.metamodel.core.structure.Folder;
import org.modelio.archimate.metamodel.core.structure.Model;
import org.modelio.archimate.metamodel.core.structure.ViewPoint;
import org.modelio.archimate.metamodel.core.structure.folder.ApplicationFolder;
import org.modelio.archimate.metamodel.core.structure.folder.BusinessFolder;
import org.modelio.archimate.metamodel.core.structure.folder.ImplementationFolder;
import org.modelio.archimate.metamodel.core.structure.folder.MotivationFolder;
import org.modelio.archimate.metamodel.core.structure.folder.PhysicalFolder;
import org.modelio.archimate.metamodel.core.structure.folder.StrategyFolder;
import org.modelio.archimate.metamodel.core.structure.folder.TechnologyFolder;
import org.modelio.archimate.metamodel.impl.mmextensions.factory.IArchimateElementInitializer;
import org.modelio.archimate.metamodel.mmextensions.archimate.IArchimateModelFactory;
import org.modelio.archimate.metamodel.visitors.DefaultArchimateVisitor;
import org.modelio.metamodel.uml.infrastructure.ModelElement;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MVisitor;

class ArchimateElementInitializer
implements IArchimateElementInitializer {
    private ElementInitializerVisitor visitor;

    public ArchimateElementInitializer(IArchimateModelFactory modelFactory) {
        this.visitor = new ElementInitializerVisitor(modelFactory);
    }

    @Override
    public void initialize(MObject element) {
        element.accept((MVisitor)this.visitor);
    }

    @Override
    public void setDefaultValue(String key, Object value) {
    }

    private static class ElementInitializerVisitor
    extends DefaultArchimateVisitor {
        private IArchimateModelFactory modelFactory;

        public ElementInitializerVisitor(IArchimateModelFactory modelFactory) {
            this.modelFactory = modelFactory;
        }

        public Object visitArchimateProject(ArchimateProject project) {
            Model model = this.modelFactory.createModel();
            model.setProject(project);
            model.setName("Model");
            ViewPoint viewPoint = this.modelFactory.createViewPoint();
            viewPoint.setProject(project);
            viewPoint.setName("ViewPoint");
            viewPoint.setContext(model);
            return super.visitArchimateProject(project);
        }

        public Object visitModel(Model model) {
            List<Class> cls = Arrays.asList(ApplicationFolder.class, BusinessFolder.class, ImplementationFolder.class, MotivationFolder.class, PhysicalFolder.class, StrategyFolder.class, TechnologyFolder.class);
            for (Class mc : cls) {
                Folder folder = (Folder)this.modelFactory.createElement(mc);
                model.getFolder().add((Object)folder);
                folder.setName(mc.getSimpleName().replace("Folder", ""));
            }
            return super.visitModel(model);
        }

        public Object visitViewPoint(ViewPoint viewPoint) {
            ViewPointDiagram vpDiagrap = this.modelFactory.createViewPointDiagram();
            vpDiagrap.setOrigin((ModelElement)viewPoint);
            vpDiagrap.setName("ViewPointDiagram");
            ArchimateView archimateView = this.modelFactory.createArchimateView();
            archimateView.setOrigin((ModelElement)viewPoint);
            archimateView.setName("ArchimateView");
            ArchimateProject project = viewPoint.getProject();
            if (project != null) {
                Iterator iterator = project.getModel().iterator();
                if (iterator.hasNext()) {
                    Model model = (Model)iterator.next();
                    viewPoint.setContext(model);
                }
            } else {
                ViewPoint parentViewPoint = viewPoint.getParent();
                if (parentViewPoint != null) {
                    viewPoint.setContext(parentViewPoint.getContext());
                }
            }
            return super.visitViewPoint(viewPoint);
        }
    }
}

