/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject;

import java.io.IOException;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.version.VersionedItem;
import org.modelio.vcore.model.spi.mm.MmVersionComparator;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;

public class FragmentMigrationNeededException
extends Exception {
    private String fragmentId;
    private static final long serialVersionUID = 1L;
    private String detailMessage;
    private boolean remoteMigrationNeeded;
    private MetamodelVersionDescriptor fragmentVersion;
    private MetamodelVersionDescriptor targetVersion;

    public FragmentMigrationNeededException(IGModelFragment fragment, MetamodelVersionDescriptor targetVersion) {
        super(FragmentMigrationNeededException.computeMessage(fragment, targetVersion));
        this.init(fragment, targetVersion);
    }

    public FragmentMigrationNeededException(IGModelFragment fragment, MetamodelVersionDescriptor targetVersion, String summary) {
        super(summary);
        this.init(fragment, targetVersion);
    }

    private void init(IGModelFragment fragment, MetamodelVersionDescriptor target) {
        this.targetVersion = target;
        this.fragmentId = fragment.getId();
        try {
            this.fragmentVersion = fragment.getRequiredMetamodelDescriptor();
        }
        catch (IOException e) {
            VersionedItem d = new VersionedItem(FileUtils.getLocalizedMessage((IOException)e), null, (Object)e);
            this.fragmentVersion = new MetamodelVersionDescriptor(d);
        }
    }

    public String getFragmentId() {
        return this.fragmentId;
    }

    public MetamodelVersionDescriptor getFragmentVersion() {
        return this.fragmentVersion;
    }

    public MetamodelVersionDescriptor getTargetVersion() {
        return this.targetVersion;
    }

    private static String computeMessage(IGModelFragment fragment, MetamodelVersionDescriptor targetVersion) {
        try {
            MetamodelVersionDescriptor fragmentVersion = fragment.getRequiredMetamodelDescriptor();
            MmVersionComparator comp = MmVersionComparator.withSource((MetamodelVersionDescriptor)fragmentVersion).withTarget(targetVersion).withCommonRemoved();
            return CoreProject.I18N.getMessage("FragmentMigrationNeededException.message", new Object[]{fragment.getId(), comp.getSource(), comp.getTarget()});
        }
        catch (IOException e) {
            return FileUtils.getLocalizedMessage((IOException)e);
        }
    }

    public boolean isRemoteMigrationNeeded() {
        return this.remoteMigrationNeeded;
    }

    public FragmentMigrationNeededException setRemoteMigrationNeeded() {
        this.remoteMigrationNeeded = true;
        return this;
    }
}

