/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject;

import java.io.IOException;
import java.util.Objects;
import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.data.project.GProjectDescriptor;
import org.modelio.gproject.data.project.GProjectPartDescriptor;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vcore.smkernel.AccessDeniedException;

public class GProblem {
    private final String subject;
    private final Throwable cause;

    public String toString() {
        return "GProblem [subject=" + this.subject + ", cause=" + String.valueOf(this.cause) + "]";
    }

    public String getSubject() {
        return this.subject;
    }

    public String getProblem() {
        if (this.cause instanceof IOException) {
            return FileUtils.getLocalizedMessage((IOException)((IOException)this.cause));
        }
        if (this.cause instanceof AccessDeniedException) {
            return this.cause.getLocalizedMessage();
        }
        if (this.cause instanceof RuntimeException) {
            return this.cause.toString();
        }
        return this.cause.getLocalizedMessage();
    }

    public Throwable getCause() {
        return this.cause;
    }

    public GProblem(String subject, Throwable cause) {
        this.subject = subject;
        this.cause = cause;
    }

    public GProblem(IGPart part, Throwable cause) {
        this(String.format("[%s: %s v%s]", part.getType().name(), part.getId(), Objects.toString(part.getVersion())), cause);
    }

    public GProblem(GProjectPartDescriptor d, Throwable cause) {
        this(String.format("[%s: %s v%s]", d.getType().name(), d.getId(), Objects.toString(d.getVersion())), cause);
    }

    public GProblem(GProjectDescriptor d, Throwable cause) {
        this(String.format("[Project: %s %s]", d.getName(), Objects.toString(d.getRemoteLocation())), cause);
    }
}

