/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.modelio.gproject.data.project.GProjectDescriptor;
import org.modelio.gproject.data.project.GProjectDescriptorWriter;
import org.modelio.gproject.data.project.ProjectFileStructure;
import org.modelio.vbasic.version.Version;
import org.modelio.version.ModelioVersion;

public class GProjectCreator {
    public static GProjectDescriptor buildEmptyProject(String projectName, Path projectPath) throws IOException {
        return GProjectCreator.buildEmptyProject(projectName, projectPath, ModelioVersion.VERSION);
    }

    public static GProjectDescriptor buildEmptyProject(String projectName, Path projectPath, Version modelioVersion) throws IOException {
        Files.createDirectories(projectPath, new FileAttribute[0]);
        Path confFilePath = new ProjectFileStructure(projectPath).getProjectConfFile();
        if (Files.isRegularFile(confFilePath, new LinkOption[0])) {
            throw new FileAlreadyExistsException(confFilePath.toString(), null, "A project already exists here.");
        }
        GProjectDescriptor desc = GProjectDescriptor.createEmpty((String)projectName, (Path)projectPath, (Version)modelioVersion);
        new GProjectDescriptorWriter().write(desc);
        return desc;
    }
}

