/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.auth;

import java.util.Map;
import java.util.Objects;
import org.modelio.gproject.data.project.auth.AuthDescriptor;
import org.modelio.vbasic.auth.IAuthData;

public abstract class AuthReconfigurer {
    private static boolean isToReplace(IAuthData old, IAuthData newData) {
        if (old == null) {
            return newData != null;
        }
        if (newData == null) {
            return true;
        }
        Map oldProp = old.getData();
        if (!old.getSchemeId().equals(newData.getSchemeId())) {
            return true;
        }
        for (Map.Entry prop : newData.getData().entrySet()) {
            if (Objects.equals(oldProp.get(prop.getKey()), prop.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean reconfigure(AuthDescriptor current, AuthDescriptor remote) {
        if (remote == null) {
            return false;
        }
        if (!remote.isDefined() && remote.getScope() == current.getScope()) {
            return false;
        }
        IAuthData newData = remote.getData();
        IAuthData oldData = current.getData();
        if (oldData == null) {
            current.setData(newData);
            current.setScope(remote.getScope());
            return true;
        }
        if (AuthReconfigurer.isToReplace(oldData, newData)) {
            current.setData(newData);
            current.setScope(remote.getScope());
            return true;
        }
        current.setScope(remote.getScope());
        return false;
    }
}

