/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.modelio.gproject.catalog.FileModuleStoreHandle;
import org.modelio.gproject.catalog.ModuleXmlExtractor;
import org.modelio.gproject.module.IModuleHandle;
import org.modelio.gproject.module.IModuleStore;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.files.Unzipper;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.model.spi.IGMetamodelExtension;

public class FileModuleStore
implements IModuleStore {
    private static final int VERSION = 4;
    protected FileModuleStoreState state = FileModuleStoreState.INITIAL;
    protected Path storePath;
    protected final Map<String, FileModuleStoreEntry> entries;
    protected final Collection<IGMetamodelExtension> metamodelExtensions;

    public FileModuleStore(Collection<IGMetamodelExtension> metamodelFragments, Path cachePath) {
        this.metamodelExtensions = metamodelFragments;
        this.storePath = cachePath;
        if (!Files.isDirectory(cachePath, new LinkOption[0])) {
            try {
                Files.createDirectories(cachePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.entries = new HashMap<String, FileModuleStoreEntry>();
        this.state = FileModuleStoreState.INITIAL;
        this.migration();
    }

    @Override
    public List<IModuleHandle> findAllModules(IModelioProgress monitor) throws IOException {
        if (this.state == FileModuleStoreState.INITIAL) {
            this.load(monitor);
        }
        ArrayList<IModuleHandle> ret = new ArrayList<IModuleHandle>();
        for (FileModuleStoreEntry entry : this.entries.values()) {
            ret.add(entry.getModuleHandle(monitor));
        }
        return ret;
    }

    @Override
    public IModuleHandle findModule(String moduleName, String moduleVersion, IModelioProgress monitor) throws IOException {
        String key;
        if (moduleVersion == null) {
            IModuleHandle guessed = this.findLatest(moduleName);
            if (guessed != null) {
                return this.findModule(guessed.getName(), guessed.getVersion().toString(), monitor);
            }
            return null;
        }
        if (this.state == FileModuleStoreState.INITIAL) {
            this.load(monitor);
        }
        return this.entries.get(key = this.getEntryKey(moduleName, moduleVersion)) != null ? this.entries.get(key).getModuleHandle(monitor) : null;
    }

    @Override
    public List<IModuleHandle> findModule(String moduleName, IModelioProgress monitor) throws FileSystemException, IOException {
        ArrayList<IModuleHandle> results = new ArrayList<IModuleHandle>();
        for (IModuleHandle mh : this.findAllModules(monitor)) {
            if (!Objects.equals(mh.getName(), moduleName)) continue;
            results.add(mh);
        }
        return results;
    }

    @Override
    public IModuleHandle findModule(Path archive, IModelioProgress monitor) throws IOException, FileSystemException {
        IModuleHandle moduleHandle = null;
        if (Files.notExists(archive, new LinkOption[0])) {
            return null;
        }
        SubProgress m = SubProgress.convert((IModelioProgress)monitor, (int)100);
        Path extractionDir = Files.createTempDirectory("temp", new FileAttribute[0]);
        new Unzipper().setProgressLabelPrefix(CoreProject.I18N.getMessage("FileModuleStore.unzippingJMdac", new Object[]{archive.getFileName()})).unzip(archive, extractionDir, (IModelioProgress)m.newChild(60));
        IModuleHandle tempModuleHandle = new FileModuleStoreEntry(extractionDir, this.metamodelExtensions).getModuleHandle((IModelioProgress)m);
        moduleHandle = this.findModule(tempModuleHandle.getName(), tempModuleHandle.getVersion().toString(), monitor);
        FileUtils.delete((Path)extractionDir);
        m.setWorkRemaining(40);
        return moduleHandle;
    }

    protected final Path getCachePath() {
        return this.storePath;
    }

    protected final Collection<IGMetamodelExtension> getMetamodelExtensions() {
        return this.metamodelExtensions;
    }

    @Override
    public IModuleHandle installModuleArchive(Path archive, IModelioProgress monitor) throws IOException {
        if (Files.notExists(archive, new LinkOption[0])) {
            return null;
        }
        SubProgress m = SubProgress.convert((IModelioProgress)monitor, (int)100);
        Path extractionDir = Files.createTempDirectory("temp", new FileAttribute[0]);
        new Unzipper().setProgressLabelPrefix(CoreProject.I18N.getMessage("FileModuleStore.unzippingJMdac", new Object[]{archive.getFileName()})).unzip(archive, extractionDir, (IModelioProgress)m.newChild(60));
        FileModuleStoreEntry tempEntry = new FileModuleStoreEntry(extractionDir, this.metamodelExtensions);
        IModuleHandle tempHandle = tempEntry.getModuleHandle((IModelioProgress)m.newChild(40, 7));
        Path moduleStorePath = this.computeNewModuleStorePath(tempHandle);
        if (!Files.isDirectory(moduleStorePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(moduleStorePath.getParent(), new FileAttribute[0]);
        }
        if (Files.exists(moduleStorePath, new LinkOption[0])) {
            FileUtils.delete((Path)moduleStorePath);
        }
        FileUtils.move((Path)extractionDir, (Path)moduleStorePath);
        String moduleArchiveName = this.computeModuleArchiveName(tempHandle);
        Files.copy(archive, moduleStorePath.resolve(moduleArchiveName), new CopyOption[0]);
        FileModuleStoreEntry entry = new FileModuleStoreEntry(moduleStorePath, this.metamodelExtensions, tempHandle);
        String key = this.getEntryKey(tempHandle.getName(), tempHandle.getVersion().toString());
        if (this.state == FileModuleStoreState.VALID) {
            this.entries.put(key, entry);
        }
        return entry.getModuleHandle((IModelioProgress)m.newChild(20));
    }

    @Override
    public void removeModule(IModuleHandle mh) throws IOException, FileSystemException {
        if (mh instanceof FileModuleStoreHandle) {
            if (this.state == FileModuleStoreState.VALID) {
                String key = this.getEntryKey(mh.getName(), mh.getVersion().toString());
                this.entries.remove(key);
            }
            Path path = ((FileModuleStoreHandle)mh).getModuleCachePath();
            Path path1 = path.getParent();
            FileUtils.delete((Path)path1);
        }
    }

    public final void setCachePath(Path cachePath) {
        this.storePath = cachePath;
    }

    protected String computeModuleArchiveName(IModuleHandle moduleHandle) {
        return moduleHandle.getName() + "_" + moduleHandle.getVersion().toString("V.R.C") + ".jmdac";
    }

    protected Path computeModuleCachePath(String moduleName, String moduleVersion) {
        return this.storePath.resolve(moduleName + "_" + moduleVersion);
    }

    protected Path computeNewModuleStorePath(IModuleHandle moduleHandle) {
        return this.computeModuleCachePath(moduleHandle.getName(), moduleHandle.getVersion().toString("V.R.C"));
    }

    protected FileSystem createZipFileSystem(Path zipPath, boolean create) throws IOException {
        URI uri = URI.create("jar:file:" + zipPath.toUri().getPath());
        HashMap<String, String> env = new HashMap<String, String>();
        if (create) {
            env.put("create", "true");
        }
        return FileSystems.newFileSystem(uri, env);
    }

    protected final String getEntryKey(String moduleName, String moduleVersion) {
        return moduleName + moduleVersion;
    }

    protected boolean isFileModuleStoreEntry(Path moduleCachePath) {
        if (!Files.exists(moduleCachePath, new LinkOption[0])) {
            return false;
        }
        return Files.isDirectory(moduleCachePath, new LinkOption[0]);
    }

    protected void migration() {
        boolean isMigrationNeeded;
        int version;
        if (!Files.isDirectory(this.storePath, new LinkOption[0])) {
            return;
        }
        Path confFile = this.getConfigFile();
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream is = Files.newInputStream(confFile, new OpenOption[0]);){
                props.load(is);
                version = Integer.valueOf(props.getProperty("version", "0"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NumberFormatException | NoSuchFileException exception) {
            version = 0;
        }
        catch (IOException e) {
            Log.warning((Throwable)e);
            version = 0;
        }
        boolean bl = isMigrationNeeded = version < this.getRequiredConfVersion();
        if (isMigrationNeeded) {
            try {
                Log.trace((String)("'" + String.valueOf(this.storePath) + "' module catalog version is " + version + " instead of " + this.getRequiredConfVersion() + ", cleaning the catalog..."));
                Path tmpDir = Files.createTempDirectory("ModuleCatalog", new FileAttribute[0]);
                FileUtils.move((Path)this.storePath, (Path)tmpDir);
                FileUtils.delete((Path)tmpDir);
                Files.createDirectories(this.storePath, new FileAttribute[0]);
                props.setProperty("version", String.valueOf(this.getRequiredConfVersion()));
                Throwable throwable = null;
                Object var7_14 = null;
                try (OutputStream out = Files.newOutputStream(confFile, new OpenOption[0]);){
                    props.store(out, "Module catalog");
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                Log.trace((String)("'" + String.valueOf(this.storePath) + "' module catalog cleaning done"));
            }
            catch (FileSystemException e) {
                Log.warning((String)("Cannot migrate '" + String.valueOf(this.storePath) + "' module catalog from " + version + " to " + this.getRequiredConfVersion()));
                Log.warning((String)FileUtils.getLocalizedMessage((IOException)e));
                Log.warning((Throwable)e);
            }
            catch (IOException e) {
                Log.warning((String)("Cannot migrate '" + String.valueOf(this.storePath) + "' module catalog from " + version + " to " + this.getRequiredConfVersion()));
                Log.warning((Throwable)e);
            }
        }
    }

    protected IModuleHandle findLatest(String moduleName) throws FileSystemException, IOException {
        IModuleHandle candidate = null;
        for (IModuleHandle mh : this.findModule(moduleName, null)) {
            if (candidate != null && !candidate.getVersion().isOlderThan(mh.getVersion())) continue;
            candidate = mh;
        }
        return candidate;
    }

    protected int getRequiredConfVersion() {
        return 4;
    }

    protected Path getConfigFile() {
        return this.storePath.resolve("version.dat");
    }

    protected void load(IModelioProgress monitor) {
        this.entries.clear();
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path file) throws IOException {
                return Files.isDirectory(file, new LinkOption[0]);
            }
        };
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.storePath, (DirectoryStream.Filter<? super Path>)filter);){
                for (Path p : stream) {
                    try {
                        FileModuleStoreEntry entry = new FileModuleStoreEntry(p.toAbsolutePath(), this.metamodelExtensions);
                        IModuleHandle mh = entry.getModuleHandle(monitor);
                        String key = this.getEntryKey(mh.getName(), mh.getVersion().toString());
                        this.entries.put(key, entry);
                    }
                    catch (IOException e) {
                        Log.warning((Throwable)e);
                    }
                }
                this.state = FileModuleStoreState.VALID;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Log.warning((Throwable)e);
            this.state = FileModuleStoreState.INITIAL;
        }
    }

    protected static final class FileModuleStoreEntry {
        private final Path entryPath;
        private final Path datapath;
        private final Collection<IGMetamodelExtension> metamodelExtensions;
        private IModuleHandle moduleHandle;

        public FileModuleStoreEntry(Path entryPath, Collection<IGMetamodelExtension> metamodelFragments) throws IOException {
            this.entryPath = entryPath;
            this.datapath = this.getModuleContentsPath(entryPath);
            this.metamodelExtensions = metamodelFragments;
        }

        private FileModuleStoreEntry(Path entryPath, Collection<IGMetamodelExtension> metamodelFragments, IModuleHandle refHandle) throws IOException {
            this.entryPath = entryPath;
            this.datapath = this.getModuleContentsPath(entryPath);
            this.metamodelExtensions = metamodelFragments;
            this.moduleHandle = new FileModuleStoreHandle(this.datapath, refHandle.getName(), refHandle.getVersion(), refHandle.getUid(), refHandle.getMainClassName(), refHandle.getBinaryVersion(), refHandle.getDependencies(), refHandle.getWeakDependencies(), refHandle.getDocPaths(), refHandle.getJarPaths(), refHandle.getStylePaths(), refHandle.getMetamodelFragments());
        }

        public IModuleHandle getModuleHandle(IModelioProgress monitor) throws IOException {
            if (this.moduleHandle == null) {
                this.moduleHandle = new ModuleXmlExtractor(this.datapath.resolve("module.xml"), this.datapath, this.metamodelExtensions).getModuleHandle(monitor);
            }
            return this.moduleHandle;
        }

        private Path getModuleContentsPath(Path aPath) throws IOException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(aPath);){
                for (Path p : stream) {
                    if (!Files.isDirectory(p, new LinkOption[0])) continue;
                    return p;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throw new NoSuchFileException(aPath.toString(), null, CoreProject.I18N.getMessage("FileModuleStoreEntry.doesNotContainDirectory", new Object[]{aPath}));
        }

        private void normalizeEntryContents(IModelioProgress monitor) throws IOException {
            new ModuleXmlExtractor(this.datapath.resolve("module.xml"), this.datapath, this.metamodelExtensions).extractModuleXmlContent(monitor);
        }
    }

    protected static enum FileModuleStoreState {
        INITIAL,
        VALID;

    }
}

