/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.catalog;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.modelio.gproject.module.IMetamodelFragmentHandle;
import org.modelio.gproject.module.IModuleHandle;
import org.modelio.vbasic.version.Version;
import org.modelio.vbasic.version.VersionedItem;

public class FileModuleStoreHandle
implements IModuleHandle,
Comparable<Object> {
    private final String name;
    private final String uid;
    private final String mainClassName;
    private final Path moduleCachePath;
    private final List<Path> docPaths;
    private final List<Path> jarPaths;
    private final Map<String, Path> stylePaths;
    private final Version version;
    private final Version binaryVersion;
    private final List<VersionedItem<?>> dependencies;
    private final List<VersionedItem<?>> weakDependencies;
    private final List<IMetamodelFragmentHandle> metamodelFragments;

    FileModuleStoreHandle(Path moduleCachePath, String name, Version version, String uid, String mainClassName, Version binaryVersion, List<VersionedItem<?>> dependencies, List<VersionedItem<?>> weakDependencies, List<Path> docPaths, List<Path> jarPaths, Map<String, Path> stylePaths, List<IMetamodelFragmentHandle> metamodelFragments) {
        this.moduleCachePath = moduleCachePath;
        this.name = name;
        this.version = version;
        this.uid = uid;
        this.mainClassName = mainClassName;
        this.binaryVersion = binaryVersion;
        this.dependencies = dependencies;
        this.weakDependencies = weakDependencies;
        this.docPaths = docPaths;
        this.jarPaths = jarPaths;
        this.stylePaths = stylePaths;
        this.metamodelFragments = metamodelFragments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Path getModuleInfosPath() {
        return this.moduleCachePath.resolve("moduleInfos.xml");
    }

    @Override
    public Path getModelComponentPath() {
        return this.moduleCachePath.resolve("staticModel.ramc");
    }

    @Override
    public Path getDynamicModelPath() {
        return this.moduleCachePath.resolve("dynamicModel.xml");
    }

    @Override
    public Path getResourcePath() {
        return this.moduleCachePath;
    }

    @Override
    public List<Path> getJarPaths() {
        return this.jarPaths;
    }

    @Override
    public List<Path> getDocPaths() {
        return this.docPaths;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getMainClassName() {
        return this.mainClassName;
    }

    @Override
    public Version getBinaryVersion() {
        return this.binaryVersion;
    }

    @Override
    public List<VersionedItem<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<VersionedItem<?>> getWeakDependencies() {
        return this.weakDependencies;
    }

    @Override
    public Path getArchive() {
        int buildVersion = this.version.getBuildVersion();
        String archiveName = this.name + "_" + this.version.getMajorVersion() + "." + this.version.getMinorVersion() + "." + String.valueOf(buildVersion < 10 ? "0" + buildVersion : Integer.valueOf(buildVersion)) + ".jmdac";
        return this.moduleCachePath.getParent().resolve(archiveName);
    }

    public Path getModuleCachePath() {
        return this.moduleCachePath;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + " v" + String.valueOf(this.getVersion()) + " @" + String.valueOf(this.getModuleCachePath()) + ")";
    }

    @Override
    public int compareTo(Object obj) {
        if (obj instanceof String) {
            return this.name.toString().compareTo((String)obj);
        }
        if (obj instanceof FileModuleStoreHandle) {
            return this.version.toString().compareTo(((FileModuleStoreHandle)obj).version.toString());
        }
        return 0;
    }

    @Override
    public Map<String, Path> getStylePaths() {
        return this.stylePaths;
    }

    @Override
    public List<IMetamodelFragmentHandle> getMetamodelFragments() {
        return this.metamodelFragments;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.moduleCachePath == null ? 0 : this.moduleCachePath.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileModuleStoreHandle other = (FileModuleStoreHandle)obj;
        if (this.moduleCachePath == null ? other.moduleCachePath != null : !this.moduleCachePath.equals(other.moduleCachePath)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals((Object)other.version));
    }
}

