/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.modelio.gproject.catalog.FileModuleStoreHandle;
import org.modelio.gproject.catalog.MetamodelFragmentHandle;
import org.modelio.gproject.data.module.JaxbModelPersistence;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2Module;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2MultiPathes;
import org.modelio.gproject.module.IMetamodelFragmentHandle;
import org.modelio.gproject.module.IModuleHandle;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.gproject.ramc.RamcBuilder;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vbasic.version.Version;
import org.modelio.vbasic.version.VersionedItem;
import org.modelio.vcore.model.spi.IGMetamodelExtension;

public class ModuleXmlExtractor {
    private final Path moduleXmlPath;
    private final Path targetPath;
    private final Collection<IGMetamodelExtension> metamodelExtensions;

    public ModuleXmlExtractor(Path moduleXmlPath, Path targetPath, Collection<IGMetamodelExtension> metamodelFragments) {
        this.moduleXmlPath = moduleXmlPath;
        this.targetPath = targetPath;
        this.metamodelExtensions = metamodelFragments;
    }

    private void extractStaticModel(Path moduleStaticModelPath, Jxbv2Module loadedModule, IModelioProgress monitor) throws IOException {
        try {
            new RamcBuilder(this.metamodelExtensions, loadedModule).createRamc(moduleStaticModelPath, monitor);
        }
        catch (IOException e) {
            throw new IOException(CoreProject.I18N.getMessage("ModuleCacheManager.FailedExtractStaticModel", new Object[]{moduleStaticModelPath.getFileName(), FileUtils.getLocalizedMessage((IOException)e)}), e);
        }
    }

    private void extractModuleInfos(Jxbv2Module loadedModule, Path infosPath) throws IOException {
        Jxbv2Module infosModel = new Jxbv2Module();
        infosModel.setAuthor(loadedModule.getAuthor());
        infosModel.setBinaryversion(loadedModule.getBinaryversion());
        infosModel.setClazz(loadedModule.getClazz());
        infosModel.setDependencies(loadedModule.getDependencies());
        infosModel.setClassPath(loadedModule.getClassPath());
        infosModel.setMetamodelFragments(loadedModule.getMetamodelFragments());
        infosModel.setResources(new Jxbv2Module.Jxbv2Resources());
        Jxbv2Module.Jxbv2Resources moduleResources = loadedModule.getResources();
        if (moduleResources != null) {
            Jxbv2Module.Jxbv2Resources infoModelResources = infosModel.getResources();
            infoModelResources.setDocFiles(moduleResources.getDocFiles());
            infoModelResources.setDocTemplates(moduleResources.getDocTemplates());
            infoModelResources.setStyles(moduleResources.getStyles());
            infoModelResources.setMacros(moduleResources.getMacros());
            infoModelResources.setPatterns(moduleResources.getPatterns());
        }
        infosModel.setId(loadedModule.getId());
        infosModel.setImage(loadedModule.getImage());
        infosModel.setSchemaLevel(Long.valueOf(loadedModule.getSchemaLevel()));
        infosModel.setUid(loadedModule.getUid());
        infosModel.setVersion(loadedModule.getVersion());
        infosModel.setParameters(null);
        infosModel.setPropertyTypes(null);
        infosModel.setProfiles(null);
        JaxbModelPersistence.saveJaxbModel((Jxbv2Module)infosModel, (Path)infosPath);
    }

    public void extractMdaRamc(InputStream moduleXmlInput, Path ramcPath) throws IOException {
        Jxbv2Module loadedModule = JaxbModelPersistence.loadJaxbModel((InputStream)moduleXmlInput);
        this.extractStaticModel(ramcPath, loadedModule, null);
    }

    public void extractModuleXmlContent(IModelioProgress monitor) throws IOException {
        try {
            if (!Files.exists(this.moduleXmlPath, new LinkOption[0])) {
                throw new IOException(CoreProject.I18N.getMessage("ModuleCacheManager.NoModuleFound", new Object[]{this.moduleXmlPath}));
            }
            SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)3);
            Jxbv2Module loadedModule = null;
            Path staticModelPath = this.getStaticModelRamcPath();
            if (this.isToRewrite(staticModelPath)) {
                loadedModule = JaxbModelPersistence.loadJaxbModel((Path)this.moduleXmlPath);
                this.extractStaticModel(staticModelPath, loadedModule, (IModelioProgress)mon.newChild(1));
            }
            mon.setWorkRemaining(2);
            Path dynamicModelPath = this.getDynamicModelPath();
            if (this.isToRewrite(dynamicModelPath)) {
                if (loadedModule == null) {
                    loadedModule = JaxbModelPersistence.loadJaxbModel((Path)this.moduleXmlPath);
                }
                this.extractDynamicModel(dynamicModelPath, loadedModule, (IModelioProgress)mon.newChild(1));
            }
            mon.setWorkRemaining(1);
            Path infosPath = this.getModuleInfosPath();
            if (this.isToRewrite(infosPath)) {
                if (loadedModule == null) {
                    loadedModule = JaxbModelPersistence.loadJaxbModel((Path)this.moduleXmlPath);
                }
                this.extractModuleInfos(loadedModule, infosPath);
            }
        }
        catch (IOException e) {
            IOException e2 = new IOException(CoreProject.I18N.getMessage("ModuleCacheManager.ErrorReadingModule", new Object[]{this.moduleXmlPath, FileUtils.getLocalizedMessage((IOException)e)}));
            e2.initCause(e);
            throw e2;
        }
    }

    private void extractDynamicModel(Path moduleDynamicModelPath, Jxbv2Module loadedModule, IModelioProgress monitor) throws IOException {
        Jxbv2Module dynamicModel = new Jxbv2Module();
        dynamicModel.setAuthor(loadedModule.getAuthor());
        dynamicModel.setBinaryversion(loadedModule.getBinaryversion());
        dynamicModel.setClassPath(loadedModule.getClassPath());
        dynamicModel.setClazz(loadedModule.getClazz());
        dynamicModel.setDependencies(loadedModule.getDependencies());
        dynamicModel.setGui(loadedModule.getGui());
        dynamicModel.setId(loadedModule.getId());
        dynamicModel.setImage(loadedModule.getImage());
        dynamicModel.setParameters(loadedModule.getParameters());
        dynamicModel.setSchemaLevel(Long.valueOf(loadedModule.getSchemaLevel()));
        dynamicModel.setUid(loadedModule.getUid());
        dynamicModel.setVersion(loadedModule.getVersion());
        dynamicModel.setResources(new Jxbv2Module.Jxbv2Resources());
        dynamicModel.setProfiles(null);
        dynamicModel.setPropertyTypes(null);
        dynamicModel.setMetamodelFragments(null);
        JaxbModelPersistence.saveJaxbModel((Jxbv2Module)dynamicModel, (Path)moduleDynamicModelPath);
        monitor.done();
    }

    public IModuleHandle getModuleHandle(IModelioProgress monitor) throws IOException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)2);
        this.extractModuleXmlContent((IModelioProgress)mon.newChild(1));
        mon.setWorkRemaining(1);
        return new HandleFactory().getModuleHandle((IModelioProgress)mon.newChild(1), this.targetPath);
    }

    public Path getModuleInfosPath() {
        return this.targetPath.resolve("moduleInfos.xml");
    }

    public Path getDynamicModelPath() {
        return this.targetPath.resolve("dynamicModel.xml");
    }

    public Path getStaticModelRamcPath() {
        return this.targetPath.resolve("staticModel.ramc");
    }

    private boolean isToRewrite(Path file) throws IOException {
        if (Files.notExists(file, new LinkOption[0])) {
            return true;
        }
        FileTime fileDate = Files.getLastModifiedTime(file, new LinkOption[0]);
        FileTime moduleXmlTime = Files.getLastModifiedTime(this.moduleXmlPath, new LinkOption[0]);
        return moduleXmlTime.compareTo(fileDate) > 0;
    }

    private static class HandleFactory {
        private HandleFactory() {
        }

        public IModuleHandle getModuleHandle(IModelioProgress monitor, Path moduleCachePath) throws IOException {
            SubProgress m = SubProgress.convert((IModelioProgress)monitor, (int)3);
            try {
                Path infosPath = moduleCachePath.resolve("moduleInfos.xml");
                Jxbv2Module moduleFromInfos = JaxbModelPersistence.loadJaxbModel((Path)infosPath);
                m.worked(1);
                return this.loadModuleInfos(moduleCachePath, moduleFromInfos, (IModelioProgress)m.newChild(2));
            }
            catch (IOException e) {
                IOException e2 = new IOException(CoreProject.I18N.getMessage("ModuleCacheManager.ErrorReadingModule", new Object[]{moduleCachePath, FileUtils.getLocalizedMessage((IOException)e)}), e);
                throw e2;
            }
        }

        private FileModuleStoreHandle loadModuleInfos(Path moduleCachePath, Jxbv2Module loadedModule, IModelioProgress monitor) throws IOException {
            Jxbv2MultiPathes classPath;
            String uid = loadedModule.getUid();
            String name = loadedModule.getId();
            String mainClassName = loadedModule.getClazz();
            String moduleVersionString = loadedModule.getVersion();
            Version moduleVersion = moduleVersionString != null ? new Version(moduleVersionString) : new Version(0, 0, 0);
            String binaryVersionString = loadedModule.getBinaryversion();
            Version binaryVersion = binaryVersionString != null ? new Version(binaryVersionString) : new Version(0, 0, 0);
            ArrayList dependencies = new ArrayList();
            ArrayList weakDependencies = new ArrayList();
            ArrayList<Path> jarPaths = new ArrayList<Path>();
            ArrayList<Path> docPaths = new ArrayList<Path>();
            HashMap<String, Path> stylePaths = new HashMap<String, Path>();
            ArrayList<IMetamodelFragmentHandle> metamodelFragments = new ArrayList<IMetamodelFragmentHandle>();
            if (loadedModule.getDependencies() != null) {
                for (Jxbv2Module.Jxbv2Dependencies.Jxbv2Required dep : loadedModule.getDependencies().getRequired()) {
                    dependencies.add(new VersionedItem(dep.getName(), new Version(dep.getVersion())));
                }
                for (Jxbv2Module.Jxbv2Dependencies.Jxbv2Required dep : loadedModule.getDependencies().getOptional()) {
                    weakDependencies.add(new VersionedItem(dep.getName(), new Version(dep.getVersion())));
                }
            }
            if ((classPath = loadedModule.getClassPath()) != null) {
                for (Jxbv2MultiPathes.Jxbv2PathEntry pathEntry : classPath.getPathEntry()) {
                    jarPaths.add(Paths.get(pathEntry.getPath(), new String[0]));
                }
            }
            if (loadedModule.getResources() != null && loadedModule.getResources().getDocFiles() != null) {
                for (Jxbv2MultiPathes.Jxbv2PathEntry pathEntry : loadedModule.getResources().getDocFiles().getPathEntry()) {
                    docPaths.add(Paths.get(pathEntry.getPath(), new String[0]));
                }
            }
            if (loadedModule.getResources() != null && loadedModule.getResources().getStyles() != null) {
                for (Jxbv2MultiPathes.Jxbv2PathEntry pathEntry : loadedModule.getResources().getStyles().getStyle()) {
                    stylePaths.put(pathEntry.getId(), Paths.get(pathEntry.getPath(), new String[0]));
                }
            }
            if (loadedModule.getMetamodelFragments() != null) {
                for (Jxbv2Module.Jxbv2MetamodelFragments.Jxbv2MetamodelFragment fragEntry : loadedModule.getMetamodelFragments().getMetamodelFragment()) {
                    MetamodelFragmentHandle f = new MetamodelFragmentHandle(fragEntry.getId(), this.readVersion(fragEntry), fragEntry.getVendor(), fragEntry.getVendorVersion(), fragEntry.getClazz());
                    metamodelFragments.add(f);
                }
            }
            monitor.done();
            return new FileModuleStoreHandle(moduleCachePath, name, moduleVersion, uid, mainClassName, binaryVersion, dependencies, weakDependencies, docPaths, jarPaths, stylePaths, metamodelFragments);
        }

        private Version readVersion(Jxbv2Module.Jxbv2MetamodelFragments.Jxbv2MetamodelFragment fragEntry) throws IOException {
            try {
                return new Version(fragEntry.getVersion());
            }
            catch (NumberFormatException e) {
                String msg = CoreProject.I18N.getMessage("ModuleCacheManager.InvalidMmFragmentVersion", new Object[]{fragEntry.getId(), fragEntry.getVersion(), e.getLocalizedMessage()});
                throw new IOException(msg, e);
            }
        }
    }
}

