/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.copy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.modelio.gproject.importer.core.IDependencyUpdater;
import org.modelio.gproject.importer.core.IObjectFinder;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MDependency;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.meta.SmDependency;

class ReferenceDependencyCopier
implements IDependencyUpdater {
    private final ICoreSession localSession;
    private final IObjectFinder objectFinder;

    public ReferenceDependencyCopier(ICoreSession localSession, IObjectFinder objectFinder) {
        this.localSession = localSession;
        this.objectFinder = objectFinder;
    }

    @Override
    public List<SmObjectImpl> execute(SmObjectImpl refObject, SmDependency smDep, SmObjectImpl localObject) {
        SmDependency localDep = this.objectFinder.getSameDependency(smDep);
        if (localDep != null) {
            List refValues = refObject.mGet((MDependency)smDep);
            List<SmObjectImpl> equivalentLocalValues = this.getEquivalentLocalValues(refValues);
            this.updateDependency(localObject, localDep, equivalentLocalValues);
        }
        return Collections.emptyList();
    }

    protected void updateDependency(SmObjectImpl localObject, SmDependency localDep, List<SmObjectImpl> equivalentLocalValues) {
        for (SmObjectImpl obj : equivalentLocalValues) {
            localObject.appendDepVal(localDep, obj);
        }
    }

    private List<SmObjectImpl> getEquivalentLocalValues(List<MObject> refValues) {
        ArrayList<SmObjectImpl> equivalentLocalValues = new ArrayList<SmObjectImpl>(refValues.size());
        for (MObject refDepVal : refValues) {
            SmObjectImpl sameObj;
            if (refDepVal == null || (sameObj = this.objectFinder.getSameObject((SmObjectImpl)refDepVal)) == null || sameObj.isDeleted()) continue;
            equivalentLocalValues.add(sameObj);
        }
        return equivalentLocalValues;
    }
}

