/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.env;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.modelio.gproject.env.IGProjectEnv;
import org.modelio.gproject.module.IModuleRTCache;
import org.modelio.vcore.model.spi.IGMetamodelExtension;

public class GProjectEnvironment
implements IGProjectEnv {
    private IModuleRTCache modulesCache;
    private final Collection<IGMetamodelExtension> defaultMetamodelExtensions = new ArrayList<IGMetamodelExtension>();
    private Path ramcCachePath;

    public GProjectEnvironment setModulesCache(IModuleRTCache modulesCatalog) {
        this.modulesCache = modulesCatalog;
        return this;
    }

    public GProjectEnvironment addMetamodelExtension(IGMetamodelExtension metamodelExtension) {
        this.defaultMetamodelExtensions.add(metamodelExtension);
        return this;
    }

    @Override
    public IModuleRTCache getModulesCache() {
        return this.modulesCache;
    }

    @Override
    public Collection<IGMetamodelExtension> getDefaultMetamodelExtensions() {
        return this.defaultMetamodelExtensions;
    }

    public GProjectEnvironment addMetamodelExtensions(Collection<IGMetamodelExtension> metamodelExtensions) {
        this.defaultMetamodelExtensions.addAll(metamodelExtensions);
        return this;
    }

    public GProjectEnvironment setRamcCache(Path ramcCachePath) {
        this.ramcCachePath = ramcCachePath;
        return this;
    }

    @Override
    public Path getRamcCache() {
        return this.ramcCachePath;
    }
}

