/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.importer.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.modelio.gproject.importer.core.IImportReport;
import org.modelio.metamodel.mmextensions.standard.facilities.BrokenElementTester;
import org.modelio.metamodel.uml.infrastructure.AbstractProject;
import org.modelio.vcore.model.api.MTools;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.meta.SmDependency;

public abstract class AbstractImporter {
    protected Result result;

    public final IImportReport execute(ICoreSession localSession, SmObjectImpl localRoot, ICoreSession refSession, List<SmObjectImpl> refRoots) {
        this.result = new Result();
        this.prepare(localSession, localRoot, refSession, refRoots);
        this.importElements(localSession, localRoot, refSession, refRoots);
        this.importDependencies();
        this.fixRoots(localSession, localRoot, refRoots);
        this.fixElements(localSession, refSession);
        this.collectGarbage(localSession);
        this.deleteGarbage();
        return new ImportReport(this.result);
    }

    public final IImportReport execute(ICoreSession localSession, List<SmObjectImpl> localRootList, ICoreSession refSession, List<List<SmObjectImpl>> refRootsList) {
        if (localRootList.size() != refRootsList.size()) {
            throw new IllegalArgumentException(localRootList.size() + " local roots but " + refRootsList.size() + " reference roots.");
        }
        this.result = new Result();
        ArrayList<SmObjectImpl> mergedRefRoots = new ArrayList<SmObjectImpl>();
        for (List<SmObjectImpl> refList : refRootsList) {
            mergedRefRoots.addAll(refList);
        }
        this.prepare(localSession, localRootList.get(0), refSession, mergedRefRoots);
        this.importElements(localSession, localRootList.get(0), refSession, mergedRefRoots);
        this.importDependencies();
        int i = 0;
        while (i < localRootList.size()) {
            SmObjectImpl localRoot = localRootList.get(i);
            List<SmObjectImpl> refRoots = refRootsList.get(i);
            this.fixRoots(localSession, localRoot, refRoots);
            ++i;
        }
        this.fixElements(localSession, refSession);
        this.collectGarbage(localSession);
        this.deleteGarbage();
        return new ImportReport(this.result);
    }

    public static boolean isRoot(SmObjectImpl obj, ICoreSession localSession) {
        IRepository f = localSession.getRepositorySupport().getRepository((MObject)obj);
        if (f != null) {
            return MTools.get((ICoreSession)localSession).getRootGetter().getRootElements(f).contains(obj);
        }
        return obj instanceof AbstractProject;
    }

    protected final void collectGarbage(ICoreSession localSession) {
        BrokenElementTester tester = new BrokenElementTester();
        for (SmObjectImpl localObject : this.result.getGarbage()) {
            if (localObject.getCompositionOwner() != null || AbstractImporter.isRoot(localObject, localSession)) continue;
            this.result.addObjectToDelete(localObject);
        }
        for (SmObjectImpl localObject : this.result.getCreations().values()) {
            if (localObject == null || !localObject.isValid() || !tester.isBroken((MObject)localObject)) continue;
            this.result.addObjectToDelete(localObject);
        }
        for (SmObjectImpl localObject : this.result.getUpdates().values()) {
            if (localObject == null || !localObject.isValid() || !tester.isBroken((MObject)localObject)) continue;
            this.result.addObjectToDelete(localObject);
        }
    }

    protected void deleteGarbage() {
        for (SmObjectImpl localObjectToDelete : this.result.getDeletions()) {
            if (!localObjectToDelete.isValid()) continue;
            localObjectToDelete.delete();
        }
    }

    protected abstract void fixElement(SmObjectImpl var1, SmObjectImpl var2, ICoreSession var3, ICoreSession var4);

    protected final void fixElements(ICoreSession localSession, ICoreSession refSession) {
        SmObjectImpl localObject;
        SmObjectImpl refObject;
        for (Map.Entry<SmObjectImpl, SmObjectImpl> entry : this.result.getCreations().entrySet()) {
            refObject = entry.getKey();
            localObject = entry.getValue();
            if (localObject == null || localObject.isDeleted()) continue;
            this.fixElement(localObject, refObject, localSession, refSession);
        }
        for (Map.Entry<SmObjectImpl, SmObjectImpl> entry : this.result.getUpdates().entrySet()) {
            refObject = entry.getKey();
            localObject = entry.getValue();
            if (localObject == null || localObject.isDeleted()) continue;
            this.fixElement(localObject, refObject, localSession, refSession);
        }
    }

    protected void fixRoots(ICoreSession localSession, SmObjectImpl localRoot, List<SmObjectImpl> refRoots) {
        HashMap<SmObjectImpl, SmDependency> rootOrphans = new HashMap<SmObjectImpl, SmDependency>();
        for (SmObjectImpl refRoot : refRoots) {
            SmObjectImpl localObject = this.result.getObjectCreatedFrom(refRoot);
            if (localObject == null) {
                localObject = this.result.getObjectUpdatedFrom(refRoot);
            }
            if (localObject == null || localObject.getCompositionOwner() != null) continue;
            rootOrphans.put(localObject, refRoot.getCompositionRelation().dep.getSymetric());
        }
        this.reparentElements(rootOrphans, localSession, localRoot);
    }

    protected abstract void importCompositionDependencies(SmObjectImpl var1, SmObjectImpl var2);

    protected final void importDependencies() {
        SmObjectImpl localObject;
        SmObjectImpl refObject;
        for (Map.Entry<SmObjectImpl, SmObjectImpl> entry : this.result.getCreations().entrySet()) {
            refObject = entry.getKey();
            localObject = entry.getValue();
            this.importCompositionDependencies(refObject, localObject);
            this.importReferenceDependencies(refObject, localObject);
        }
        for (Map.Entry<SmObjectImpl, SmObjectImpl> entry : this.result.getUpdates().entrySet()) {
            refObject = entry.getKey();
            localObject = entry.getValue();
            this.importCompositionDependencies(refObject, localObject);
            this.importReferenceDependencies(refObject, localObject);
        }
    }

    protected abstract void importElements(ICoreSession var1, SmObjectImpl var2, ICoreSession var3, List<SmObjectImpl> var4);

    protected abstract void importReferenceDependencies(SmObjectImpl var1, SmObjectImpl var2);

    protected abstract void prepare(ICoreSession var1, SmObjectImpl var2, ICoreSession var3, List<SmObjectImpl> var4);

    protected abstract void reparentElements(Map<SmObjectImpl, SmDependency> var1, ICoreSession var2, SmObjectImpl var3);

    protected static final class ImportReport
    implements IImportReport {
        private final Result result;

        public ImportReport(Result result) {
            this.result = result;
        }

        @Override
        public List<SmObjectImpl> getCreatedObjects() {
            return this.result.getCreatedObjects();
        }

        @Override
        public List<SmObjectImpl> getUpdatedObjects() {
            return this.result.getUpdatedObjects();
        }

        @Override
        public List<SmObjectImpl> getDeletedObjects() {
            return this.result.getDeletions();
        }

        @Override
        public SmObjectImpl getCreatedObject(SmObjectImpl refObject) {
            return this.result.getObjectCreatedFrom(refObject);
        }

        @Override
        public SmObjectImpl getUpdatedObject(SmObjectImpl refObject) {
            return this.result.getObjectUpdatedFrom(refObject);
        }
    }

    protected static class Result {
        protected Map<SmObjectImpl, SmObjectImpl> createdObjects = new HashMap<SmObjectImpl, SmObjectImpl>();
        protected List<SmObjectImpl> objectsToDelete = new ArrayList<SmObjectImpl>();
        protected List<SmObjectImpl> objectsToGarbage = new ArrayList<SmObjectImpl>();
        protected Map<SmObjectImpl, SmObjectImpl> replacedObjects = new HashMap<SmObjectImpl, SmObjectImpl>();

        public void addCreatedObject(SmObjectImpl localObject, SmObjectImpl refObject) {
            this.createdObjects.put(refObject, localObject);
        }

        public void addObjectToDelete(SmObjectImpl localObject) {
            this.objectsToDelete.add(localObject);
        }

        public void addObjectToGarbage(SmObjectImpl localObject) {
            this.objectsToGarbage.add(localObject);
        }

        public void addUpdatedObject(SmObjectImpl localObject, SmObjectImpl refObject) {
            if (this.getObjectCreatedFrom(refObject) == null) {
                this.replacedObjects.put(refObject, localObject);
            }
        }

        public List<SmObjectImpl> getCreatedObjects() {
            return new ArrayList<SmObjectImpl>(this.createdObjects.values());
        }

        public List<SmObjectImpl> getObjectsToDelete() {
            return new ArrayList<SmObjectImpl>(this.objectsToDelete);
        }

        public List<SmObjectImpl> getUpdatedObjects() {
            return new ArrayList<SmObjectImpl>(this.replacedObjects.values());
        }

        public Map<SmObjectImpl, SmObjectImpl> getCreations() {
            return this.createdObjects;
        }

        public List<SmObjectImpl> getDeletions() {
            return this.objectsToDelete;
        }

        public List<SmObjectImpl> getGarbage() {
            return this.objectsToGarbage;
        }

        public SmObjectImpl getObjectCreatedFrom(SmObjectImpl refObject) {
            return this.createdObjects.get(refObject);
        }

        public SmObjectImpl getObjectUpdatedFrom(SmObjectImpl refObject) {
            return this.replacedObjects.get(refObject);
        }

        public Map<SmObjectImpl, SmObjectImpl> getUpdates() {
            return this.replacedObjects;
        }

        public boolean isCreated(SmObjectImpl localObject) {
            return this.createdObjects.containsValue(localObject);
        }

        public boolean isDeleted(SmObjectImpl localObject) {
            return this.objectsToDelete.contains(localObject);
        }

        public boolean isImported(SmObjectImpl localObject) {
            return this.isCreated(localObject) || this.isUpdated(localObject);
        }

        public boolean isUpdated(SmObjectImpl localObject) {
            return this.replacedObjects.containsValue(localObject);
        }

        public void mergeListsFrom(Result result) {
            this.createdObjects.putAll(result.getCreations());
            this.replacedObjects.putAll(result.getUpdates());
            this.objectsToDelete.addAll(result.getDeletions());
        }

        private void removeCreatedObject(SmObjectImpl localObject) {
            SmObjectImpl key = null;
            for (Map.Entry<SmObjectImpl, SmObjectImpl> entry : this.createdObjects.entrySet()) {
                if (!entry.getValue().equals((Object)localObject)) continue;
                key = entry.getKey();
                break;
            }
            if (key != null) {
                this.createdObjects.remove(key);
            }
        }

        public void removeCreation(SmObjectImpl refObject) {
            this.createdObjects.remove(refObject);
        }

        public void removeObjectToDelete(SmObjectImpl localObject) {
            this.objectsToDelete.remove(localObject);
        }

        public void removeUpdate(SmObjectImpl refObject) {
            this.replacedObjects.remove(refObject);
        }

        private void removeUpdatedObject(SmObjectImpl localObject) {
            SmObjectImpl key = null;
            for (Map.Entry<SmObjectImpl, SmObjectImpl> entry : this.replacedObjects.entrySet()) {
                if (!entry.getValue().equals((Object)localObject)) continue;
                key = entry.getKey();
                break;
            }
            if (key != null) {
                this.replacedObjects.remove(key);
            }
        }
    }
}

