/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.importer.defaultimporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.modelio.gproject.importer.core.BrokenDepReport;
import org.modelio.gproject.importer.core.IBrokenDependencyHandler;
import org.modelio.gproject.importer.core.IDependencyUpdater;
import org.modelio.gproject.importer.core.IObjectFinder;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MDependency;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.meta.SmDependency;

public class DefaultReferenceDependencyUpdater
implements IDependencyUpdater {
    private final ICoreSession localSession;
    private final IBrokenDependencyHandler brokenDependencyHandler;
    private final IObjectFinder objectFinder;

    public DefaultReferenceDependencyUpdater(IBrokenDependencyHandler brokenDependencyHandler, IObjectFinder objectFinder, ICoreSession localSession) {
        this.brokenDependencyHandler = brokenDependencyHandler;
        this.objectFinder = objectFinder;
        this.localSession = localSession;
    }

    @Override
    public List<SmObjectImpl> execute(SmObjectImpl refObject, SmDependency smDep, SmObjectImpl localObject) {
        SmDependency localDep = this.objectFinder.getSameDependency(smDep);
        if (localDep != null) {
            List refValues = refObject.mGet((MDependency)smDep);
            List<SmObjectImpl> equivalentLocalValues = this.getEquivalentLocalValues(refValues);
            if (equivalentLocalValues.size() != refValues.size()) {
                this.fireBrokenDepValues(refObject, refValues, smDep, localObject, equivalentLocalValues);
            }
            this.updateDependency(localObject, localDep, equivalentLocalValues, refValues);
        }
        return Collections.emptyList();
    }

    protected List<SmObjectImpl> getEquivalentLocalValues(List<MObject> refValues) {
        ArrayList<SmObjectImpl> equivalentLocalValues = new ArrayList<SmObjectImpl>();
        for (MObject refDepVal : refValues) {
            if (refDepVal != null) {
                SmObjectImpl sameObj = this.objectFinder.getSameObject((SmObjectImpl)refDepVal);
                if (sameObj == null || sameObj.isDeleted()) continue;
                equivalentLocalValues.add(sameObj);
                continue;
            }
            throw new RuntimeException("Error_Null_element_in_dependency");
        }
        return equivalentLocalValues;
    }

    protected void updateDependency(SmObjectImpl localObject, SmDependency localDep, List<SmObjectImpl> equivalentLocalValues, List<MObject> refValues) {
        List localValues = localObject.mGet((MDependency)localDep);
        if (!this.setEqual(refValues, localValues, localDep.isOrdered())) {
            localValues.clear();
            for (SmObjectImpl obj : equivalentLocalValues) {
                localObject.appendDepVal(localDep, obj);
            }
        }
    }

    private void fireBrokenDepValues(SmObjectImpl refObject, List<MObject> refValues, SmDependency smDep, SmObjectImpl localObject, List<SmObjectImpl> equivalentLocalValues) {
        for (MObject refVal : refValues) {
            if (equivalentLocalValues.contains(refVal)) continue;
            this.brokenDependencyHandler.handleBrokenDep(new BrokenDepReport(refObject, localObject, smDep, (SmObjectImpl)refVal));
        }
    }

    private boolean setEqual(List<?> a, List<?> b, boolean ordered) {
        if (a.size() != b.size()) {
            return false;
        }
        if (!ordered) {
            for (Object object : a) {
                if (b.contains(object)) continue;
                return false;
            }
        } else {
            int i = 0;
            while (i < a.size()) {
                if (!a.get(i).equals(b.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

