/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.lock;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.modelio.gproject.data.project.ILockInfo;
import org.modelio.vbasic.log.Log;

public class LockInfo
implements ILockInfo {
    private static final int VERSION = 1;
    private Date date;
    private String hostName;
    private boolean isSelf;
    private String user;
    private String vmIdentifier;

    public LockInfo(boolean isSelf, String user, String hostName, String jvmIdentifier, Date date) {
        this.isSelf = isSelf;
        this.user = user;
        this.hostName = hostName;
        this.vmIdentifier = jvmIdentifier;
        this.date = date;
    }

    public LockInfo(Properties p, String thisVmIdentifier) {
        int readV = Integer.parseInt(p.getProperty("version"));
        if (readV > 1) {
            Log.warning((Throwable)new ParseException("Future version " + readV + " of lock informations: " + p.toString(), 0));
        }
        this.user = p.getProperty("user");
        this.hostName = p.getProperty("hostName");
        this.vmIdentifier = p.getProperty("vmIdentifier");
        this.isSelf = thisVmIdentifier.equals(this.vmIdentifier);
        String sdate = p.getProperty("date");
        try {
            this.date = LockInfo.getDateFormat().parse(sdate);
        }
        catch (ParseException e) {
            Log.warning((Throwable)e);
        }
    }

    public Date getDate() {
        return this.date;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getOwner() {
        return this.user;
    }

    public String getJvmIdentifier() {
        return this.vmIdentifier;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public Properties toProperties() {
        Properties p = new Properties();
        p.setProperty("version", String.valueOf(1));
        p.setProperty("vmIdentifier", this.vmIdentifier);
        p.setProperty("user", this.user);
        p.setProperty("hostName", this.hostName);
        p.setProperty("date", String.valueOf(LockInfo.getDateFormat().format(this.date)));
        return p;
    }

    private static DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance(0, 0, Locale.US);
    }

    public String toString() {
        return "LockInfo [date=" + String.valueOf(this.date) + ", hostName=" + this.hostName + ", isSelf=" + this.isSelf + ", user=" + this.user + ", vmIdentifier=" + this.vmIdentifier + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.vmIdentifier == null ? 0 : this.vmIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LockInfo other = (LockInfo)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
            return false;
        }
        return !(this.vmIdentifier == null ? other.vmIdentifier != null : !this.vmIdentifier.equals(other.vmIdentifier));
    }
}

