/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.lock;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.modelio.gproject.data.project.ILockInfo;
import org.modelio.gproject.lock.GProjectLockedException;
import org.modelio.gproject.lock.LockInfo;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.vbasic.files.CloseOnFail;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.net.HostName;

public class ProjectLock {
    private String projectName;
    private FileChannel channel;
    private FileLock lock;
    private final Path lockFile;
    private final Path lockInfoFile;
    private static final Map<Path, WeakReference<ProjectLock>> instances = new HashMap<Path, WeakReference<ProjectLock>>();

    private ProjectLock(Path directory, String projectName) {
        this.projectName = projectName;
        this.lockFile = directory.resolve("lock.dat");
        this.lockInfoFile = directory.resolve("lock.info");
    }

    public synchronized void close() throws IOException {
        if (this.lock != null) {
            IOException err = null;
            try {
                this.lock.release();
            }
            catch (IOException e) {
                err = e;
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                    if (Files.isRegularFile(this.lockFile, new LinkOption[0])) {
                        Files.delete(this.lockFile);
                    }
                    this.channel = null;
                }
                catch (IOException e) {
                    if (err != null) {
                        err.addSuppressed(e);
                    }
                    err = e;
                }
            }
            try {
                if (Files.isRegularFile(this.lockInfoFile, new LinkOption[0])) {
                    Files.delete(this.lockInfoFile);
                }
            }
            catch (IOException e) {
                if (err != null) {
                    err.addSuppressed(e);
                }
                Log.warning((Throwable)e);
            }
            if (err == null) {
                this.lock = null;
            } else {
                throw err;
            }
        }
    }

    public synchronized void lock() throws GProjectLockedException, IOException {
        if (this.lock != null || this.channel != null) {
            String msg = CoreProject.I18N.getMessage("ProjectLock.sameVm", new Object[]{this.projectName});
            throw new GProjectLockedException(msg, new IllegalStateException(msg));
        }
        Files.createDirectories(this.lockFile.getParent(), new FileAttribute[0]);
        this.channel = FileChannel.open(this.lockFile, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
        try {
            Throwable msg = null;
            Object var2_7 = null;
            try (CloseOnFail shield = new CloseOnFail((Closeable)this.channel);){
                this.lock = this.channel.tryLock(0L, Long.MAX_VALUE, false);
                if (this.lock == null) {
                    throw this.createLockException();
                }
                String jvmIdentifier = this.getJvmId();
                String user = System.getProperty("user.name");
                LockInfo lockInfo = new LockInfo(true, user, ProjectLock.getHostName(), jvmIdentifier, Calendar.getInstance().getTime());
                Throwable throwable = null;
                Object var8_15 = null;
                try (OutputStream out = Files.newOutputStream(this.lockInfoFile, new OpenOption[0]);){
                    lockInfo.toProperties().store(out, "Project lock informations");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                shield.success();
            }
            catch (Throwable throwable) {
                if (msg == null) {
                    msg = throwable;
                } else if (msg != throwable) {
                    msg.addSuppressed(throwable);
                }
                throw msg;
            }
        }
        catch (GProjectLockedException e) {
            throw e;
        }
        catch (OverlappingFileLockException e) {
            throw new GProjectLockedException(CoreProject.I18N.getMessage("ProjectLock.sameVm", new Object[]{this.projectName}), e);
        }
        catch (IOException e) {
            throw new IOException(CoreProject.I18N.getMessage("ProjectLock.failure", new Object[]{this.projectName, FileUtils.getLocalizedMessage((IOException)e)}), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ILockInfo test() throws IOException {
        if (this.lock != null) {
            return this.getLockInfo();
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                FileLock l;
                FileChannel c;
                block17: {
                    ILockInfo iLockInfo;
                    block18: {
                        c = FileChannel.open(this.lockFile, StandardOpenOption.READ, StandardOpenOption.WRITE);
                        l = c.tryLock(0L, Long.MAX_VALUE, false);
                        if (l != null) break block17;
                        iLockInfo = this.getLockInfo();
                        if (l == null) break block18;
                        l.close();
                    }
                    if (c == null) return iLockInfo;
                    c.close();
                    return iLockInfo;
                }
                if (l != null) {
                    l.close();
                }
                if (c == null) return null;
                {
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (c == null) throw throwable;
                        c.close();
                        throw throwable;
                    }
                }
                {
                    c.close();
                    return null;
                    catch (Throwable throwable3) {
                        if (l == null) throw throwable3;
                        l.close();
                        throw throwable3;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            return null;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return this.getLockInfo();
        }
    }

    private static String getHostName() {
        return HostName.get();
    }

    private String getJvmId() {
        String jvmId = ManagementFactory.getRuntimeMXBean().getName();
        return jvmId;
    }

    private ILockInfo getLockInfo() throws IOException {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream is = Files.newInputStream(this.lockInfoFile, new OpenOption[0]);){
                props.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            return null;
        }
        return new LockInfo(props, this.getJvmId());
    }

    private GProjectLockedException createLockException() {
        try {
            ILockInfo info = this.getLockInfo();
            String msg = info.isSelf() ? CoreProject.I18N.getMessage("ProjectLock.sameVm", new Object[]{this.projectName}) : CoreProject.I18N.getMessage("ProjectLock.otherVm", new Object[]{this.projectName, info.getJvmIdentifier(), info.getHostName(), info.getOwner(), info.getDate()});
            return new GProjectLockedException(msg, info);
        }
        catch (IOException e) {
            return new GProjectLockedException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectLock get(Path directory, String projectName) throws IOException {
        Files.createDirectories(directory, new FileAttribute[0]);
        Path realDir = directory.toRealPath(new LinkOption[0]);
        Map<Path, WeakReference<ProjectLock>> map = instances;
        synchronized (map) {
            ProjectLock instance;
            WeakReference<ProjectLock> ref = instances.get(realDir);
            ProjectLock projectLock = instance = ref != null ? (ProjectLock)ref.get() : null;
            if (instance == null) {
                instance = new ProjectLock(realDir, projectName);
                instances.put(realDir, new WeakReference<ProjectLock>(instance));
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Map<Path, WeakReference<ProjectLock>> map = instances;
        synchronized (map) {
            block8: {
                try {
                    try {
                        this.close();
                    }
                    catch (Exception e) {
                        Log.trace((String)("Failed closing " + String.valueOf(this.lockFile) + " lock on finalization:" + e.toString()));
                        Log.trace((Throwable)e);
                        instances.remove(this.lockFile.getParent());
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    instances.remove(this.lockFile.getParent());
                    throw throwable;
                }
                instances.remove(this.lockFile.getParent());
            }
        }
        super.finalize();
    }
}

