/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.migration;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.vcore.model.spi.mm.IMigrationReporter;

public class BasicMigrationReporter
implements IMigrationReporter,
Closeable {
    private PrintWriterMigrationLogger logger;
    private PrintWriterMigrationLogger resultWriter;
    private StringWriter result = new StringWriter();
    private BufferedWriter fileWriter;

    public BasicMigrationReporter(Path reportFile) throws IOException {
        this.resultWriter = new PrintWriterMigrationLogger(this.result);
        Files.createDirectories(reportFile.getParent(), new FileAttribute[0]);
        this.fileWriter = Files.newBufferedWriter(reportFile, new OpenOption[0]);
        this.logger = new PrintWriterMigrationLogger(this.fileWriter);
        this.resultWriter.println(CoreProject.I18N.getMessage("BasicMigrationReporter.logFileWritten", new Object[]{reportFile}));
    }

    public IMigrationReporter.IMigrationLogger getLogger() {
        return this.logger;
    }

    public IMigrationReporter.IMigrationLogger getResultReporter() {
        return this.resultWriter;
    }

    public String getResult() {
        return this.result.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.resultWriter != null) {
            this.resultWriter.close();
            this.resultWriter = null;
        }
        if (this.fileWriter != null) {
            this.fileWriter.close();
            this.fileWriter = null;
        }
    }

    private static class PrintWriterMigrationLogger
    implements IMigrationReporter.IMigrationLogger {
        private final PrintWriter writer;

        public PrintWriterMigrationLogger(Writer writer) {
            this.writer = new PrintWriter(writer);
        }

        public void append(CharSequence s) {
            this.writer.append(s);
        }

        public void printStackTrace(Throwable e) {
            e.printStackTrace(this.writer);
        }

        public void printf(String format, Object ... args) {
            this.writer.printf(format, args);
        }

        public void format(String format, Object ... args) {
            this.writer.format(format, args);
        }

        public void println() {
            this.writer.println();
        }

        public void println(String s) {
            this.writer.println(s);
        }

        public void close() {
            this.writer.flush();
            this.writer.close();
        }
    }
}

