/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.migration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.modelio.gproject.FragmentAuthenticationException;
import org.modelio.gproject.MigrationFailedException;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.migration.NestedBasicLogger;
import org.modelio.gproject.parts.IGModelFragmentMigrator;
import org.modelio.gproject.parts.fragment.VersionHelper;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.IBasicLogger;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vbasic.version.VersionedItem;
import org.modelio.vcore.model.spi.IGMetamodelExtension;
import org.modelio.vcore.model.spi.mm.IMigrationReporter;
import org.modelio.vcore.model.spi.mm.IMigrationStepDescription;
import org.modelio.vcore.model.spi.mm.IMofRepositoryMigrator;
import org.modelio.vcore.model.spi.mm.IMofRepositoryMigratorProvider;
import org.modelio.vcore.model.spi.mm.IMofSession;
import org.modelio.vcore.model.spi.mm.MetamodelChangeDescriptor;
import org.modelio.vcore.model.spi.mm.MigrationChain;
import org.modelio.vcore.model.spi.mm.MigrationChainResolver;
import org.modelio.vcore.model.spi.mm.MigrationStepDescription;
import org.modelio.vcore.model.spi.mm.MmVersionComparator;
import org.modelio.vcore.model.spi.mm.MofMigrationException;
import org.modelio.vcore.model.spi.mm.MofSession;
import org.modelio.vcore.session.api.IAccessManager;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.api.repository.IRepositoryErrorListener;
import org.modelio.vcore.session.api.transactions.ITransaction;
import org.modelio.vcore.session.impl.CoreSession;
import org.modelio.vcore.session.impl.CoreSessionBuilder;
import org.modelio.vcore.session.impl.permission.BasicAccessManager;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;
import org.modelio.vcore.smkernel.meta.descriptor.MClassRef;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptor;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelFragmentDescriptor;
import org.modelio.vcore.smkernel.meta.mof.MofMetamodel;
import org.modelio.vcore.smkernel.meta.mof.MofSmClass;

public class ChainedMofFragmentMigrator
implements IGModelFragmentMigrator,
IGModelFragmentMigrator.IMigrationProcess {
    private String userMessage;
    private boolean migrationChainComputed;
    private boolean terminalCalled;
    private final IGModelFragment fragToMigrate;
    private final IGProject project;
    private final List<IMofRepositoryMigratorProvider> migrationCandidates;
    private MigrationChain migrationChain;
    private IMigrationReporter migrationReporter;
    private final RepositorySupplier repositoryFactory;
    private IAccessManager migrationAccessManager;
    private IBasicLogger oldVCoreLogger;
    private Optional<MetamodelDescriptor> initialMmDescriptor;
    private MetamodelVersionDescriptor fromMmVersion;
    private MetamodelVersionDescriptor targetMmVersion;
    private List<IMigrationStepDescription> stepsDescription;

    public ChainedMofFragmentMigrator(IGProject project, IGModelFragment fragToMigrate, RepositorySupplier repositoryFactory) {
        this.project = project;
        this.fragToMigrate = fragToMigrate;
        this.repositoryFactory = repositoryFactory;
        this.migrationAccessManager = new BasicAccessManager();
        this.migrationCandidates = new ArrayList<IMofRepositoryMigratorProvider>();
    }

    public final ChainedMofFragmentMigrator addCandidate(IMofRepositoryMigratorProvider migrator) {
        this.migrationCandidates.add(migrator);
        return this;
    }

    protected final IMigrationReporter getMigrationReporter() {
        return this.migrationReporter;
    }

    @Override
    public final void run(IModelioProgress monitor, IMigrationReporter reporter) throws FragmentAuthenticationException, MigrationFailedException {
        IGModelFragmentMigrator.super.run(monitor, reporter);
    }

    protected final void runMofMigrator(IModelioProgress monitor, int migratorIndex) throws FragmentAuthenticationException, MigrationFailedException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)5);
        IMofRepositoryMigrator mofMigrator = this.getMigrationChainElement(migratorIndex);
        MmVersionComparator vcomparator = MmVersionComparator.withSource((MetamodelVersionDescriptor)mofMigrator.getSourceMetamodel()).withTarget(mofMigrator.getTargetMetamodel()).withCommonRemoved().withMissingSourcesRemoved();
        MetamodelVersionDescriptor mmDiff = vcomparator.getTarget();
        String msg = CoreProject.I18N.getMessage("ChainedMofFragmentMigrator.mon.migratingTowardVersion", new Object[]{this.fragToMigrate.getId(), mmDiff});
        mon.subTask(msg);
        this.migrationReporter.getLogger().printf("\n\nMigrating '%s' from %s toward %s...\n------------------------------------\n", new Object[]{this.fragToMigrate.getId(), vcomparator.getSource(), mmDiff});
        try {
            MofSession migrationSession = this.prepareMofSession((IModelioProgress)mon.newChild(1), migratorIndex);
            try (ICoreSession session = migrationSession.getCoreSession();){
                Throwable throwable = null;
                Object var11_14 = null;
                try (ITransaction t = session.getTransactionSupport().createTransaction(msg);){
                    this.preMofMigration(mon.newChildSupplier(1), migrationSession, mofMigrator);
                    mon.subTask(msg);
                    mon.setWorkRemaining(5);
                    this.migrationReporter.getLogger().println(" Running '" + mofMigrator.getClass().getSimpleName() + "' migrator ... ");
                    mofMigrator.run((IModelioProgress)mon.newChild(3), (IMofSession)migrationSession);
                    mon.setWorkRemaining(4);
                    mon.subTask(msg);
                    this.postMofMigration(mon.newChildSupplier(2), migrationSession, mofMigrator);
                    mon.setWorkRemaining(4);
                    mon.subTask(msg);
                    migrationSession.processScheduledReidentifications(mon.newChildSupplier(3));
                    t.commit();
                    session.save((IModelioProgress)mon);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (MofMigrationException e) {
            throw new MigrationFailedException(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new MigrationFailedException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
    }

    private void computeMetamodelMigrators() throws IOException {
        for (IGMetamodelExtension extension : this.project.getProjectEnvironment().getDefaultMetamodelExtensions()) {
            IMofRepositoryMigratorProvider mofRepoMigrator = (IMofRepositoryMigratorProvider)extension.createExtension(IMofRepositoryMigratorProvider.class, this.project.getSession());
            if (mofRepoMigrator == null || this.migrationCandidates.contains(mofRepoMigrator)) continue;
            this.migrationCandidates.add(mofRepoMigrator);
        }
        this.fromMmVersion = this.fragToMigrate.getRequiredMetamodelDescriptor();
        this.targetMmVersion = VersionHelper.getDescriptors((MMetamodel)this.project.getSession().getMetamodel());
        this.migrationChain = this.resolveMigrationChain(this.fromMmVersion, this.targetMmVersion, this.migrationCandidates);
        this.migrationChainComputed = true;
        if (!this.migrationChain.isSuccessful()) {
            MmVersionComparator comp = MmVersionComparator.withSource((MetamodelVersionDescriptor)this.fromMmVersion).withTarget(this.targetMmVersion).withCommonRemoved();
            this.userMessage = CoreProject.I18N.getMessage("ChainedMofFragmentMigrator.noMigrationChainFound", new Object[]{this.fragToMigrate.getId(), comp.getSource(), comp.getTarget()});
            this.stepsDescription = Collections.emptyList();
        } else {
            this.userMessage = this.computeUserMessage();
            this.stepsDescription = this.computeStepsDescription();
        }
    }

    private void prepareMetamodel(CoreSession session, int migratorIndex) throws MofMigrationException {
        MofMetamodel metamodel = (MofMetamodel)session.getMetamodel();
        MetamodelChangeDescriptor prevMmChanges = null;
        int i = this.migrationChain.getSteps().size() - 1;
        while (i >= migratorIndex) {
            IMofRepositoryMigrator mofMigrator = this.getMigrationChainElement(i);
            mofMigrator.prepareMetamodel(metamodel);
            prevMmChanges = mofMigrator.getMetamodelChanges();
            if (prevMmChanges != null) {
                MofSmClass mc;
                for (MClassRef mcRef : prevMmChanges.getAddedCmsNodes()) {
                    mc = (MofSmClass)metamodel.getMClass(mcRef.getQualifiedName());
                    if (mc == null) continue;
                    mc.setIsCmsNode(false);
                }
                for (MClassRef mcRef : prevMmChanges.getRemovedCmsNodes()) {
                    mc = (MofSmClass)metamodel.getMClass(mcRef.getQualifiedName());
                    if (mc == null) continue;
                    mc.setIsCmsNode(true);
                }
            }
            --i;
        }
    }

    protected final IGProject getProject() {
        return this.project;
    }

    protected void setMigrationAccessManager(IAccessManager migrationAccessManager) {
        this.migrationAccessManager = migrationAccessManager;
    }

    protected IMofRepositoryMigrator getMigrationChainElement(int migratorIndex) {
        return (IMofRepositoryMigrator)this.migrationChain.getSteps().get(migratorIndex);
    }

    protected void preMofMigration(Supplier<SubProgress> mon, MofSession migrationSession, IMofRepositoryMigrator mofMigrator) throws MofMigrationException {
    }

    protected void postMofMigration(Supplier<SubProgress> mon, MofSession migrationSession, IMofRepositoryMigrator mofMigrator) throws MofMigrationException {
    }

    public final MigrationChain getMigrationChain() throws IOException {
        if (!this.migrationChainComputed) {
            this.computeMetamodelMigrators();
        }
        return this.migrationChain;
    }

    protected final MofSession prepareMofSession(IModelioProgress monitor, int migratorIndex) throws IOException, FragmentAuthenticationException, MofMigrationException {
        CoreSession session = new CoreSessionBuilder().withMetamodel(this.project.getSession().getMetamodel()).forMetamodelMigration().build();
        boolean ok = false;
        try {
            if (migratorIndex != -1) {
                this.prepareMetamodel(session, migratorIndex);
            }
            IRepository toMigrate = this.repositoryFactory.intantiateRepository((ICoreSession)session);
            session.connectRepository(toMigrate, this.migrationAccessManager, monitor);
            toMigrate.getErrorSupport().addErrorListener((IRepositoryErrorListener)new RepositoryErrorListener());
            MofSession mofSession = new MofSession((ICoreSession)session, toMigrate, this.getMigrationReporter());
            ok = true;
            MofSession mofSession2 = mofSession;
            return mofSession2;
        }
        finally {
            if (!ok) {
                session.close();
            }
        }
    }

    @Override
    public String getRequiredUserActions() {
        return this.userMessage;
    }

    protected final void runMofMigrators(IModelioProgress monitor) throws FragmentAuthenticationException, MigrationFailedException {
        int migrationChainSize = this.migrationChain.getSteps().size();
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)migrationChainSize);
        int i = 0;
        while (i < migrationChainSize) {
            this.runMofMigrator((IModelioProgress)mon.newChild(1), i);
            ++i;
        }
    }

    protected String computeUserMessage() {
        return "";
    }

    protected MigrationChain resolveMigrationChain(MetamodelVersionDescriptor fromMetamodel, MetamodelVersionDescriptor targetMetamodelDesc, Collection<IMofRepositoryMigratorProvider> migrationProviders) {
        return MigrationChainResolver.resolve((MetamodelVersionDescriptor)fromMetamodel, (MetamodelVersionDescriptor)targetMetamodelDesc, migrationProviders);
    }

    protected final ICoreSession prepareCoreSession(IModelioProgress monitor) throws FragmentAuthenticationException, MigrationFailedException {
        CoreSession coreSession;
        block6: {
            CoreSession session = new CoreSessionBuilder().withMetamodel(this.project.getSession().getMetamodel()).build();
            boolean ok = false;
            try {
                IRepository toMigrate = this.repositoryFactory.intantiateRepository((ICoreSession)session);
                session.connectRepository(toMigrate, this.migrationAccessManager, monitor);
                toMigrate.getErrorSupport().addErrorListener((IRepositoryErrorListener)new RepositoryErrorListener());
                ok = true;
                coreSession = session;
                if (ok) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (!ok) {
                        session.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MigrationFailedException(FileUtils.getLocalizedMessage((IOException)e), e);
                }
            }
            session.close();
        }
        return coreSession;
    }

    protected final MetamodelVersionDescriptor getFinalVersionDescriptor() throws IOException {
        List chain = this.getMigrationChain().getSteps();
        IMofRepositoryMigrator lastStep = (IMofRepositoryMigrator)chain.get(chain.size() - 1);
        return lastStep.getTargetMetamodel();
    }

    protected final <T extends IGModelFragment> T getFragmentToMigrate() {
        return (T)this.fragToMigrate;
    }

    protected final MetamodelDescriptor getFinalMergedMmDescriptor(IMigrationReporter reporter) throws IOException, MofMigrationException {
        Optional<MetamodelDescriptor> initMetamodelDesc = this.getInitialMetamodelDescriptor();
        MetamodelDescriptor targetMmDesc = this.getProject().getSession().getMetamodel().serialize();
        for (IMofRepositoryMigrator migrator : this.getMigrationChain().getSteps()) {
            migrator.completeFinalMetamodelDescriptor(targetMmDesc, reporter);
        }
        if (initMetamodelDesc.isPresent()) {
            MetamodelDescriptor mmd = initMetamodelDesc.get();
            for (VersionedItem fragEntry : this.getFinalVersionDescriptor()) {
                targetMmDesc.getFragments().computeIfAbsent(fragEntry.getName(), fragName -> (MetamodelFragmentDescriptor)mmd.getFragments().get(fragName));
            }
        }
        return targetMmDesc;
    }

    protected final Optional<MetamodelDescriptor> getInitialMetamodelDescriptor() {
        if (this.migrationReporter == null) {
            throw new IllegalStateException("start() not yet called.");
        }
        return this.initialMmDescriptor;
    }

    @Override
    public final IGModelFragmentMigrator.IMigrationProcess start(IModelioProgress monitor, IMigrationReporter reporter) throws FragmentAuthenticationException, MigrationFailedException {
        this.terminalCalled = false;
        try {
            this.getMigrationChain();
        }
        catch (IOException e) {
            throw new MigrationFailedException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
        this.migrationReporter = reporter;
        String msg = CoreProject.I18N.getMessage("ChainedMofFragmentMigrator.mon.migration", new Object[]{this.fragToMigrate.getId()});
        monitor.subTask(msg);
        monitor.setTaskName(msg);
        reporter.getLogger().println(msg);
        reporter.getLogger().println();
        reporter.getLogger().println(this.getRequiredUserActions());
        reporter.getLogger().println();
        reporter.getLogger().println(this.getMmDifferencesSummary());
        for (IMigrationStepDescription step : this.getStepsDescription()) {
            reporter.getLogger().printf(" - %s \n", new Object[]{step.getStepDescription()});
        }
        this.oldVCoreLogger = Log.getLogger();
        Log.setLogger((IBasicLogger)new NestedBasicLogger(this.oldVCoreLogger, reporter.getLogger()));
        try (IRepository r = this.repositoryFactory.intantiateRepository(this.getProject().getSession());){
            this.initialMmDescriptor = r.getMetamodelDescriptor();
        }
        catch (IOException e) {
            throw new MigrationFailedException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
        this.doStart(monitor);
        return this;
    }

    protected void doStart(IModelioProgress monitor) throws FragmentAuthenticationException, MigrationFailedException {
    }

    @Override
    public void migrateModel(IModelioProgress monitor) throws MigrationFailedException, FragmentAuthenticationException {
        this.runMofMigrators(monitor);
    }

    @Override
    public final void finish(IModelioProgress monitor) throws MigrationFailedException {
        assert (!this.terminalCalled);
        try {
            this.fragToMigrate.unmount(monitor);
        }
        catch (IGPart.GPartException e) {
            Log.warning((Throwable)e);
            this.getMigrationReporter().getLogger().println(e.getLocalizedMessage());
        }
        this.doFinish(monitor);
        this.terminalCalled = true;
    }

    protected void doFinish(IModelioProgress monitor) throws MigrationFailedException {
    }

    @Override
    public final void close() throws MigrationFailedException {
        try {
            if (!this.terminalCalled) {
                this.abort(null);
            }
            this.doClose();
        }
        finally {
            this.terminalCalled = true;
            Log.setLogger((IBasicLogger)this.oldVCoreLogger);
        }
    }

    protected void doClose() throws MigrationFailedException {
    }

    @Override
    public final void abort(IModelioProgress monitor) throws MigrationFailedException {
        assert (!this.terminalCalled);
        try {
            this.doAbort(monitor);
        }
        finally {
            this.terminalCalled = true;
        }
    }

    protected void doAbort(IModelioProgress monitor) throws MigrationFailedException {
    }

    protected List<IMigrationStepDescription> computeStepsDescription() {
        ArrayList<IMigrationStepDescription> ret = new ArrayList<IMigrationStepDescription>(this.migrationChain.getSteps().size());
        for (IMofRepositoryMigrator mofMigrator : this.migrationChain.getSteps()) {
            MmVersionComparator vcomparator = MmVersionComparator.withSource((MetamodelVersionDescriptor)mofMigrator.getSourceMetamodel()).withTarget(mofMigrator.getTargetMetamodel()).withCommonRemoved().withMissingRemoved();
            if (vcomparator.isTargetCompatible(false)) continue;
            String msg = CoreProject.I18N.getMessage("ChainedMofFragmentMigrator.detail.migratorline", new Object[]{this.fragToMigrate.getId(), vcomparator.getSource(), vcomparator.getTarget()});
            ret.add((IMigrationStepDescription)new MigrationStepDescription(msg));
        }
        return ret;
    }

    protected final MetamodelVersionDescriptor getFromMmVersion() {
        return this.fromMmVersion;
    }

    @Deprecated
    protected String getMmDifferencesSummary() {
        MmVersionComparator comp = MmVersionComparator.withSource((MetamodelVersionDescriptor)this.getFromMmVersion()).withTarget(this.getTargetMmVersion()).withCommonRemoved();
        return CoreProject.I18N.getMessage("ChainedMofFragmentMigrator.detail.first", new Object[]{this.fragToMigrate.getId(), comp.getSource(), comp.getTarget()});
    }

    @Override
    public List<IMigrationStepDescription> getStepsDescription() {
        return this.stepsDescription;
    }

    protected final MetamodelVersionDescriptor getTargetMmVersion() {
        return this.targetMmVersion;
    }

    private final class RepositoryErrorListener
    implements IRepositoryErrorListener {
        private final IMigrationReporter.IMigrationLogger logger;

        private RepositoryErrorListener() {
            this.logger = ChainedMofFragmentMigrator.this.getMigrationReporter().getLogger();
        }

        public void onWarning(IRepository repository, Throwable e) {
            if (e instanceof IOException) {
                this.logger.printf("Repository warning: %s\n", new Object[]{FileUtils.getLocalizedMessage((IOException)((IOException)e))});
                Log.warning((Throwable)e);
            } else {
                Log.warning((Throwable)e);
                this.logger.printf("Repository warning: %s\n", new Object[]{e.toString()});
                this.logger.printStackTrace(e);
            }
        }

        public void onError(IRepository repository, Throwable e) {
            if (e instanceof IOException) {
                this.logger.printf("Repository ERROR: %s\n", new Object[]{FileUtils.getLocalizedMessage((IOException)((IOException)e))});
            } else {
                this.logger.printf("Repository ERROR: %s\n", new Object[]{e.toString()});
            }
            this.logger.printStackTrace(e);
        }
    }

    @FunctionalInterface
    public static interface RepositorySupplier {
        public IRepository intantiateRepository(ICoreSession var1) throws FragmentAuthenticationException, IOException;
    }
}

