/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.migration;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.vbasic.files.FileUtils;

public class FileFlags {
    private IGModelFragment fragment;

    public FileFlags(IGModelFragment fragment) {
        this.fragment = fragment;
    }

    public void removeMigrationFlag(String flag) throws IOException {
        Path f = this.fragment.getRuntimeDirectory().resolve(flag + ".flag");
        Files.deleteIfExists(f);
    }

    public boolean isMigrationFlag(String flag) {
        Path f = this.fragment.getRuntimeDirectory().resolve(flag + ".flag");
        return Files.isRegularFile(f, new LinkOption[0]);
    }

    public String getMigrationFlag(String flag) throws FileSystemException, IOException {
        Path f = this.fragment.getRuntimeDirectory().resolve(flag + ".flag");
        if (Files.isRegularFile(f, new LinkOption[0])) {
            return FileUtils.readWhole((Path)f, (String)StandardCharsets.UTF_8.name());
        }
        return null;
    }

    public void putMigrationFlag(String flag, String content) throws IOException {
        Path f = this.fragment.getRuntimeDirectory().resolve(flag + ".flag");
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter w = Files.newBufferedWriter(f, StandardCharsets.UTF_8, new OpenOption[0]);){
            if (content != null) {
                w.write(content);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

