/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.migration;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.modelio.gproject.FragmentAuthenticationException;
import org.modelio.gproject.MigrationFailedException;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.parts.IGModelFragmentMigrator;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.model.spi.mm.IMigrationReporter;
import org.modelio.vcore.model.spi.mm.IMigrationStepDescription;
import org.modelio.vcore.smkernel.meta.SmMetamodel;

public class FragmentMigratorWithBackup
implements IGModelFragmentMigrator {
    private final IGModelFragment fragToMigrate;
    private IMigrationReporter migrationReporter;
    private final IGModelFragmentMigrator wrapped;

    public FragmentMigratorWithBackup(IGModelFragment fragToMigrate, IGModelFragmentMigrator wrapped) {
        this.fragToMigrate = fragToMigrate;
        this.wrapped = wrapped;
    }

    protected Path getBackupDirectory() {
        return this.fragToMigrate.getRuntimeDirectory().resolve("migration_backup");
    }

    protected void deleteBackup(IModelioProgress monitor) throws IOException {
        String msg = "Deleting backup ... ";
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (String)msg, (int)1);
        mon.subTask(msg);
        this.getMigrationReporter().getLogger().println(msg);
        FileUtils.delete((Path)this.getBackupDirectory());
    }

    protected void backupDataDir(IModelioProgress monitor) throws IOException {
        String msg = "Backup of data directory... ";
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (String)msg, (int)1);
        mon.subTask(msg);
        this.getMigrationReporter().getLogger().println(msg);
        Files.createDirectories(this.getBackupDirectory(), new FileAttribute[0]);
        FileUtils.copyDirectoryTo((Path)this.fragToMigrate.getDataDirectory(), (Path)this.getBackupDirectory());
    }

    protected void restoreBackup(IModelioProgress monitor) throws IOException {
        Path dataDirectory = this.fragToMigrate.getDataDirectory();
        Path backupDirectory = this.getBackupDirectory();
        FileUtils.delete((Path)this.getFailDirectory());
        if (Files.isDirectory(backupDirectory, new LinkOption[0])) {
            String msg = CoreProject.I18N.getMessage("FragmentMigratorWithBackup.mon.restoreBackup", new Object[]{this.fragToMigrate.getId(), backupDirectory});
            SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (String)msg, (int)1);
            mon.subTask(msg);
            this.getMigrationReporter().getLogger().println(msg);
            if (Files.isDirectory(dataDirectory, new LinkOption[0])) {
                FragmentMigratorWithBackup.moveDirectory(dataDirectory, this.getFailDirectory());
            }
            FragmentMigratorWithBackup.moveDirectory(backupDirectory, dataDirectory);
            msg = CoreProject.I18N.getMessage("FragmentMigratorWithBackup.mon.restoreBackup.done", new Object[]{this.fragToMigrate.getId(), backupDirectory});
            this.getMigrationReporter().getLogger().println(msg);
            this.getMigrationReporter().getResultReporter().println(msg);
        }
    }

    public IMigrationReporter getMigrationReporter() {
        return this.migrationReporter;
    }

    public void setMigrationReporter(IMigrationReporter migrationReporter) {
        this.migrationReporter = migrationReporter;
    }

    private Path getMigrationBackupArchiveDirectory() {
        return this.fragToMigrate.getRuntimeDirectory().resolve("migration_archive");
    }

    protected static void moveDirectory(Path toMove, Path newPath) throws IOException {
        try {
            Files.move(toMove, newPath, new CopyOption[0]);
        }
        catch (IOException iOException) {
            FileUtils.copyDirectoryTo((Path)toMove, (Path)newPath);
            FileUtils.delete((Path)toMove);
        }
    }

    private void deleteBackupArchive(SubProgress mon) throws IOException {
        Path backArchiveDir = this.getMigrationBackupArchiveDirectory();
        if (Files.isDirectory(backArchiveDir, new LinkOption[0])) {
            String taskName = CoreProject.I18N.getMessage("FragmentMigratorWithBackup.mon.deleteBackupArchive", new Object[]{this.fragToMigrate.getId(), backArchiveDir});
            mon.subTask(taskName);
            this.migrationReporter.getLogger().println(taskName);
            FileUtils.delete((Path)backArchiveDir);
        }
    }

    private void archiveBackup(SubProgress mon) throws IOException {
        Path backDir = this.getBackupDirectory();
        Path archiveDir = this.getMigrationBackupArchiveDirectory();
        String taskName = CoreProject.I18N.getMessage("FragmentMigratorWithBackup.mon.archiveBackup", new Object[]{this.fragToMigrate.getId(), archiveDir, backDir});
        mon.subTask(taskName);
        this.migrationReporter.getLogger().println(taskName);
        FragmentMigratorWithBackup.moveDirectory(backDir, archiveDir);
    }

    @Override
    public List<IMigrationStepDescription> getStepsDescription() {
        return this.wrapped.getStepsDescription();
    }

    @Override
    public IGModelFragmentMigrator.IMigrationProcess start(IModelioProgress monitor, IMigrationReporter reporter) throws FragmentAuthenticationException, MigrationFailedException {
        this.setMigrationReporter(reporter);
        String taskName = CoreProject.I18N.getMessage("FragmentMigratorWithBackup.mon.migration", new Object[]{this.fragToMigrate.getId()});
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (String)taskName, (int)14);
        try {
            SmMetamodel.TRACE_SHORT_METACLASSNAMES = false;
            this.restoreBackup((IModelioProgress)mon.newChild(1));
            this.backupDataDir((IModelioProgress)mon.newChild(1));
        }
        catch (IOException e) {
            throw new MigrationFailedException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
        return new MigrationProcess(monitor, reporter);
    }

    protected Path getFailDirectory() {
        return this.fragToMigrate.getRuntimeDirectory().resolve("migration_failure");
    }

    @Override
    public String getRequiredUserActions() {
        return this.wrapped.getRequiredUserActions();
    }

    private final class MigrationProcess
    implements IGModelFragmentMigrator.IMigrationProcess {
        private boolean ok = false;
        private final IGModelFragmentMigrator.IMigrationProcess wrappedProcess;

        public MigrationProcess(IModelioProgress monitor, IMigrationReporter reporter) throws FragmentAuthenticationException, MigrationFailedException {
            this.wrappedProcess = FragmentMigratorWithBackup.this.wrapped.start(monitor, reporter);
        }

        @Override
        public void migrateModel(IModelioProgress monitor) throws MigrationFailedException, FragmentAuthenticationException {
            this.wrappedProcess.migrateModel(monitor);
        }

        @Override
        public void finish(IModelioProgress monitor) throws MigrationFailedException {
            SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)3);
            this.wrappedProcess.finish((IModelioProgress)mon.newChild(1));
            try {
                try {
                    FragmentMigratorWithBackup.this.deleteBackupArchive(mon.newChild(1));
                    FragmentMigratorWithBackup.this.archiveBackup(mon.newChild(1));
                    this.ok = true;
                }
                catch (IOException e) {
                    throw new MigrationFailedException(FileUtils.getLocalizedMessage((IOException)e), e);
                }
            }
            finally {
                this.restoreBackupOnFail((IModelioProgress)mon.newChild(1));
                SmMetamodel.TRACE_SHORT_METACLASSNAMES = true;
            }
        }

        @Override
        public void close() throws MigrationFailedException {
            try {
                this.wrappedProcess.close();
            }
            finally {
                this.restoreBackupOnFail(null);
            }
        }

        @Override
        public void abort(IModelioProgress monitor) throws MigrationFailedException {
            SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)2);
            try {
                this.wrappedProcess.abort((IModelioProgress)mon.newChild(1));
            }
            finally {
                this.restoreBackupOnFail((IModelioProgress)mon.newChild(1));
            }
        }

        private void restoreBackupOnFail(IModelioProgress monitor) {
            if (!this.ok) {
                try {
                    FragmentMigratorWithBackup.this.restoreBackup(monitor);
                }
                catch (IOException e) {
                    String msg = CoreProject.I18N.getMessage("FragmentMigratorWithBackup.restoreBackupFailed", new Object[]{FragmentMigratorWithBackup.this.fragToMigrate.getId(), FileUtils.getLocalizedMessage((IOException)e), FragmentMigratorWithBackup.this.getBackupDirectory(), FragmentMigratorWithBackup.this.fragToMigrate.getDataDirectory()});
                    FragmentMigratorWithBackup.this.getMigrationReporter().getResultReporter().println(msg);
                    FragmentMigratorWithBackup.this.getMigrationReporter().getLogger().println(msg);
                    FragmentMigratorWithBackup.this.getMigrationReporter().getLogger().printStackTrace((Throwable)e);
                }
            }
        }
    }
}

