/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.migration;

import org.modelio.vbasic.log.IBasicLogger;
import org.modelio.vcore.model.spi.mm.IMigrationReporter;

final class NestedBasicLogger
implements IBasicLogger {
    private static final String PREFIX = "  > log ";
    private IBasicLogger wrapped;
    private IMigrationReporter.IMigrationLogger writer;

    public NestedBasicLogger(IBasicLogger oldLog, IMigrationReporter.IMigrationLogger logger) {
        this.wrapped = oldLog;
        this.writer = logger;
    }

    public void warning(String message) {
        this.wrapped.warning(message);
        this.writer.println("  > log WARNING: " + message);
    }

    public void warning(Throwable ex) {
        this.wrapped.warning(ex);
        this.writer.append((CharSequence)PREFIX);
        this.writer.append((CharSequence)"WARNING: ");
        this.writer.printStackTrace(ex);
        this.writer.println();
    }

    public void warning(String format, Object ... args) {
        this.wrapped.warning(format, args);
        this.writer.printf("  > log WARNING: " + format + "%n", args);
    }

    public void trace(Throwable ex) {
        this.wrapped.trace(ex);
        this.writer.append((CharSequence)"  > log trace: ");
        this.writer.printStackTrace(ex);
        this.writer.println();
    }

    public void trace(String format, Object ... args) {
        this.wrapped.trace(format, args);
        this.writer.printf("  > log trace: " + format + "%n", args);
    }

    public void trace(String message) {
        this.wrapped.trace(message);
        this.writer.println("  > log trace: " + message);
    }

    public void error(Throwable ex) {
        this.wrapped.error(ex);
        this.writer.append((CharSequence)"  > log ERROR: ");
        this.writer.printStackTrace(ex);
        this.writer.println();
    }

    public void error(String format, Object ... args) {
        this.wrapped.error(format, args);
        this.writer.printf("  > log ERROR: " + format + "%n", args);
    }

    public void error(String message) {
        this.wrapped.error(message);
        this.writer.println("  > log ERROR: " + message);
    }

    public int getLevel() {
        return 0;
    }

    public void setLevel(int level) {
    }
}

